/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.function.tags;

import docking.widgets.table.AbstractDynamicTableColumnStub;
import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.TableColumnDescriptor;
import docking.widgets.table.threaded.ThreadedTableModel;
import ghidra.app.plugin.core.function.tags.FunctionTagRowObject;
import ghidra.app.plugin.core.function.tags.TagListPanel;
import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.FunctionTag;
import ghidra.program.model.listing.FunctionTagManager;
import ghidra.program.model.listing.Program;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.Set;

public class FunctionTagTableModel
extends ThreadedTableModel<FunctionTagRowObject, Program> {
    private Program program;
    private TagListPanel tagListPanel;

    protected FunctionTagTableModel(String modelName, ServiceProvider serviceProvider, TagListPanel tagLoader) {
        super(modelName, serviceProvider);
        this.tagListPanel = tagLoader;
    }

    public void setProgram(Program program) {
        this.program = program;
    }

    protected void doLoad(Accumulator<FunctionTagRowObject> accumulator, TaskMonitor monitor) throws CancelledException {
        if (this.program == null) {
            return;
        }
        FunctionManager functionManager = this.program.getFunctionManager();
        FunctionTagManager tagManager = functionManager.getFunctionTagManager();
        Set<FunctionTag> tags = this.tagListPanel.backgroundLoadTags();
        monitor.initialize((long)tags.size());
        for (FunctionTag tag : tags) {
            monitor.checkCancelled();
            accumulator.add((Object)new FunctionTagRowObject(tag, tagManager.getUseCount(tag)));
            monitor.incrementProgress(1L);
        }
    }

    protected TableColumnDescriptor<FunctionTagRowObject> createTableColumnDescriptor() {
        TableColumnDescriptor descriptor = new TableColumnDescriptor();
        descriptor.addVisibleColumn((DynamicTableColumn)new FunctionTagNameColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new FunctionTagCountColumn());
        return descriptor;
    }

    public Program getDataSource() {
        return this.program;
    }

    public void clear() {
        super.clearData();
    }

    public boolean containsTag(String name) {
        return this.getRowObject(name) != null;
    }

    public FunctionTagRowObject getRowObject(String name) {
        return this.getAllData().stream().filter(row -> row.getName().equals(name)).findFirst().orElseGet(() -> null);
    }

    private class FunctionTagNameColumn
    extends AbstractDynamicTableColumnStub<FunctionTagRowObject, String> {
        private FunctionTagNameColumn() {
        }

        public String getColumnName() {
            return "Name";
        }

        public String getValue(FunctionTagRowObject rowObject, Settings settings, ServiceProvider sp) throws IllegalArgumentException {
            return rowObject.getName();
        }
    }

    private class FunctionTagCountColumn
    extends AbstractDynamicTableColumnStub<FunctionTagRowObject, Integer> {
        private FunctionTagCountColumn() {
        }

        public String getColumnDisplayName(Settings settings) {
            return " ";
        }

        public String getColumnName() {
            return "Count";
        }

        public int getColumnPreferredWidth() {
            return 30;
        }

        public Integer getValue(FunctionTagRowObject rowObject, Settings settings, ServiceProvider sp) throws IllegalArgumentException {
            return rowObject.getCount();
        }
    }
}

