/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.memory;

import ghidra.app.cmd.memory.AddBitMappedMemoryBlockCmd;
import ghidra.app.cmd.memory.AddByteMappedMemoryBlockCmd;
import ghidra.app.cmd.memory.AddFileBytesMemoryBlockCmd;
import ghidra.app.cmd.memory.AddInitializedMemoryBlockCmd;
import ghidra.app.cmd.memory.AddUninitializedMemoryBlockCmd;
import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.database.mem.ByteMappingScheme;
import ghidra.program.database.mem.FileBytes;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.mem.MemoryBlockType;
import ghidra.util.datastruct.StringKeyIndexer;
import ghidra.util.exception.AssertException;
import javax.swing.event.ChangeListener;

class AddBlockModel {
    private PluginTool tool;
    private Program program;
    private StringKeyIndexer nameIndexer;
    private String blockName;
    private Address startAddr;
    private Address baseAddr;
    private int schemeDestByteCount;
    private int schemeSrcByteCount;
    private long length;
    private MemoryBlockType blockType;
    private boolean isOverlay;
    private int initialValue;
    private String message;
    private ChangeListener listener;
    private boolean isValid;
    private boolean isRead;
    private boolean isWrite;
    private boolean isExecute;
    private boolean isVolatile;
    private InitializedType initializedType;
    private String comment;
    private FileBytes fileBytes;
    private long fileBytesOffset = -1L;

    AddBlockModel(PluginTool tool, Program program) {
        this.tool = tool;
        this.program = program;
        this.nameIndexer = new StringKeyIndexer();
        this.loadBlockNames();
        this.startAddr = program.getImageBase();
        this.blockType = MemoryBlockType.DEFAULT;
        this.initialValue = 0;
    }

    void setChangeListener(ChangeListener listener) {
        this.listener = listener;
    }

    void setBlockName(String name) {
        this.blockName = name;
        this.validateInfo();
        this.listener.stateChanged(null);
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    void setStartAddress(Address addr) {
        this.startAddr = addr;
        this.validateInfo();
        this.listener.stateChanged(null);
    }

    void setLength(long length) {
        this.length = length;
        this.validateInfo();
        this.listener.stateChanged(null);
    }

    void setFileOffset(long fileOffset) {
        this.fileBytesOffset = fileOffset;
        this.validateInfo();
        this.listener.stateChanged(null);
    }

    void setFileBytes(FileBytes fileBytes) {
        this.fileBytes = fileBytes;
        this.validateInfo();
        this.listener.stateChanged(null);
    }

    void setInitialValue(int initialValue) {
        this.initialValue = initialValue;
        this.validateInfo();
        this.listener.stateChanged(null);
    }

    void setBlockType(MemoryBlockType blockType) {
        this.blockType = blockType;
        this.isRead = true;
        this.isWrite = true;
        this.isExecute = false;
        this.isVolatile = false;
        this.isOverlay = false;
        this.schemeDestByteCount = blockType == MemoryBlockType.BIT_MAPPED ? 8 : 1;
        this.schemeSrcByteCount = 1;
        this.initializedType = InitializedType.UNINITIALIZED;
        this.validateInfo();
        this.listener.stateChanged(null);
    }

    void setRead(boolean b) {
        this.isRead = b;
    }

    void setWrite(boolean b) {
        this.isWrite = b;
    }

    void setExecute(boolean b) {
        this.isExecute = b;
    }

    void setVolatile(boolean b) {
        this.isVolatile = b;
    }

    void setOverlay(boolean b) {
        this.isOverlay = b;
        this.validateInfo();
        this.listener.stateChanged(null);
    }

    void setInitializedType(InitializedType type) {
        this.initializedType = type;
        this.validateInfo();
        this.listener.stateChanged(null);
    }

    void setBaseAddress(Address baseAddr) {
        this.baseAddr = baseAddr;
        this.validateInfo();
        this.listener.stateChanged(null);
    }

    void setSchemeSrcByteCount(int value) {
        this.schemeSrcByteCount = value;
        this.validateInfo();
        this.listener.stateChanged(null);
    }

    int getSchemeSrcByteCount() {
        return this.schemeSrcByteCount;
    }

    void setSchemeDestByteCount(int value) {
        this.schemeDestByteCount = value;
        this.validateInfo();
        this.listener.stateChanged(null);
    }

    int getSchemeDestByteCount() {
        return this.schemeDestByteCount;
    }

    Address getStartAddress() {
        return this.startAddr;
    }

    MemoryBlockType getBlockType() {
        return this.blockType;
    }

    int getInitialValue() {
        return this.initialValue;
    }

    boolean isValidInfo() {
        return this.isValid;
    }

    String getMessage() {
        return this.message;
    }

    Program getProgram() {
        return this.program;
    }

    boolean isRead() {
        return this.isRead;
    }

    boolean isWrite() {
        return this.isWrite;
    }

    boolean isExecute() {
        return this.isExecute;
    }

    boolean isVolatile() {
        return this.isVolatile;
    }

    boolean isOverlay() {
        return this.isOverlay;
    }

    InitializedType getInitializedType() {
        return this.initializedType;
    }

    boolean execute() {
        this.validateInfo();
        if (!this.isValid) {
            return false;
        }
        Command cmd = this.createAddBlockCommand();
        if (!this.tool.execute(cmd, (DomainObject)this.program)) {
            this.message = cmd.getStatusMsg();
            return false;
        }
        return true;
    }

    Command createAddBlockCommand() {
        String source = "";
        switch (this.blockType) {
            case BIT_MAPPED: {
                return new AddBitMappedMemoryBlockCmd(this.blockName, this.comment, source, this.startAddr, this.length, this.isRead, this.isWrite, this.isExecute, this.isVolatile, this.baseAddr, this.isOverlay);
            }
            case BYTE_MAPPED: {
                ByteMappingScheme byteMappingScheme = new ByteMappingScheme(this.schemeDestByteCount, this.schemeSrcByteCount);
                return new AddByteMappedMemoryBlockCmd(this.blockName, this.comment, source, this.startAddr, this.length, this.isRead, this.isWrite, this.isExecute, this.isVolatile, this.baseAddr, byteMappingScheme, this.isOverlay);
            }
            case DEFAULT: {
                return this.createNonMappedMemoryBlock(source);
            }
        }
        throw new AssertException("Encountered unexpected block type: " + this.blockType);
    }

    private Command createNonMappedMemoryBlock(String source) {
        switch (this.initializedType) {
            case INITIALIZED_FROM_FILE_BYTES: {
                return new AddFileBytesMemoryBlockCmd(this.blockName, this.comment, source, this.startAddr, this.length, this.isRead, this.isWrite, this.isExecute, this.isVolatile, this.fileBytes, this.fileBytesOffset, this.isOverlay);
            }
            case INITIALIZED_FROM_VALUE: {
                return new AddInitializedMemoryBlockCmd(this.blockName, this.comment, source, this.startAddr, this.length, this.isRead, this.isWrite, this.isExecute, this.isVolatile, (byte)this.initialValue, this.isOverlay);
            }
            case UNINITIALIZED: {
                return new AddUninitializedMemoryBlockCmd(this.blockName, this.comment, source, this.startAddr, this.length, this.isRead, this.isWrite, this.isExecute, this.isVolatile, this.isOverlay);
            }
        }
        throw new AssertException("Encountered unexpected intialized type: " + this.initializedType);
    }

    void dispose() {
        this.tool = null;
        this.program = null;
    }

    private void validateInfo() {
        this.message = "";
        this.isValid = this.hasValidName() && this.hasValidStartAddress() && this.hasValidLength() && this.hasNoMemoryConflicts() && this.hasMappedAddressIfNeeded() && this.hasInitialValueIfNeeded() && this.hasFileBytesInfoIfNeeded() && this.isOverlayIfOtherSpace();
    }

    private boolean hasFileBytesInfoIfNeeded() {
        if (this.initializedType != InitializedType.INITIALIZED_FROM_FILE_BYTES) {
            return true;
        }
        if (this.fileBytes == null) {
            this.message = "Please select a FileBytes entry";
            return false;
        }
        if (this.fileBytesOffset < 0L || this.fileBytesOffset >= this.fileBytes.getSize()) {
            this.message = "Please enter a valid file bytes offset (0 - " + (this.fileBytes.getSize() - 1L) + ")";
            return false;
        }
        if (this.fileBytesOffset + this.length > this.fileBytes.getSize()) {
            this.message = "File bytes offset + length exceeds file bytes size: " + this.fileBytes.getSize();
            return false;
        }
        return true;
    }

    private boolean hasInitialValueIfNeeded() {
        if (this.initializedType != InitializedType.INITIALIZED_FROM_VALUE) {
            return true;
        }
        if (this.initialValue >= 0 && this.initialValue <= 255) {
            return true;
        }
        this.message = "Please enter a valid initial byte value";
        return false;
    }

    private boolean isOverlayIfOtherSpace() {
        if (this.startAddr.getAddressSpace().equals(AddressSpace.OTHER_SPACE) && !this.isOverlay) {
            this.message = "Blocks defined in the " + AddressSpace.OTHER_SPACE.getName() + " space must be overlay blocks";
            return false;
        }
        return true;
    }

    private boolean hasMappedAddressIfNeeded() {
        if (this.blockType != MemoryBlockType.BIT_MAPPED && this.blockType != MemoryBlockType.BYTE_MAPPED) {
            return true;
        }
        if (this.baseAddr == null) {
            this.message = "Please enter a valid mapped region Source Address";
            return false;
        }
        if (this.blockType == MemoryBlockType.BYTE_MAPPED) {
            if (this.schemeDestByteCount <= 0 || this.schemeDestByteCount > 127 || this.schemeSrcByteCount <= 0 || this.schemeSrcByteCount > 127) {
                this.message = "Mapping Ratio values must be within range: 1 to 127";
                return false;
            }
            if (this.schemeDestByteCount > this.schemeSrcByteCount) {
                this.message = "Mapping Ratio destination byte count (left-value) must be less than or equal the source byte count (right-value)";
                return false;
            }
            try {
                long lastOffset = this.length - 1L;
                long sourceOffset = (long)this.schemeSrcByteCount * (lastOffset / (long)this.schemeDestByteCount) + lastOffset % (long)this.schemeDestByteCount;
                this.baseAddr.addNoWrap(sourceOffset);
            }
            catch (AddressOverflowException e) {
                this.message = "Insufficient space in byte-mapped source region at " + this.baseAddr.toString(true);
                return false;
            }
        }
        if (this.blockType == MemoryBlockType.BIT_MAPPED) {
            try {
                this.baseAddr.addNoWrap((this.length - 1L) / 8L);
            }
            catch (AddressOverflowException e) {
                this.message = "Insufficient space in bit-mapped source region at " + this.baseAddr.toString(true);
                return false;
            }
        }
        return true;
    }

    private boolean hasNoMemoryConflicts() {
        if (this.isOverlay) {
            return true;
        }
        Address endAddr = this.startAddr.add(this.length - 1L);
        AddressSet intersectRange = this.program.getMemory().intersectRange(this.startAddr, endAddr);
        if (!intersectRange.isEmpty()) {
            AddressRange firstRange = intersectRange.getFirstRange();
            this.message = "Block address conflict: " + firstRange;
            return false;
        }
        return true;
    }

    private boolean hasValidLength() {
        long limit = 0x400000000L;
        long spaceLimit = this.startAddr.getAddressSpace().getMaxAddress().subtract(this.startAddr);
        if (spaceLimit >= 0L) {
            limit = Math.min(limit, spaceLimit + 1L);
        }
        if (this.length > 0L && this.length <= limit) {
            return true;
        }
        this.message = "Please enter a valid Length: 1 to 0x" + Long.toHexString(limit);
        return false;
    }

    private boolean hasValidStartAddress() {
        if (this.startAddr != null) {
            return true;
        }
        this.message = "Please enter a valid Start Address";
        return false;
    }

    private boolean hasValidName() {
        if (this.blockName == null || this.blockName.length() == 0) {
            this.message = "Please enter a Block Name";
            return false;
        }
        if (!Memory.isValidMemoryBlockName((String)this.blockName)) {
            this.message = "Block Name is invalid";
            return false;
        }
        if (this.nameExists(this.blockName)) {
            this.message = "Warning! Duplicate Block Name";
        }
        return true;
    }

    private boolean nameExists(String name) {
        return this.nameIndexer.get(name) >= 0;
    }

    private void loadBlockNames() {
        MemoryBlock[] blocks;
        Memory memory = this.program.getMemory();
        for (MemoryBlock block : blocks = memory.getBlocks()) {
            this.nameIndexer.put(block.getName());
        }
    }

    static enum InitializedType {
        UNINITIALIZED,
        INITIALIZED_FROM_VALUE,
        INITIALIZED_FROM_FILE_BYTES;

    }
}

