/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.misc;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.ToolBarData;
import generic.theme.GColor;
import generic.theme.GIcon;
import ghidra.app.plugin.ProgramPlugin;
import ghidra.app.services.MarkerService;
import ghidra.app.services.MarkerSet;
import ghidra.framework.client.ClientUtil;
import ghidra.framework.client.RepositoryAdapter;
import ghidra.framework.data.DomainObjectAdapterDB;
import ghidra.framework.main.AppInfo;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolderChangeListener;
import ghidra.framework.model.DomainFolderListenerAdapter;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.model.TransactionInfo;
import ghidra.framework.model.TransactionListener;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetCollection;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.SingleAddressSetCollection;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramChangeSet;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.SwingUpdateManager;
import ghidra.util.task.TaskMonitor;
import ghidra.util.worker.Job;
import ghidra.util.worker.Worker;
import java.awt.Color;
import java.awt.Component;
import java.io.IOException;
import javax.swing.Icon;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Code Viewer", shortDescription="Indicates areas that have changed", description="This plugin tracks program changes and indicates those areas by creating changebars via the marker manager.  In addition to showing current changes, it also tracks and displays changes by others if the program is shared.", servicesRequired={MarkerService.class})
public class MyProgramChangesDisplayPlugin
extends ProgramPlugin
implements DomainObjectListener {
    private static final int CHANGES_SINCE_CO_PRIORITY = -50;
    private static final int MY_CHANGE_PRIORITY = -49;
    private static final int OTHER_CHANGES_PRIORITY = -48;
    private static final int CONFLICT_PRIORITY = -47;
    private static final Color BG_COLOR_MARKER_UNSAVED = new GColor("color.bg.plugin.myprogramchangesdisplay.markers.changes.unsaved");
    private static final Color BG_COLOR_MARKER_CONFLICTING = new GColor("color.bg.plugin.myprogramchangesdisplay.markers.changes.conflicting");
    private static final Color BG_COLOR_MARKER_LATEST = new GColor("color.bg.plugin.myprogramchangesdisplay.markers.changes.latest.version");
    private static final Color BG_COLOR_MARKER_NOT_CHECKED_IN = new GColor("color.bg.plugin.myprogramchangesdisplay.markers.changes.not.checked.in");
    private MarkerService markerService;
    private MarkerSet currentMyChangeMarks;
    private MarkerSet currentChangesSinceCheckoutMarks;
    private MarkerSet currentOtherChangeMarks;
    private MarkerSet currentConflictChangeMarks;
    private ProgramFolderListener folderListener;
    private TransactionListener transactionListener;
    private SwingUpdateManager updateManager;
    private Worker worker = Worker.createGuiWorker();
    private DockingAction checkInAction;
    private DockingAction mergeAction;
    private AddressSetView otherChangeSet;
    private int serverVersion = -1;
    private int localVersion = -1;
    private boolean programChangedLocally;
    private boolean programChangedRemotely;
    private boolean programSaved;
    private boolean updateConflicts;

    public MyProgramChangesDisplayPlugin(PluginTool tool) {
        super(tool);
        this.folderListener = new ProgramFolderListener();
        this.transactionListener = new ProgramTransactionListener();
        tool.getProject().getProjectData().addDomainFolderChangeListener((DomainFolderChangeListener)this.folderListener);
        this.createActions();
    }

    private void createActions() {
        GIcon icon = new GIcon("icon.plugin.myprogramchanges.merge");
        this.mergeAction = new DockingAction("Update", this.getName()){

            public void actionPerformed(ActionContext context) {
                AppInfo.getFrontEndTool().merge(MyProgramChangesDisplayPlugin.this.tool, MyProgramChangesDisplayPlugin.this.currentProgram.getDomainFile(), null);
            }

            public boolean isEnabledForContext(ActionContext context) {
                return MyProgramChangesDisplayPlugin.this.currentProgram != null && MyProgramChangesDisplayPlugin.this.currentProgram.getDomainFile().canMerge();
            }
        };
        this.mergeAction.setToolBarData(new ToolBarData((Icon)icon, "Repository"));
        this.mergeAction.setDescription("Update checked out file with latest version");
        this.mergeAction.setHelpLocation(new HelpLocation("VersionControl", this.mergeAction.getName()));
        icon = new GIcon("icon.plugin.myprogramchanges.checkin");
        this.checkInAction = new DockingAction("CheckIn", this.getName()){

            public void actionPerformed(ActionContext context) {
                AppInfo.getFrontEndTool().checkIn(MyProgramChangesDisplayPlugin.this.tool, MyProgramChangesDisplayPlugin.this.currentProgram.getDomainFile());
            }

            public boolean isEnabledForContext(ActionContext context) {
                return MyProgramChangesDisplayPlugin.this.currentProgram != null && MyProgramChangesDisplayPlugin.this.currentProgram.getDomainFile().modifiedSinceCheckout();
            }
        };
        this.checkInAction.setToolBarData(new ToolBarData((Icon)icon, "Repository"));
        this.checkInAction.setDescription("Check in file");
        this.checkInAction.setHelpLocation(new HelpLocation("VersionControl", this.checkInAction.getName()));
        this.tool.addAction((DockingActionIf)this.mergeAction);
        this.tool.addAction((DockingActionIf)this.checkInAction);
    }

    public void init() {
        this.markerService = (MarkerService)this.tool.getService(MarkerService.class);
        this.updateManager = new SwingUpdateManager(1000, () -> this.updateChangeMarkers());
    }

    @Override
    protected void programActivated(Program program) {
        program.addListener((DomainObjectListener)this);
        program.addTransactionListener(this.transactionListener);
        this.updateForDomainFileChanged();
        this.createMarkerSets(program);
        this.intializeChangeMarkers();
    }

    @Override
    protected void programDeactivated(Program program) {
        this.serverVersion = -1;
        this.localVersion = -1;
        this.programChangedLocally = false;
        this.programChangedRemotely = false;
        this.programSaved = false;
        program.removeTransactionListener(this.transactionListener);
        program.removeListener((DomainObjectListener)this);
        this.disposeMarkerSets(program);
    }

    private void intializeChangeMarkers() {
        this.programChangedLocally = true;
        this.programChangedRemotely = true;
        this.programSaved = true;
        this.updateConflicts = true;
        this.updateChangeMarkers();
    }

    private void createMarkerSets(Program program) {
        this.currentMyChangeMarks = this.markerService.createAreaMarker("Changes: Unsaved", "My changes not yet saved", program, -49, true, true, false, BG_COLOR_MARKER_UNSAVED);
        if (program.getDomainFile().isCheckedOut()) {
            this.trackServerChanges(program);
        }
    }

    private void trackServerChanges(Program program) {
        this.currentChangesSinceCheckoutMarks = this.markerService.createAreaMarker("Changes: Not Checked-In", "My saved changes made since I checked it out", program, -50, true, true, false, BG_COLOR_MARKER_NOT_CHECKED_IN);
        this.currentOtherChangeMarks = this.markerService.createAreaMarker("Changes: Latest Version", "Changes made by others to this program since I checked it out", program, -48, true, true, false, BG_COLOR_MARKER_LATEST);
        this.currentConflictChangeMarks = this.markerService.createAreaMarker("Changes: Conflicting", "Changes made by others to this program that conflict with my changes", program, -47, true, true, false, BG_COLOR_MARKER_CONFLICTING);
    }

    private void disposeMarkerSets(Program program) {
        this.markerService.removeMarker(this.currentMyChangeMarks, program);
        this.markerService.removeMarker(this.currentChangesSinceCheckoutMarks, program);
        this.markerService.removeMarker(this.currentOtherChangeMarks, program);
        this.markerService.removeMarker(this.currentConflictChangeMarks, program);
        this.currentMyChangeMarks = null;
        this.currentChangesSinceCheckoutMarks = null;
        this.currentOtherChangeMarks = null;
        this.currentConflictChangeMarks = null;
    }

    public void dispose() {
        this.worker.dispose();
        if (this.currentProgram != null) {
            this.currentProgram.removeTransactionListener(this.transactionListener);
            this.currentProgram.removeListener((DomainObjectListener)this);
        }
        this.tool.getProject().getProjectData().removeDomainFolderChangeListener((DomainFolderChangeListener)this.folderListener);
        if (this.updateManager != null) {
            this.updateManager.dispose();
            this.updateManager = null;
        }
        if (this.currentProgram != null) {
            this.disposeMarkerSets(this.currentProgram);
        }
        this.markerService = null;
        super.dispose();
    }

    private void updateChangeMarkers() {
        Swing.assertSwingThread((String)"Change markers must be manipulated on the Swing thread");
        if (this.currentProgram == null) {
            return;
        }
        ProgramChangeSet changeSet = this.currentProgram.getChanges();
        if (this.programChangedLocally) {
            this.currentMyChangeMarks.setAddressSetCollection(changeSet.getAddressSetCollectionSinceLastSave());
        }
        if (this.isTrackingServerChanges()) {
            if (this.programSaved) {
                this.currentChangesSinceCheckoutMarks.setAddressSetCollection(changeSet.getAddressSetCollectionSinceCheckout());
            }
            if (this.programChangedRemotely) {
                this.currentOtherChangeMarks.setAddressSetCollection((AddressSetCollection)new SingleAddressSetCollection(this.otherChangeSet));
            }
            if (this.programChangedRemotely || this.updateConflicts) {
                AddressSet intersect = changeSet.getAddressSetCollectionSinceCheckout().getCombinedAddressSet().intersect(this.otherChangeSet);
                this.currentConflictChangeMarks.setAddressSetCollection((AddressSetCollection)new SingleAddressSetCollection((AddressSetView)intersect));
            }
        }
        this.programChangedLocally = false;
        this.programChangedRemotely = false;
        this.programSaved = false;
        this.updateConflicts = false;
    }

    private void updateForDomainFileChanged() {
        DomainFile df = this.currentProgram.getDomainFile();
        int latestServerVersion = df.getLatestVersion();
        int latestLocalVersion = df.getVersion();
        if (df.isCheckedOut() && this.serverVersion != latestServerVersion) {
            this.serverVersion = latestServerVersion;
            this.localVersion = latestLocalVersion;
            if (this.serverVersion == this.localVersion) {
                this.otherChangeSet = new AddressSet();
                this.programChangedRemotely = true;
                this.updateManager.update();
            } else {
                this.scheduleUpdatesFromServer(this.currentProgram);
            }
        } else if (latestLocalVersion != this.localVersion) {
            this.localVersion = latestLocalVersion;
            this.updateConflicts = true;
            this.updateManager.update();
        }
    }

    private void scheduleUpdatesFromServer(Program p) {
        this.worker.clearPendingJobs();
        DomainFile file = p.getDomainFile();
        this.worker.schedule((Job)new UpdateChangeSetJob(file));
    }

    public boolean isTrackingServerChanges() {
        return this.currentChangesSinceCheckoutMarks != null;
    }

    public void domainObjectChanged(DomainObjectChangedEvent ev) {
        this.programChangedLocally = true;
        if (ev.containsEvent(1)) {
            this.programSaved = true;
        }
        this.updateManager.update();
    }

    Worker getWorker() {
        return this.worker;
    }

    MarkerSet getExternalChangeMarkers() {
        return this.currentOtherChangeMarks;
    }

    private class ProgramFolderListener
    extends DomainFolderListenerAdapter {
        private ProgramFolderListener() {
        }

        public void domainFileStatusChanged(DomainFile file, boolean fileIDset) {
            Swing.runLater(() -> {
                if (MyProgramChangesDisplayPlugin.this.currentProgram == null) {
                    return;
                }
                DomainFile domainFile = MyProgramChangesDisplayPlugin.this.currentProgram.getDomainFile();
                if (!file.equals(domainFile)) {
                    return;
                }
                if (domainFile.isCheckedOut()) {
                    if (!MyProgramChangesDisplayPlugin.this.isTrackingServerChanges()) {
                        MyProgramChangesDisplayPlugin.this.trackServerChanges(MyProgramChangesDisplayPlugin.this.currentProgram);
                    }
                    MyProgramChangesDisplayPlugin.this.updateForDomainFileChanged();
                }
            });
        }
    }

    private class ProgramTransactionListener
    implements TransactionListener {
        private ProgramTransactionListener() {
        }

        public void transactionStarted(DomainObjectAdapterDB domainObj, TransactionInfo tx) {
        }

        public void transactionEnded(DomainObjectAdapterDB domainObj) {
            MyProgramChangesDisplayPlugin.this.updateConflicts = true;
            MyProgramChangesDisplayPlugin.this.updateManager.update();
        }

        public void undoStackChanged(DomainObjectAdapterDB domainObj) {
        }

        public void undoRedoOccurred(DomainObjectAdapterDB domainObj) {
            MyProgramChangesDisplayPlugin.this.updateConflicts = true;
            MyProgramChangesDisplayPlugin.this.updateManager.update();
        }
    }

    private class UpdateChangeSetJob
    extends Job {
        private DomainFile domainFile;

        UpdateChangeSetJob(DomainFile domainFile) {
            this.domainFile = domainFile;
        }

        public void run(TaskMonitor monitor) throws CancelledException {
            monitor.checkCancelled();
            ProgramChangeSet changes = null;
            try {
                changes = (ProgramChangeSet)this.domainFile.getChangesByOthersSinceCheckout();
            }
            catch (IOException e) {
                Msg.warn((Object)((Object)this), (Object)("Unable to determine program change set: " + e.getMessage()));
                return;
            }
            catch (Exception e) {
                ClientUtil.handleException((RepositoryAdapter)MyProgramChangesDisplayPlugin.this.tool.getProject().getRepository(), (Exception)e, (String)"Get Change Set", (boolean)false, (Component)MyProgramChangesDisplayPlugin.this.tool.getToolFrame());
                return;
            }
            AddressSetView remoteChanges = changes != null ? changes.getAddressSet() : new AddressSet();
            Swing.runNow(() -> this.applyChanges(remoteChanges));
        }

        private void applyChanges(AddressSetView remoteChanges) {
            if (MyProgramChangesDisplayPlugin.this.isDisposed()) {
                return;
            }
            MyProgramChangesDisplayPlugin.this.otherChangeSet = remoteChanges;
            MyProgramChangesDisplayPlugin.this.programChangedRemotely = true;
            MyProgramChangesDisplayPlugin.this.updateManager.update();
        }
    }
}

