/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.osgi;

import docking.widgets.table.AbstractDynamicTableColumn;
import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.GDynamicColumnTableModel;
import docking.widgets.table.GTableCellRenderingData;
import docking.widgets.table.TableColumnDescriptor;
import docking.widgets.table.TableSortState;
import docking.widgets.table.TableSortingContext;
import generic.jar.ResourceFile;
import generic.theme.GColor;
import generic.theme.GThemeDefaults;
import generic.util.Path;
import ghidra.app.plugin.core.osgi.BundleHost;
import ghidra.app.plugin.core.osgi.BundleHostListener;
import ghidra.app.plugin.core.osgi.BundleStatus;
import ghidra.app.plugin.core.osgi.BundleStatusChangeRequestListener;
import ghidra.app.plugin.core.osgi.BundleStatusComponentProvider;
import ghidra.app.plugin.core.osgi.GhidraBundle;
import ghidra.app.plugin.core.osgi.GhidraBundleException;
import ghidra.app.plugin.core.osgi.GhidraPlaceholderBundle;
import ghidra.app.plugin.core.osgi.OSGiUtils;
import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.util.Swing;
import ghidra.util.SystemUtilities;
import ghidra.util.table.column.AbstractGColumnRenderer;
import ghidra.util.table.column.GColumnRenderer;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.swing.JLabel;
import javax.swing.event.TableModelEvent;
import org.osgi.framework.Bundle;

public class BundleStatusTableModel
extends GDynamicColumnTableModel<BundleStatus, List<BundleStatus>> {
    private static final Color COLOR_BUNDLE_ERROR = GThemeDefaults.Colors.ERROR;
    private static final Color COLOR_BUNDLE_DISABLED = new GColor("color.fg.table.bundle.disabled");
    private static final Color COLOR_BUNDLE_BUSY = new GColor("color.fg.table.bundle.busy");
    private static final Color COLOR_BUNDLE_INACTIVE = new GColor("color.fg.table.bundle.inactive");
    private static final Color COLOR_BUNDLE_ACTIVE = new GColor("color.fg.table.bundle.active");
    private BundleHost bundleHost;
    private BundleStatusComponentProvider provider;
    private Map<String, BundleStatus> bundleLocToStatusMap = new HashMap<String, BundleStatus>();
    private BundleHostListener bundleHostListener;
    private List<BundleStatusChangeRequestListener> bundleStatusListeners = new CopyOnWriteArrayList<BundleStatusChangeRequestListener>();
    private List<BundleStatus> statuses;

    BundleStatusTableModel(BundleStatusComponentProvider provider, BundleHost bundleHost) {
        super((ServiceProvider)provider.getTool());
        this.provider = provider;
        this.bundleHost = bundleHost;
        this.statuses = new ArrayList<BundleStatus>();
        for (GhidraBundle bundle : bundleHost.getGhidraBundles()) {
            this.addNewStatus(bundle);
        }
        this.bundleHostListener = new MyBundleHostListener();
        bundleHost.addListener(this.bundleHostListener);
        this.setDefaultTableSortState(TableSortState.createDefaultSortState((int)1, (boolean)true));
    }

    private BundleStatus getStatus(GhidraBundle bundle) {
        return this.getStatusFromLocation(bundle.getLocationIdentifier());
    }

    private BundleStatus getStatusFromLocation(String bundleLoc) {
        return this.bundleLocToStatusMap.get(bundleLoc);
    }

    public void dispose() {
        super.dispose();
        this.bundleHost.removeListener(this.bundleHostListener);
    }

    public void fireTableChanged(TableModelEvent e) {
        Swing.runIfSwingOrRunLater(() -> BundleStatusTableModel.super.fireTableChanged(e));
    }

    private void addNewStatusNoFire(GhidraBundle bundle) {
        BundleStatus status = new BundleStatus(bundle.getFile(), bundle.isEnabled(), bundle.isSystemBundle(), bundle.getLocationIdentifier());
        if (this.statuses.contains(status)) {
            throw new RuntimeException("Bundle status manager already contains " + bundle.getFile().toString());
        }
        status.setActive(bundle.isActive());
        this.bundleLocToStatusMap.put(status.getLocationIdentifier(), status);
        this.statuses.add(status);
    }

    private void addNewStatus(GhidraBundle bundle) {
        Swing.runLater(() -> {
            int index = this.statuses.size();
            this.addNewStatusNoFire(bundle);
            this.fireTableRowsInserted(index, index);
        });
    }

    private int removeStatusNoFire(BundleStatus status) {
        if (!status.isReadOnly()) {
            int statusIndex = this.statuses.indexOf(status);
            this.statuses.remove(statusIndex);
            this.bundleLocToStatusMap.remove(status.getLocationIdentifier());
            return statusIndex;
        }
        return -1;
    }

    void removeStatus(BundleStatus status) {
        Swing.runLater(() -> {
            int rowIndex = this.removeStatusNoFire(status);
            if (rowIndex >= 0) {
                this.fireTableRowsDeleted(rowIndex, rowIndex);
            }
        });
    }

    void removeStatuses(List<BundleStatus> toRemove) {
        Swing.runLater(() -> {
            for (BundleStatus status : toRemove) {
                this.removeStatusNoFire(status);
            }
            this.fireTableDataChanged();
        });
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        BundleStatus status = this.statuses.get(rowIndex);
        return ((Column)this.getColumn(columnIndex)).isEditable(status);
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        BundleStatus status = this.statuses.get(rowIndex);
        Column column = (Column)this.getColumn(columnIndex);
        if (column.getColumnClass().isInstance(aValue)) {
            column.setValue(status, aValue);
            this.provider.selectModelRow(rowIndex);
        }
    }

    public boolean isSortable(int columnIndex) {
        return true;
    }

    public String getName() {
        return BundleStatusTableModel.class.getSimpleName();
    }

    public List<BundleStatus> getModelData() {
        return this.statuses;
    }

    void setModelData(List<BundleStatus> statuses) {
        this.statuses = statuses;
        this.computeCache();
        this.fireTableDataChanged();
    }

    public void addListener(BundleStatusChangeRequestListener listener) {
        if (!this.bundleStatusListeners.contains(listener)) {
            this.bundleStatusListeners.add(listener);
        }
    }

    public void removeListener(BundleStatusChangeRequestListener listener) {
        this.bundleStatusListeners.remove(listener);
    }

    void fireBundleEnablementChangeRequested(BundleStatus status, boolean newValue) {
        for (BundleStatusChangeRequestListener listener : this.bundleStatusListeners) {
            listener.bundleEnablementChangeRequest(status, newValue);
        }
    }

    void fireBundleActivationChangeRequested(BundleStatus status, boolean newValue) {
        for (BundleStatusChangeRequestListener listener : this.bundleStatusListeners) {
            listener.bundleActivationChangeRequest(status, newValue);
        }
    }

    public List<BundleStatus> getRowObjects(int[] modelRowIndices) {
        ArrayList<BundleStatus> rows = new ArrayList<BundleStatus>(modelRowIndices.length);
        for (int i : modelRowIndices) {
            rows.add((BundleStatus)this.getRowObject(i));
        }
        return rows;
    }

    protected void sort(List<BundleStatus> data, final TableSortingContext<BundleStatus> sortingContext) {
        SystemUtilities.assertThisIsTheSwingThread((String)"Must be called on the Swing thread");
        if (sortingContext.isUnsorted()) {
            this.sortCompleted(sortingContext);
            this.notifyModelSorted(false);
            return;
        }
        this.hasEverSorted = true;
        final AtomicBoolean changed = new AtomicBoolean(false);
        Comparator<BundleStatus> wrapper = new Comparator<BundleStatus>(){
            Comparator<BundleStatus> comparator;
            {
                this.comparator = sortingContext.getComparator();
            }

            @Override
            public int compare(BundleStatus o1, BundleStatus o2) {
                int result = this.comparator.compare(o1, o2);
                if (result < 0) {
                    changed.set(true);
                }
                return result;
            }
        };
        Collections.sort(data, wrapper);
        this.sortCompleted(sortingContext);
        if (changed.get()) {
            this.notifyModelSorted(false);
        }
    }

    private void computeCache() {
        this.bundleLocToStatusMap.clear();
        for (BundleStatus status : this.statuses) {
            this.bundleLocToStatusMap.put(status.getLocationIdentifier(), status);
        }
    }

    public List<BundleStatus> getDataSource() {
        return this.statuses;
    }

    protected TableColumnDescriptor<BundleStatus> createTableColumnDescriptor() {
        TableColumnDescriptor columnDescriptor = new TableColumnDescriptor();
        columnDescriptor.addVisibleColumn((DynamicTableColumn)new EnabledColumn());
        columnDescriptor.addVisibleColumn((DynamicTableColumn)new BundleFileColumn());
        columnDescriptor.addVisibleColumn((DynamicTableColumn)new BuildSummaryColumn());
        columnDescriptor.addHiddenColumn((DynamicTableColumn)new OSGiStatusColumn());
        columnDescriptor.addHiddenColumn((DynamicTableColumn)new BundleTypeColumn());
        return columnDescriptor;
    }

    protected class MyBundleHostListener
    implements BundleHostListener {
        protected MyBundleHostListener() {
        }

        @Override
        public void bundleBuilt(GhidraBundle bundle, String summary) {
            if (summary != null) {
                Swing.runLater(() -> {
                    BundleStatus status = BundleStatusTableModel.this.getStatus(bundle);
                    status.setSummary(summary);
                    int rowIndex = BundleStatusTableModel.this.getRowIndex(status);
                    BundleStatusTableModel.this.fireTableRowsUpdated(rowIndex, rowIndex);
                });
            }
        }

        @Override
        public void bundleActivationChange(GhidraBundle bundle, boolean newActivation) {
            Swing.runLater(() -> {
                BundleStatus status = BundleStatusTableModel.this.getStatus(bundle);
                int rowIndex = BundleStatusTableModel.this.getRowIndex(status);
                status.setBusy(false);
                if (newActivation) {
                    status.setActive(true);
                } else {
                    status.setActive(false);
                }
                BundleStatusTableModel.this.fireTableRowsUpdated(rowIndex, rowIndex);
            });
        }

        @Override
        public void bundleAdded(GhidraBundle bundle) {
            Swing.runLater(() -> BundleStatusTableModel.this.addNewStatus(bundle));
        }

        @Override
        public void bundlesAdded(Collection<GhidraBundle> bundles) {
            Swing.runLater(() -> {
                int index = BundleStatusTableModel.this.statuses.size();
                for (GhidraBundle bundle : bundles) {
                    BundleStatusTableModel.this.addNewStatusNoFire(bundle);
                }
                BundleStatusTableModel.this.fireTableRowsInserted(index, index + bundles.size() - 1);
            });
        }

        @Override
        public void bundleRemoved(GhidraBundle bundle) {
            Swing.runLater(() -> {
                BundleStatus status = BundleStatusTableModel.this.getStatus(bundle);
                BundleStatusTableModel.this.removeStatus(status);
            });
        }

        @Override
        public void bundlesRemoved(Collection<GhidraBundle> bundles) {
            Swing.runLater(() -> {
                List<BundleStatus> toRemove = bundles.stream().map(BundleStatusTableModel.this::getStatus).collect(Collectors.toUnmodifiableList());
                BundleStatusTableModel.this.removeStatuses(toRemove);
            });
        }

        @Override
        public void bundleEnablementChange(GhidraBundle bundle, boolean newEnablement) {
            Swing.runLater(() -> {
                BundleStatus status = BundleStatusTableModel.this.getStatus(bundle);
                status.setEnabled(newEnablement);
                int rowIndex = BundleStatusTableModel.this.getRowIndex(status);
                BundleStatusTableModel.this.fireTableRowsUpdated(rowIndex, rowIndex);
            });
        }

        @Override
        public void bundleException(GhidraBundleException exception) {
            Swing.runLater(() -> {
                BundleStatus status = BundleStatusTableModel.this.getStatusFromLocation(exception.getBundleLocation());
                if (status != null) {
                    status.setSummary(exception.getMessage());
                    int rowIndex = BundleStatusTableModel.this.getRowIndex(status);
                    BundleStatusTableModel.this.fireTableRowsUpdated(rowIndex, rowIndex);
                }
            });
        }
    }

    private abstract class Column<COLUMN_TYPE>
    extends AbstractDynamicTableColumn<BundleStatus, COLUMN_TYPE, List<BundleStatus>> {
        final String columnName;

        Column(String columnName) {
            this.columnName = columnName;
        }

        void setValue(BundleStatus status, COLUMN_TYPE aValue) {
            throw new RuntimeException(this.columnName + " is not editable!");
        }

        boolean isEditable(BundleStatus status) {
            return false;
        }

        public String getColumnName() {
            return this.columnName;
        }
    }

    private class EnabledColumn
    extends Column<Boolean> {
        EnabledColumn() {
            super("Enabled");
        }

        public Boolean getValue(BundleStatus status, Settings settings, List<BundleStatus> data, ServiceProvider serviceProvider0) throws IllegalArgumentException {
            return status.isEnabled();
        }

        public int getColumnPreferredWidth() {
            return 60;
        }

        @Override
        boolean isEditable(BundleStatus status) {
            return status.fileExists();
        }

        @Override
        void setValue(BundleStatus status, Boolean newValue) {
            BundleStatusTableModel.this.fireBundleEnablementChangeRequested(status, newValue);
        }
    }

    private class BundleFileColumn
    extends Column<ResourceFile> {
        final BundleFileRenderer renderer;
        final Comparator<ResourceFile> comparator;

        BundleFileColumn() {
            super("Path");
            this.renderer = new BundleFileRenderer();
            this.comparator = (a, b) -> Path.toPathString((ResourceFile)a).compareTo(Path.toPathString((ResourceFile)b));
        }

        public ResourceFile getValue(BundleStatus status, Settings settings, List<BundleStatus> data, ServiceProvider serviceProvider0) throws IllegalArgumentException {
            return status.getFile();
        }

        public GColumnRenderer<ResourceFile> getColumnRenderer() {
            return this.renderer;
        }

        public Comparator<ResourceFile> getComparator() {
            return this.comparator;
        }
    }

    private class BuildSummaryColumn
    extends Column<String> {
        BuildSummaryColumn() {
            super("Build Summary");
        }

        public String getValue(BundleStatus status, Settings settings, List<BundleStatus> data, ServiceProvider serviceProvider0) throws IllegalArgumentException {
            GhidraBundle bundle = BundleStatusTableModel.this.bundleHost.getGhidraBundle(status.getFile());
            if (bundle == null) {
                return "no bundle";
            }
            if (bundle instanceof GhidraPlaceholderBundle) {
                return ((GhidraPlaceholderBundle)bundle).getSummary();
            }
            return status.getSummary();
        }
    }

    private class OSGiStatusColumn
    extends Column<String> {
        OSGiStatusColumn() {
            super("OSGi State");
        }

        public String getValue(BundleStatus status, Settings settings, List<BundleStatus> data, ServiceProvider serviceProvider0) throws IllegalArgumentException {
            if (!status.isEnabled()) {
                return "(DISABLED)";
            }
            GhidraBundle bundle = BundleStatusTableModel.this.bundleHost.getGhidraBundle(status.getFile());
            if (bundle != null) {
                Bundle osgiBundle = bundle.getOSGiBundle();
                if (osgiBundle != null) {
                    return OSGiUtils.getStateString(osgiBundle);
                }
                return "(UNINSTALLED)";
            }
            return "(ENABLED)";
        }

        public int getColumnPreferredWidth() {
            return 100;
        }
    }

    private class BundleTypeColumn
    extends Column<String> {
        BundleTypeColumn() {
            super("Bundle Type");
        }

        public String getValue(BundleStatus status, Settings settings, List<BundleStatus> data, ServiceProvider serviceProvider0) throws IllegalArgumentException {
            return status.getType().toString();
        }

        public int getColumnPreferredWidth() {
            return 90;
        }
    }

    private class BundleFileRenderer
    extends AbstractGColumnRenderer<ResourceFile> {
        private BundleFileRenderer() {
        }

        public Component getTableCellRendererComponent(GTableCellRenderingData data) {
            BundleStatus status = (BundleStatus)data.getRowObject();
            ResourceFile file = (ResourceFile)data.getValue();
            JLabel label = (JLabel)super.getTableCellRendererComponent(data);
            label.setText(Path.toPathString((ResourceFile)file));
            GhidraBundle bundle = BundleStatusTableModel.this.bundleHost.getGhidraBundle(file);
            if (bundle == null || bundle instanceof GhidraPlaceholderBundle || !file.exists()) {
                label.setForeground(COLOR_BUNDLE_ERROR);
            } else if (status.isBusy()) {
                label.setForeground(COLOR_BUNDLE_BUSY);
            } else if (!status.isEnabled()) {
                label.setForeground(COLOR_BUNDLE_DISABLED);
            } else if (status.isActive()) {
                label.setForeground(COLOR_BUNDLE_ACTIVE);
            } else {
                label.setForeground(COLOR_BUNDLE_INACTIVE);
            }
            return label;
        }

        public String getFilterString(ResourceFile file, Settings settings) {
            return Path.toPathString((ResourceFile)file);
        }
    }
}

