/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.programtree;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import ghidra.app.cmd.module.ComplexityDepthModularizationCmd;
import ghidra.app.cmd.module.DominanceModularizationCmd;
import ghidra.app.plugin.ProgramPlugin;
import ghidra.app.plugin.core.programtree.ProgramNode;
import ghidra.app.services.BlockModelService;
import ghidra.framework.cmd.BackgroundCommand;
import ghidra.framework.model.UndoableDomainObject;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.util.HelpLocation;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Program Tree", shortDescription="Program Tree Modularization Plugin", description="Provides actions for orgainizing a program tree into modules or fragments.  Currently there are two organizations, dominance and complexity depth", servicesRequired={BlockModelService.class})
public class ProgramTreeModularizationPlugin
extends ProgramPlugin {
    public ProgramTreeModularizationPlugin(PluginTool tool) {
        super(tool);
    }

    protected void init() {
        this.createActions();
    }

    private void createActions() {
        DockingAction createDominanceTreeAction = new DockingAction("Create Dominance Tree", this.getName()){

            public void actionPerformed(ActionContext context) {
                ProgramTreeModularizationPlugin.this.applyDominanceAlgorithm((ProgramNode)context.getContextObject());
            }

            public boolean isEnabledForContext(ActionContext context) {
                Object contextObj = context.getContextObject();
                if (contextObj instanceof ProgramNode) {
                    return ((ProgramNode)contextObj).getProgram() != null;
                }
                return false;
            }
        };
        createDominanceTreeAction.setPopupMenuData(new MenuData(new String[]{"Modularize By", "Dominance"}, "select"));
        createDominanceTreeAction.setHelpLocation(new HelpLocation("ProgramTreePlugin", "Create_Dominance_Tree"));
        this.tool.addAction((DockingActionIf)createDominanceTreeAction);
        DockingAction complexityDepthTreeAction = new DockingAction("Create Complexity Depth Tree", this.getName()){

            public void actionPerformed(ActionContext context) {
                ProgramTreeModularizationPlugin.this.applyComplexityDepthAlgorithm((ProgramNode)context.getContextObject());
            }

            public boolean isEnabledForContext(ActionContext context) {
                Object contextObj = context.getContextObject();
                if (contextObj instanceof ProgramNode) {
                    return ((ProgramNode)contextObj).getProgram() != null;
                }
                return false;
            }
        };
        complexityDepthTreeAction.setPopupMenuData(new MenuData(new String[]{"Modularize By", "Complexity Depth"}, "select"));
        complexityDepthTreeAction.setHelpLocation(new HelpLocation("ProgramTreePlugin", "Complexity_Depth"));
        this.tool.addAction((DockingActionIf)complexityDepthTreeAction);
    }

    private void applyDominanceAlgorithm(ProgramNode node) {
        BlockModelService blockModelService = (BlockModelService)this.tool.getService(BlockModelService.class);
        DominanceModularizationCmd cmd = new DominanceModularizationCmd(node.getGroupPath(), node.getGroup().getTreeName(), this.currentSelection, blockModelService.getActiveSubroutineModel());
        this.tool.executeBackgroundCommand((BackgroundCommand)cmd, (UndoableDomainObject)this.currentProgram);
    }

    private void applyComplexityDepthAlgorithm(ProgramNode node) {
        BlockModelService blockModelService = (BlockModelService)this.tool.getService(BlockModelService.class);
        ComplexityDepthModularizationCmd cmd = new ComplexityDepthModularizationCmd(node.getGroupPath(), node.getGroup().getTreeName(), this.currentSelection, blockModelService.getActiveSubroutineModel());
        this.tool.executeBackgroundCommand((BackgroundCommand)cmd, (UndoableDomainObject)this.currentProgram);
    }
}

