/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.select.qualified;

import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import ghidra.app.context.NavigatableActionContext;
import ghidra.app.context.NavigatableContextAction;
import ghidra.app.context.ProgramLocationActionContext;
import ghidra.app.events.ProgramSelectionPluginEvent;
import ghidra.app.nav.NavigationUtils;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.DataIterator;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.InstructionIterator;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramSelection;
import ghidra.util.HelpLocation;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Code Viewer", shortDescription="Select Data, Instructions, and Undefined", description="This plugin makes a selection of defined data, instructions, and undefined code units. The process of making the selection is done in the background and can be cancelled at any time. If a selection already exists, the new selection will be limited to a subset of the original selection. If there isn't a selection when the action is invoked, then the select will be performed on the entire program.", eventsProduced={ProgramSelectionPluginEvent.class})
public class QualifiedSelectionPlugin
extends Plugin {
    private DockingAction selectDataAction;
    private DockingAction selectInstructionsAction;
    private DockingAction selectUndefinedAction;
    private int SELECT_INSTRUCTIONS = 0;
    private int SELECT_UNDEFINED = 1;
    private int SELECT_DATA = 2;

    public QualifiedSelectionPlugin(PluginTool tool) {
        super(tool);
        this.setupActions(tool);
    }

    private void setupActions(PluginTool tool) {
        this.selectDataAction = new QualifiedSelectionAction("Data"){

            @Override
            public void actionPerformed(NavigatableActionContext context) {
                QualifiedSelectionPlugin.this.selectData(context);
            }
        };
        tool.addAction((DockingActionIf)this.selectDataAction);
        this.selectInstructionsAction = new QualifiedSelectionAction("Instructions"){

            @Override
            public void actionPerformed(NavigatableActionContext context) {
                QualifiedSelectionPlugin.this.selectInstructions(context);
            }
        };
        tool.addAction((DockingActionIf)this.selectInstructionsAction);
        this.selectUndefinedAction = new QualifiedSelectionAction("Undefined"){

            @Override
            public void actionPerformed(NavigatableActionContext context) {
                QualifiedSelectionPlugin.this.selectUndefined(context);
            }
        };
        tool.addAction((DockingActionIf)this.selectUndefinedAction);
    }

    private void selectInstructions(NavigatableActionContext context) {
        SelectTask task = new SelectTask("Select Instructions", context, this.SELECT_INSTRUCTIONS);
        this.tool.execute((Task)task);
    }

    private void selectUndefined(NavigatableActionContext context) {
        SelectTask task = new SelectTask("Select Undefined", context, this.SELECT_UNDEFINED);
        this.tool.execute((Task)task);
    }

    private void selectData(NavigatableActionContext context) {
        SelectTask task = new SelectTask("Select Data", context, this.SELECT_DATA);
        this.tool.execute((Task)task);
    }

    private void selectUndefined(TaskMonitor taskMonitor, NavigatableActionContext context) {
        AddressSet undefAddressSet = this.getUndefined(taskMonitor, context);
        ProgramSelection selection = new ProgramSelection((AddressSetView)undefAddressSet);
        NavigationUtils.setSelection(this.tool, context.getNavigatable(), selection);
    }

    private void selectInstructions(TaskMonitor taskMonitor, NavigatableActionContext context) {
        AddressSet instrAddressSet = this.getInstructions(context, this.getStartSet(context), taskMonitor);
        ProgramSelection selection = new ProgramSelection((AddressSetView)instrAddressSet);
        NavigationUtils.setSelection(this.tool, context.getNavigatable(), selection);
    }

    private void selectData(TaskMonitor taskMonitor, NavigatableActionContext context) {
        AddressSet dataAddressSet = this.getDefinedData(context, this.getStartSet(context), taskMonitor);
        ProgramSelection selection = new ProgramSelection((AddressSetView)dataAddressSet);
        NavigationUtils.setSelection(this.tool, context.getNavigatable(), selection);
    }

    private AddressSetView getStartSet(ProgramLocationActionContext context) {
        Program program = context.getProgram();
        if (program == null) {
            return new AddressSet();
        }
        if (context.hasSelection()) {
            return context.getSelection();
        }
        return new AddressSet((AddressSetView)program.getMemory());
    }

    private AddressSet getUndefined(TaskMonitor taskMonitor, ProgramLocationActionContext context) {
        AddressSetView startSet = this.getStartSet(context);
        startSet = this.adjustToCodeUnitBoundaries(startSet, context);
        AddressSet definedDataSet = this.getDefinedData(context, startSet, taskMonitor);
        if (taskMonitor.isCancelled()) {
            return new AddressSet();
        }
        AddressSet instructionSet = this.getInstructions(context, startSet, taskMonitor);
        if (taskMonitor.isCancelled()) {
            return new AddressSet();
        }
        AddressSet notUndefinedSet = definedDataSet.union((AddressSetView)instructionSet);
        AddressSet undefinedSet = startSet.subtract((AddressSetView)notUndefinedSet);
        return undefinedSet;
    }

    private AddressSetView adjustToCodeUnitBoundaries(AddressSetView startSet, ProgramLocationActionContext context) {
        Program program = context.getProgram();
        AddressSet newSet = new AddressSet();
        AddressRangeIterator it = startSet.getAddressRanges();
        Listing listing = program.getListing();
        while (it.hasNext()) {
            AddressRange range = (AddressRange)it.next();
            newSet.add(range);
            Address start = range.getMinAddress();
            CodeUnit cu = listing.getCodeUnitContaining(start);
            if (cu == null || cu.getMinAddress().equals((Object)start)) continue;
            newSet.addRange(cu.getMinAddress(), cu.getMaxAddress());
        }
        return newSet;
    }

    private AddressSet getDefinedData(ProgramLocationActionContext context, AddressSetView startSet, TaskMonitor taskMonitor) {
        Program program = context.getProgram();
        Listing listing = program.getListing();
        AddressSet addressSet = new AddressSet();
        long numDefined = listing.getNumDefinedData();
        taskMonitor.initialize((long)((int)numDefined));
        int counter = 0;
        DataIterator diter = listing.getDefinedData(startSet, true);
        while (diter.hasNext() && !taskMonitor.isCancelled()) {
            taskMonitor.setProgress((long)(++counter));
            Data data = diter.next();
            addressSet.addRange(data.getMinAddress(), data.getMaxAddress());
        }
        return addressSet;
    }

    private AddressSet getInstructions(ProgramLocationActionContext context, AddressSetView startSet, TaskMonitor taskMonitor) {
        Program program = context.getProgram();
        Listing listing = program.getListing();
        AddressSet addressSet = new AddressSet();
        long numInstruct = listing.getNumInstructions();
        taskMonitor.initialize((long)((int)numInstruct));
        int counter = 0;
        InstructionIterator initer = listing.getInstructions(startSet, true);
        while (initer.hasNext() && !taskMonitor.isCancelled()) {
            taskMonitor.setProgress((long)(++counter));
            Instruction instruct = initer.next();
            addressSet.addRange(instruct.getMinAddress(), instruct.getMaxAddress());
        }
        return addressSet;
    }

    private class SelectTask
    extends Task {
        private int selectOption;
        private final NavigatableActionContext context;

        SelectTask(String name, NavigatableActionContext context, int selectOption) {
            super(name, true, true, true);
            this.context = context;
            this.selectOption = selectOption;
        }

        public void run(TaskMonitor taskMonitor) {
            if (this.selectOption == QualifiedSelectionPlugin.this.SELECT_INSTRUCTIONS) {
                QualifiedSelectionPlugin.this.selectInstructions(taskMonitor, this.context);
            } else if (this.selectOption == QualifiedSelectionPlugin.this.SELECT_UNDEFINED) {
                QualifiedSelectionPlugin.this.selectUndefined(taskMonitor, this.context);
            } else if (this.selectOption == QualifiedSelectionPlugin.this.SELECT_DATA) {
                QualifiedSelectionPlugin.this.selectData(taskMonitor, this.context);
            }
        }
    }

    private abstract class QualifiedSelectionAction
    extends NavigatableContextAction {
        QualifiedSelectionAction(String name) {
            super(name, QualifiedSelectionPlugin.this.getName());
            this.setHelpLocation(new HelpLocation("Selection", name));
            this.setEnabled(false);
            this.setMenuBarData(new MenuData(new String[]{"Se&lect", name}, null, "Select Group 2"));
            this.addToWindowWhen(NavigatableActionContext.class);
        }
    }
}

