/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.strings;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.DialogComponentProvider;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.KeyBindingType;
import docking.action.MenuData;
import docking.action.ToolBarData;
import ghidra.app.plugin.ProgramPlugin;
import ghidra.app.plugin.core.data.DataSettingsDialog;
import ghidra.app.plugin.core.data.DataTypeSettingsDialog;
import ghidra.app.plugin.core.strings.ViewStringsProvider;
import ghidra.app.services.GoToService;
import ghidra.framework.model.DomainObjectChangeRecord;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramChangeRecord;
import ghidra.program.util.ProgramLocation;
import ghidra.util.HelpLocation;
import ghidra.util.exception.CancelledException;
import ghidra.util.table.SelectionNavigationAction;
import ghidra.util.table.actions.MakeProgramSelectionAction;
import ghidra.util.task.SwingUpdateManager;
import javax.swing.Icon;
import resources.Icons;
import resources.ResourceManager;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Common", shortDescription="Defined String Table", description="Displays all defined strings in the current program.", servicesRequired={GoToService.class})
public class ViewStringsPlugin
extends ProgramPlugin
implements DomainObjectListener {
    private static Icon REFRESH_ICON = Icons.REFRESH_ICON;
    private static Icon REFRESH_NOT_NEEDED_ICON = ResourceManager.getDisabledIcon((Icon)Icons.REFRESH_ICON, (int)60);
    private DockingAction refreshAction;
    private SelectionNavigationAction linkNavigationAction;
    private ViewStringsProvider provider;
    private SwingUpdateManager reloadUpdateMgr;

    public ViewStringsPlugin(PluginTool tool) {
        super(tool);
    }

    void doReload() {
        this.provider.reload();
    }

    protected void init() {
        super.init();
        this.provider = new ViewStringsProvider(this);
        this.reloadUpdateMgr = new SwingUpdateManager(100, 60000, this::doReload);
        this.createActions();
    }

    private void createActions() {
        this.refreshAction = new DockingAction("Refresh Strings", this.getName()){

            public boolean isEnabledForContext(ActionContext context) {
                return ViewStringsPlugin.this.getCurrentProgram() != null;
            }

            public void actionPerformed(ActionContext context) {
                this.getToolBarData().setIcon(REFRESH_NOT_NEEDED_ICON);
                ViewStringsPlugin.this.reload();
            }
        };
        this.refreshAction.setToolBarData(new ToolBarData(REFRESH_NOT_NEEDED_ICON));
        this.refreshAction.setDescription("<html>Push at any time to refresh the current table of strings.<br>This button is highlighted when the data <i>may</i> be stale.<br>");
        this.refreshAction.setHelpLocation(new HelpLocation("ViewStringsPlugin", "Refresh"));
        this.tool.addLocalAction((ComponentProvider)this.provider, (DockingActionIf)this.refreshAction);
        this.tool.addLocalAction((ComponentProvider)this.provider, (DockingActionIf)new MakeProgramSelectionAction(this, this.provider.getTable()));
        this.linkNavigationAction = new SelectionNavigationAction(this, this.provider.getTable());
        this.tool.addLocalAction((ComponentProvider)this.provider, (DockingActionIf)this.linkNavigationAction);
        DockingAction editDataSettingsAction = new DockingAction("Data Settings", this.getName(), KeyBindingType.SHARED){

            public void actionPerformed(ActionContext context) {
                try {
                    DataSettingsDialog dialog = ViewStringsPlugin.this.provider.getSelectedRowCount() == 1 ? new DataSettingsDialog(ViewStringsPlugin.this.provider.getSelectedData()) : new DataSettingsDialog(ViewStringsPlugin.this.currentProgram, ViewStringsPlugin.this.provider.getProgramSelection());
                    ViewStringsPlugin.this.tool.showDialog((DialogComponentProvider)dialog);
                    dialog.dispose();
                }
                catch (CancelledException cancelledException) {
                    // empty catch block
                }
            }
        };
        editDataSettingsAction.setPopupMenuData(new MenuData(new String[]{"Settings..."}, "R"));
        editDataSettingsAction.setHelpLocation(new HelpLocation("DataPlugin", "Data_Settings"));
        DockingAction editDefaultSettingsAction = new DockingAction("Default Settings", this.getName(), KeyBindingType.SHARED){

            public void actionPerformed(ActionContext context) {
                DataType dt = this.getSelectedDataType();
                if (dt == null) {
                    return;
                }
                DataTypeSettingsDialog dataSettingsDialog = new DataTypeSettingsDialog(dt, dt.getSettingsDefinitions());
                ViewStringsPlugin.this.tool.showDialog((DialogComponentProvider)dataSettingsDialog);
                dataSettingsDialog.dispose();
            }

            public boolean isEnabledForContext(ActionContext context) {
                if (ViewStringsPlugin.this.provider.getSelectedRowCount() != 1) {
                    return false;
                }
                DataType dt = this.getSelectedDataType();
                if (dt == null) {
                    return false;
                }
                return dt.getSettingsDefinitions().length != 0;
            }

            private DataType getSelectedDataType() {
                Data data = ViewStringsPlugin.this.provider.getSelectedData();
                return data != null ? data.getDataType() : null;
            }
        };
        editDefaultSettingsAction.setPopupMenuData(new MenuData(new String[]{"Default Settings..."}, "R"));
        editDefaultSettingsAction.setHelpLocation(new HelpLocation("DataPlugin", "Default_Settings"));
        this.tool.addLocalAction((ComponentProvider)this.provider, (DockingActionIf)editDataSettingsAction);
        this.tool.addLocalAction((ComponentProvider)this.provider, (DockingActionIf)editDefaultSettingsAction);
    }

    public void dispose() {
        this.reloadUpdateMgr.dispose();
        this.provider.dispose();
        super.dispose();
    }

    @Override
    protected void programDeactivated(Program program) {
        program.removeListener((DomainObjectListener)this);
        this.provider.setProgram(null);
    }

    @Override
    protected void programActivated(Program program) {
        program.addListener((DomainObjectListener)this);
        this.provider.setProgram(program);
    }

    @Override
    protected void locationChanged(ProgramLocation loc) {
        if (this.linkNavigationAction.isSelected() && loc != null) {
            this.provider.setProgram(loc.getProgram());
            this.provider.showProgramLocation(loc);
        }
    }

    private void markDataAsStale() {
        this.provider.getComponent().repaint();
        this.refreshAction.getToolBarData().setIcon(REFRESH_ICON);
    }

    public void domainObjectChanged(DomainObjectChangedEvent ev) {
        if (ev.containsEvent(4) || ev.containsEvent(23) || ev.containsEvent(21) || ev.containsEvent(108)) {
            this.markDataAsStale();
            return;
        }
        block4: for (int i = 0; i < ev.numRecords(); ++i) {
            DomainObjectChangeRecord doRecord = ev.getChangeRecord(i);
            Object newValue = doRecord.getNewValue();
            switch (doRecord.getEventType()) {
                case 31: {
                    ProgramChangeRecord pcRec = (ProgramChangeRecord)doRecord;
                    this.provider.remove(pcRec.getStart(), pcRec.getEnd());
                    continue block4;
                }
                case 30: {
                    if (!(newValue instanceof Data)) continue block4;
                    this.provider.add((Data)newValue);
                    continue block4;
                }
            }
        }
        if (ev.containsEvent(109)) {
            this.provider.getComponent().repaint();
        }
    }

    private void reload() {
        this.reloadUpdateMgr.update();
    }
}

