/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.terminal.vt;

import ghidra.app.plugin.core.terminal.vt.VtHandler;
import ghidra.util.Msg;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public abstract class VtResponseEncoder {
    protected static final byte[] PASTE_START = VtHandler.ascii("\u001b[200~");
    protected static final byte[] PASTE_END = VtHandler.ascii("\u001b[201~");
    protected final ByteBuffer bb = ByteBuffer.allocate(16);
    protected final Charset charset;

    public VtResponseEncoder(Charset charset) {
        this.charset = charset;
    }

    protected abstract void generateBytes(ByteBuffer var1);

    public void reportCursorPos(int row, int col) {
        this.bb.put(("\u001b[" + row + ";" + col + "R").getBytes(this.charset));
        this.generateBytesExc();
    }

    protected void generateBytesExc() {
        this.bb.flip();
        try {
            this.generateBytes(this.bb);
        }
        catch (Throwable t) {
            Msg.error((Object)this, (Object)("Error generating bytes: " + t), (Throwable)t);
        }
        finally {
            this.bb.clear();
        }
    }

    public void reportPasteStart() {
        this.bb.put(PASTE_START);
        this.generateBytesExc();
    }

    public void reportPasteEnd() {
        this.bb.put(PASTE_END);
        this.generateBytesExc();
    }
}

