/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.terminal.vt;

import ghidra.app.plugin.core.terminal.vt.VtCharset;
import ghidra.app.plugin.core.terminal.vt.VtHandler;
import ghidra.app.plugin.core.terminal.vt.VtParser;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum VtState {
    CHAR{

        @Override
        protected VtState handleNext(byte b, VtParser parser, VtHandler handler) {
            if (b == 27) {
                return ESC;
            }
            handler.handleCharExc(b);
            return CHAR;
        }
    }
    ,
    ESC{

        @Override
        protected VtState handleNext(byte b, VtParser parser, VtHandler handler) {
            switch (b) {
                case 55: {
                    handler.handleSaveCursorPos();
                    return CHAR;
                }
                case 56: {
                    handler.handleRestoreCursorPos();
                    return CHAR;
                }
                case 40: {
                    parser.csG = VtCharset.G.G0;
                    return CHARSET;
                }
                case 41: {
                    parser.csG = VtCharset.G.G1;
                    return CHARSET;
                }
                case 42: {
                    parser.csG = VtCharset.G.G2;
                    return CHARSET;
                }
                case 43: {
                    parser.csG = VtCharset.G.G3;
                    return CHARSET;
                }
                case 91: {
                    return CSI_PARAM;
                }
                case 93: {
                    return OSC_PARAM;
                }
                case 61: {
                    handler.handleKeypadMode(VtHandler.KeyMode.APPLICATION);
                    return CHAR;
                }
                case 62: {
                    handler.handleKeypadMode(VtHandler.KeyMode.NORMAL);
                    return CHAR;
                }
                case 68: {
                    handler.handleScrollViewportDown(1, true);
                    return CHAR;
                }
                case 77: {
                    handler.handleScrollViewportUp(1);
                    return CHAR;
                }
                case 99: {
                    handler.handleFullReset();
                    return CHAR;
                }
            }
            handler.handleCharExc((byte)27);
            handler.handleCharExc(b);
            return CHAR;
        }
    }
    ,
    CHARSET{

        @Override
        protected VtState handleNext(byte b, VtParser parser, VtHandler handler) {
            switch (b) {
                case 34: {
                    return CHARSET_QUOTE;
                }
                case 37: {
                    return CHARSET_PERCENT;
                }
                case 38: {
                    return CHARSET_AMPERSAND;
                }
                case 65: {
                    handler.handleSetCharset(parser.csG, VtCharset.UK);
                    return CHAR;
                }
                case 66: {
                    handler.handleSetCharset(parser.csG, VtCharset.USASCII);
                    return CHAR;
                }
                case 53: 
                case 67: {
                    handler.handleSetCharset(parser.csG, VtCharset.FINNISH);
                    return CHAR;
                }
                case 55: 
                case 72: {
                    handler.handleSetCharset(parser.csG, VtCharset.SWEDISH);
                    return CHAR;
                }
                case 75: {
                    handler.handleSetCharset(parser.csG, VtCharset.GERMAN);
                    return CHAR;
                }
                case 57: 
                case 81: {
                    handler.handleSetCharset(parser.csG, VtCharset.FRENCH_CANADIAN);
                    return CHAR;
                }
                case 82: 
                case 102: {
                    handler.handleSetCharset(parser.csG, VtCharset.FRENCH);
                    return CHAR;
                }
                case 89: {
                    handler.handleSetCharset(parser.csG, VtCharset.ITALIAN);
                    return CHAR;
                }
                case 90: {
                    handler.handleSetCharset(parser.csG, VtCharset.SPANISH);
                    return CHAR;
                }
                case 52: {
                    handler.handleSetCharset(parser.csG, VtCharset.DUTCH);
                    return CHAR;
                }
                case 61: {
                    handler.handleSetCharset(parser.csG, VtCharset.SWISS);
                    return CHAR;
                }
                case 54: 
                case 69: 
                case 96: {
                    handler.handleSetCharset(parser.csG, VtCharset.NORWEGIAN_DANISH);
                    return CHAR;
                }
                case 48: {
                    handler.handleSetCharset(parser.csG, VtCharset.DEC_SPECIAL_LINES);
                    return CHAR;
                }
                case 60: {
                    handler.handleSetCharset(parser.csG, VtCharset.DEC_SUPPLEMENTAL);
                    return CHAR;
                }
                case 62: {
                    handler.handleSetCharset(parser.csG, VtCharset.DEC_TECHNICAL);
                    return CHAR;
                }
            }
            handler.handleCharExc((byte)27);
            return parser.doProcessByte(parser.doProcessByte(CHAR, parser.csG.b), b);
        }
    }
    ,
    CHARSET_QUOTE{

        @Override
        protected VtState handleNext(byte b, VtParser parser, VtHandler handler) {
            switch (b) {
                case 62: {
                    handler.handleSetCharset(parser.csG, VtCharset.GREEK);
                    return CHAR;
                }
                case 52: {
                    handler.handleSetCharset(parser.csG, VtCharset.DEC_HEBREW);
                    return CHAR;
                }
                case 63: {
                    handler.handleSetCharset(parser.csG, VtCharset.DEC_GREEK);
                    return CHAR;
                }
            }
            handler.handleCharExc((byte)27);
            return parser.doProcessByte(parser.doProcessByte(parser.doProcessByte(CHAR, parser.csG.b), (byte)34), b);
        }
    }
    ,
    CHARSET_PERCENT{

        @Override
        protected VtState handleNext(byte b, VtParser parser, VtHandler handler) {
            switch (b) {
                case 50: {
                    handler.handleSetCharset(parser.csG, VtCharset.TURKISH);
                    return CHAR;
                }
                case 54: {
                    handler.handleSetCharset(parser.csG, VtCharset.PORTUGESE);
                    return CHAR;
                }
                case 61: {
                    handler.handleSetCharset(parser.csG, VtCharset.HEBREW);
                    return CHAR;
                }
                case 48: {
                    handler.handleSetCharset(parser.csG, VtCharset.DEC_TURKISH);
                    return CHAR;
                }
                case 53: {
                    handler.handleSetCharset(parser.csG, VtCharset.DEC_SUPPLEMENTAL_GRAPHICS);
                    return CHAR;
                }
            }
            handler.handleCharExc((byte)27);
            return parser.doProcessByte(parser.doProcessByte(parser.doProcessByte(CHAR, parser.csG.b), (byte)37), b);
        }
    }
    ,
    CHARSET_AMPERSAND{

        @Override
        protected VtState handleNext(byte b, VtParser parser, VtHandler handler) {
            switch (b) {
                case 52: {
                    handler.handleSetCharset(parser.csG, VtCharset.DEC_CYRILLIC);
                    return CHAR;
                }
            }
            handler.handleCharExc((byte)27);
            return parser.doProcessByte(parser.doProcessByte(parser.doProcessByte(CHAR, parser.csG.b), (byte)38), b);
        }
    }
    ,
    CSI_PARAM{

        @Override
        protected VtState handleNext(byte b, VtParser parser, VtHandler handler) {
            if (48 <= b && b <= 63) {
                parser.putCsiParamByte(b);
                return CSI_PARAM;
            }
            if (32 <= b && b <= 47) {
                parser.putCsiInterByte(b);
                return CSI_INTER;
            }
            if (64 <= b && b <= 126) {
                this.handleCsi(b, parser, handler);
                return CHAR;
            }
            handler.handleCharExc((byte)27);
            return parser.doProcess(CHAR, parser.copyCsiBuffer(b));
        }
    }
    ,
    CSI_INTER{

        @Override
        protected VtState handleNext(byte b, VtParser parser, VtHandler handler) {
            if (32 <= b && b <= 47) {
                parser.putCsiInterByte(b);
                return CSI_INTER;
            }
            if (64 <= b && b <= 126) {
                this.handleCsi(b, parser, handler);
                return CHAR;
            }
            handler.handleCharExc((byte)27);
            return parser.doProcess(CHAR, parser.copyCsiBuffer(b));
        }
    }
    ,
    OSC_PARAM{

        @Override
        protected VtState handleNext(byte b, VtParser parser, VtHandler handler) {
            if (32 <= b && b <= 127 || b == 0) {
                parser.putOscParamByte(b);
                return OSC_PARAM;
            }
            if (b == 7) {
                this.handleOsc(parser, handler);
                return CHAR;
            }
            if (b == 27) {
                return OSC_ESC;
            }
            handler.handleCharExc((byte)27);
            return parser.doProcess(CHAR, parser.copyOscBuffer(b));
        }
    }
    ,
    OSC_ESC{

        @Override
        protected VtState handleNext(byte b, VtParser parser, VtHandler handler) {
            if (b == 92) {
                this.handleOsc(parser, handler);
                return CHAR;
            }
            handler.handleCharExc((byte)27);
            return parser.doProcessByte(OSC_PARAM, b);
        }
    };


    protected abstract VtState handleNext(byte var1, VtParser var2, VtHandler var3);

    protected void handleCsi(byte csiFinal, VtParser parser, VtHandler handler) {
        parser.csiParam.flip();
        parser.csiInter.flip();
        handler.handleCsiExc(parser.csiParam, parser.csiInter, csiFinal);
        parser.csiParam.clear();
        parser.csiInter.clear();
    }

    protected void handleOsc(VtParser parser, VtHandler handler) {
        parser.oscParam.flip();
        handler.handleOscExc(parser.oscParam);
        parser.oscParam.clear();
    }
}

