/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.script;

import docking.DialogComponentProvider;
import docking.DockingWindowManager;
import ghidra.plugin.importer.NewLanguagePanel;
import ghidra.program.model.lang.LanguageCompilerSpecPair;
import ghidra.util.Swing;

public class SelectLanguageDialog
extends DialogComponentProvider {
    private NewLanguagePanel languagePanel = new NewLanguagePanel();
    private LanguageCompilerSpecPair selectedLcsPair;
    private boolean wasCancelled = false;

    public SelectLanguageDialog(String title, String approveButtonText) {
        super(title, true);
        this.setTransient(true);
        this.addWorkPanel(this.languagePanel);
        this.addOKButton();
        this.addCancelButton();
        this.setOkButtonText(approveButtonText);
        this.setDefaultButton(this.okButton);
    }

    protected void okCallback() {
        if (this.checkInput()) {
            this.selectedLcsPair = this.languagePanel.getSelectedLcsPair();
            this.close();
        }
    }

    public void close() {
        super.close();
        this.languagePanel.dispose();
    }

    protected void cancelCallback() {
        super.cancelCallback();
        this.wasCancelled = true;
    }

    public boolean wasCancelled() {
        return this.wasCancelled;
    }

    private boolean checkInput() {
        return this.languagePanel.getSelectedLcsPair() != null;
    }

    public void setSelectedLanguage(LanguageCompilerSpecPair language) {
        Swing.runNow(() -> this.languagePanel.setSelectedLcsPair(language));
    }

    public LanguageCompilerSpecPair getSelectedLanguage() {
        return this.selectedLcsPair;
    }

    public void show() {
        DockingWindowManager.showDialog(null, (DialogComponentProvider)this);
    }
}

