/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util;

import ghidra.program.model.data.DataType;
import ghidra.program.model.data.FunctionDefinitionDataType;
import ghidra.program.model.data.ParameterDefinition;
import ghidra.util.InvalidNameException;

public class DataTypeNamingUtil {
    private static final String ANONYMOUS_FUNCTION_DEF_PREFIX = "_func";

    private DataTypeNamingUtil() {
    }

    public static String setMangledAnonymousFunctionName(FunctionDefinitionDataType functionDefinition) throws IllegalArgumentException {
        String convention;
        DataType returnType = functionDefinition.getReturnType();
        ParameterDefinition[] parameters = functionDefinition.getArguments();
        StringBuilder sb = new StringBuilder(ANONYMOUS_FUNCTION_DEF_PREFIX);
        if (functionDefinition.hasNoReturn()) {
            sb.append("_").append("noreturn");
        }
        if (!"unknown".equals(convention = functionDefinition.getCallingConventionName())) {
            sb.append("_").append(convention);
        }
        sb.append("_");
        sb.append(DataTypeNamingUtil.mangleDTName(returnType.getName()));
        for (ParameterDefinition p : parameters) {
            sb.append("_").append(DataTypeNamingUtil.mangleDTName(p.getDataType().getName()));
        }
        if (functionDefinition.hasVarArgs()) {
            sb.append("_").append("varargs");
        }
        String name = sb.toString();
        try {
            functionDefinition.setName(name);
        }
        catch (InvalidNameException e) {
            throw new IllegalArgumentException(e);
        }
        return name;
    }

    private static String mangleDTName(String s) {
        return s.replaceAll(" ", "_").replaceAll("\\*", "ptr");
    }
}

