/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util;

import docking.DialogComponentProvider;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import ghidra.util.exception.DuplicateNameException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public class EditFieldNameDialog
extends DialogComponentProvider {
    private PluginTool tool;
    private TitledBorder nameBorder;
    private JTextField fieldName;
    private Program program;
    private DataTypeComponent dtComp;

    public EditFieldNameDialog(String title, PluginTool tool) {
        super(title, true, true, true, false);
        this.tool = tool;
        this.setHelpLocation(new HelpLocation("LabelMgrPlugin", "EditFieldNameDialog"));
        this.addWorkPanel(this.create());
        this.setFocusComponent(this.fieldName);
        this.addOKButton();
        this.addCancelButton();
        this.setDefaultButton(this.okButton);
        this.setMinimumSize(new Dimension(300, 50));
    }

    private String getCurrentFieldName() {
        String name = this.dtComp.getFieldName();
        if (name == null) {
            name = this.dtComp.getDefaultFieldName();
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void okCallback() {
        String newName = this.fieldName.getText().trim();
        if (newName.equals(this.getCurrentFieldName())) {
            this.close();
            return;
        }
        boolean success = false;
        int txId = this.program.startTransaction("Edit Field Name");
        try {
            this.dtComp.setFieldName(newName);
            DataType parent = this.dtComp.getParent();
            if (parent != null) {
                long timeNow = System.currentTimeMillis();
                parent.setLastChangeTime(timeNow);
            }
            success = true;
        }
        catch (DuplicateNameException e) {
            this.setStatusText(e.getMessage());
        }
        finally {
            this.program.endTransaction(txId, true);
        }
        if (success) {
            this.dtComp = null;
            this.program = null;
            this.close();
        }
    }

    public void editField(DataTypeComponent dataTypeComponent, Program p) {
        this.dtComp = dataTypeComponent;
        this.program = p;
        String name = this.getCurrentFieldName();
        this.setTitle("Edit Field Name: " + dataTypeComponent.getParent().getName() + "." + name);
        this.fieldName.setText(name);
        this.clearStatusText();
        this.tool.showDialog((DialogComponentProvider)this);
    }

    private JPanel create() {
        this.fieldName = new JTextField();
        JPanel mainPanel = new JPanel(new BorderLayout());
        this.nameBorder = BorderFactory.createTitledBorder("Enter Field Name");
        mainPanel.setBorder(this.nameBorder);
        mainPanel.add((Component)this.fieldName, "Center");
        mainPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        return mainPanel;
    }
}

