/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf4;

import ghidra.app.util.bin.format.dwarf4.DWARFRange;
import java.util.List;

public class DWARFLocation {
    private DWARFRange addressRange;
    private byte[] location;

    public DWARFLocation(DWARFRange addressRange, byte[] location) {
        this.addressRange = addressRange;
        this.location = location;
    }

    public DWARFRange getRange() {
        return this.addressRange;
    }

    public byte[] getLocation() {
        return this.location;
    }

    public static DWARFLocation getTopLocation(List<DWARFLocation> locList, long funcAddr) {
        if (locList.size() == 1) {
            return locList.get(0);
        }
        for (DWARFLocation loc : locList) {
            if (loc.getRange().getFrom() != funcAddr) continue;
            return loc;
        }
        return null;
    }

    public static DWARFLocation getEntryLocation(List<DWARFLocation> locList, long funcAddr) {
        for (DWARFLocation loc : locList) {
            if (loc.getRange().getFrom() != funcAddr) continue;
            return loc;
        }
        return null;
    }

    public static DWARFLocation getFirstLocation(List<DWARFLocation> locList) {
        return !locList.isEmpty() ? locList.get(0) : null;
    }
}

