/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf4.next;

import ghidra.app.util.bin.format.dwarf4.next.NamespacePath;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypePath;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SymbolType;
import java.util.List;
import java.util.Objects;

public class DWARFNameInfo {
    private final DWARFNameInfo parent;
    private final CategoryPath organizationalCategoryPath;
    private final NamespacePath namespacePath;
    private final String originalName;

    public static DWARFNameInfo createRoot(CategoryPath rootCategory) {
        return new DWARFNameInfo(null, rootCategory, NamespacePath.ROOT, null);
    }

    public static DWARFNameInfo fromDataType(DataType dataType) {
        return new DWARFNameInfo(null, dataType.getCategoryPath(), NamespacePath.create(null, dataType.getName(), null), dataType.getName());
    }

    public static DWARFNameInfo fromList(DWARFNameInfo parent, List<String> names) {
        for (String s : names) {
            DWARFNameInfo tmp;
            parent = tmp = new DWARFNameInfo(parent, s, s, SymbolType.NAMESPACE);
        }
        return parent;
    }

    private DWARFNameInfo(DWARFNameInfo parent, CategoryPath organizationalCategoryPath, NamespacePath namespacePath, String originalName) {
        this.parent = parent;
        this.organizationalCategoryPath = Objects.requireNonNullElse(organizationalCategoryPath, CategoryPath.ROOT);
        this.namespacePath = Objects.requireNonNullElse(namespacePath, NamespacePath.ROOT);
        this.originalName = originalName;
    }

    private DWARFNameInfo(DWARFNameInfo parent, String originalName, String name, SymbolType type) {
        this.parent = parent;
        this.organizationalCategoryPath = parent.getOrganizationalCategoryPath();
        this.namespacePath = NamespacePath.create(parent.getNamespacePath(), name, type);
        this.originalName = originalName;
    }

    public DWARFNameInfo getParent() {
        return this.parent;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public CategoryPath getOrganizationalCategoryPath() {
        return this.organizationalCategoryPath;
    }

    public NamespacePath getNamespacePath() {
        return this.namespacePath;
    }

    public CategoryPath getParentCP() {
        return this.getParent().asCategoryPath();
    }

    public String getName() {
        return this.namespacePath.getName();
    }

    public DWARFNameInfo replaceName(String newName, String newOriginalName) {
        return new DWARFNameInfo(this.getParent(), newOriginalName, newName, this.getType());
    }

    public DWARFNameInfo replaceType(SymbolType newType) {
        return new DWARFNameInfo(this.parent, this.originalName, this.getName(), newType);
    }

    public SymbolType getType() {
        return this.namespacePath.getType();
    }

    public CategoryPath asCategoryPath() {
        List<String> nsParts = this.namespacePath.getParts();
        return nsParts.isEmpty() ? this.organizationalCategoryPath : new CategoryPath(this.organizationalCategoryPath, nsParts);
    }

    public DataTypePath asDataTypePath() {
        return !this.isRoot() ? new DataTypePath(this.getParentCP(), this.getName()) : null;
    }

    public Namespace getParentNamespace(Program program) {
        return this.getParent().asNamespace(program);
    }

    public Namespace asNamespace(Program program) {
        return this.namespacePath.getNamespace(program);
    }

    public String toString() {
        return this.organizationalCategoryPath.toString() + " || " + this.namespacePath.toString();
    }

    public boolean isAnon() {
        return this.originalName == null;
    }

    public String getOriginalName() {
        return this.originalName;
    }

    public boolean isNameModified() {
        return this.originalName == null || !this.originalName.equals(this.namespacePath.getName());
    }

    public DWARFNameInfo createChild(String childOriginalName, String childName, SymbolType childType) {
        return new DWARFNameInfo(this, childOriginalName, childName, childType);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.namespacePath == null ? 0 : this.namespacePath.hashCode());
        result = 31 * result + (this.organizationalCategoryPath == null ? 0 : this.organizationalCategoryPath.hashCode());
        result = 31 * result + (this.originalName == null ? 0 : this.originalName.hashCode());
        result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DWARFNameInfo)) {
            return false;
        }
        DWARFNameInfo other = (DWARFNameInfo)obj;
        if (this.namespacePath == null ? other.namespacePath != null : !this.namespacePath.equals(other.namespacePath)) {
            return false;
        }
        if (this.organizationalCategoryPath == null ? other.organizationalCategoryPath != null : !this.organizationalCategoryPath.equals((Object)other.organizationalCategoryPath)) {
            return false;
        }
        if (this.originalName == null ? other.originalName != null : !this.originalName.equals(other.originalName)) {
            return false;
        }
        return !(this.parent == null ? other.parent != null : !this.parent.equals(other.parent));
    }
}

