/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf4.next;

import generic.jar.ResourceFile;
import ghidra.app.util.bin.format.dwarf4.DWARFUtil;
import ghidra.app.util.bin.format.dwarf4.next.DWARFRegisterMappings;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.lang.Register;
import ghidra.util.Msg;
import ghidra.util.xml.XmlUtilities;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class DWARFRegisterMappingsManager {
    private static final String DWARF_REGISTER_MAPPING_NAME = "DWARF.register.mapping.file";
    private static Map<LanguageID, DWARFRegisterMappings> cache = new HashMap<LanguageID, DWARFRegisterMappings>();

    public static boolean hasDWARFRegisterMapping(Language lang) throws IOException {
        return DWARFUtil.getLanguageExternalFile(lang, DWARF_REGISTER_MAPPING_NAME) != null;
    }

    public static synchronized DWARFRegisterMappings getMappingForLang(Language lang) throws IOException {
        DWARFRegisterMappings result = cache.get(lang.getLanguageID());
        if (result == null) {
            result = DWARFRegisterMappingsManager.readMappingForLang(lang);
            cache.put(lang.getLanguageID(), result);
        }
        return result;
    }

    public static DWARFRegisterMappings readMappingForLang(Language lang) throws IOException {
        DWARFRegisterMappings dWARFRegisterMappings;
        block10: {
            ResourceFile dwarfFile = DWARFUtil.getLanguageExternalFile(lang, DWARF_REGISTER_MAPPING_NAME);
            if (dwarfFile == null) {
                throw new IOException("Missing DWARF register mapping file for language " + lang.getLanguageID().getIdAsString());
            }
            if (!dwarfFile.exists()) {
                throw new IOException("Missing DWARF register mapping file " + dwarfFile + " for language " + lang.getLanguageID().getIdAsString());
            }
            SAXBuilder sax = XmlUtilities.createSecureSAXBuilder((boolean)false, (boolean)false);
            InputStream fis = dwarfFile.getInputStream();
            try {
                Document doc = sax.build(fis);
                Element rootElem = doc.getRootElement();
                dWARFRegisterMappings = DWARFRegisterMappingsManager.readMappingFrom(rootElem, lang);
                if (fis == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | JDOMException e) {
                    Msg.error(DWARFRegisterMappingsManager.class, (Object)("Bad DWARF register mapping file " + dwarfFile), (Throwable)e);
                    throw new IOException("Failed to read DWARF register mapping file " + dwarfFile, e);
                }
            }
            fis.close();
        }
        return dWARFRegisterMappings;
    }

    public static DWARFRegisterMappings readMappingFrom(Element rootElem, Language lang) throws IOException {
        boolean useFPS;
        long cfa;
        int spi;
        Element regMappingsElem = rootElem.getChild("register_mappings");
        if (regMappingsElem == null) {
            throw new IOException("Missing required DWARF <register_mappings> element");
        }
        HashMap<Integer, Register> regmap = new HashMap<Integer, Register>();
        try {
            spi = DWARFRegisterMappingsManager.readMappingsElem(regMappingsElem, lang, regmap);
            Element callFrameElem = rootElem.getChild("call_frame_cfa");
            cfa = callFrameElem != null ? XmlUtilities.parseOptionalBoundedLongAttr((Element)callFrameElem, (String)"value", (long)0L, (long)0L, (long)Long.MAX_VALUE) : 0L;
            Element useFormalParameterStorageElem = rootElem.getChild("use_formal_parameter_storage");
            useFPS = useFormalParameterStorageElem != null;
        }
        catch (NumberFormatException nfe) {
            throw new IOException("Failed to parse DWARF register mappings: " + nfe.getMessage(), nfe);
        }
        return new DWARFRegisterMappings(regmap, cfa, spi, useFPS);
    }

    private static int readMappingsElem(Element regMappingsElem, Language lang, Map<Integer, Register> dwarfRegisterMap) throws IOException {
        int stackPointerIndex = -1;
        for (Element regMappingElem : regMappingsElem.getChildren("register_mapping")) {
            int dwarfRegNum = XmlUtilities.parseBoundedIntAttr((Element)regMappingElem, (String)"dwarf", (int)0, (int)Integer.MAX_VALUE);
            String ghidraRegName = XmlUtilities.requireStringAttr((Element)regMappingElem, (String)"ghidra");
            boolean stackPointer = XmlUtilities.parseOptionalBooleanAttr((Element)regMappingElem, (String)"stackpointer", (boolean)false);
            int autoincCount = XmlUtilities.parseOptionalBoundedIntAttr((Element)regMappingElem, (String)"auto_count", (int)-1, (int)0, (int)Integer.MAX_VALUE);
            if (autoincCount > 0) {
                Pattern regNamePattern = Pattern.compile("([a-zA-Z]+)([0-9]+)");
                Matcher m = regNamePattern.matcher(ghidraRegName);
                if (!m.matches()) {
                    throw new IOException("Unsupported register name for auto-increment: " + ghidraRegName + ", " + XmlUtilities.toString((Element)regMappingElem));
                }
                String baseGhidraRegName = m.group(1);
                int baseGhidraRegNum = Integer.parseInt(m.group(2));
                for (int autoIncNum = 0; autoIncNum < autoincCount; ++autoIncNum) {
                    String autoIncRegName = baseGhidraRegName + Integer.toString(baseGhidraRegNum + autoIncNum);
                    Register autoIncReg = lang.getRegister(autoIncRegName);
                    if (autoIncReg == null) {
                        throw new IOException("Unknown Ghidra auto-increment register: " + autoIncRegName + ", " + XmlUtilities.toString((Element)regMappingElem) + " for " + lang.getLanguageID());
                    }
                    int actualDwarfRegNum = dwarfRegNum + autoIncNum;
                    if (dwarfRegisterMap.containsKey(actualDwarfRegNum)) {
                        throw new IOException("Duplicate mapping for DWARF register " + actualDwarfRegNum + ": " + XmlUtilities.toString((Element)regMappingElem));
                    }
                    dwarfRegisterMap.put(actualDwarfRegNum, autoIncReg);
                }
                continue;
            }
            Register reg = lang.getRegister(ghidraRegName);
            if (reg == null) {
                throw new IOException("Unknown Ghidra register: " + ghidraRegName + ", " + XmlUtilities.toString((Element)regMappingElem));
            }
            if (dwarfRegisterMap.containsKey(dwarfRegNum)) {
                throw new IOException("Duplicate mapping for DWARF register " + dwarfRegNum + ": " + XmlUtilities.toString((Element)regMappingElem));
            }
            dwarfRegisterMap.put(dwarfRegNum, reg);
            if (!stackPointer) continue;
            stackPointerIndex = dwarfRegNum;
        }
        if (stackPointerIndex < 0) {
            throw new IOException("Missing stackpointer specification in registermappings");
        }
        return stackPointerIndex;
    }
}

