/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.golang;

import ghidra.framework.options.Options;
import ghidra.program.model.listing.Program;

public enum GoVer {
    UNKNOWN(0, 0),
    V1_2(1, 2),
    V1_16(1, 16),
    V1_17(1, 17),
    V1_18(1, 18),
    V1_19(1, 19),
    V1_20(1, 20);

    private final int major;
    private final int minor;
    public static final String GOLANG_VERSION_PROPERTY_NAME = "Golang go version";

    private GoVer(int major, int minor) {
        this.major = major;
        this.minor = minor;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public boolean isAtLeast(GoVer otherVersion) {
        return this.ordinal() >= otherVersion.ordinal();
    }

    public static GoVer parse(String s) {
        String[] parts = s.split("\\.");
        if (parts.length < 2) {
            return UNKNOWN;
        }
        try {
            int major = Integer.parseInt(parts[0]);
            int minor = Integer.parseInt(parts[1]);
            for (GoVer ver : GoVer.values()) {
                if (ver.major != major || ver.minor != minor) continue;
                return ver;
            }
        }
        catch (NumberFormatException e) {
            return UNKNOWN;
        }
        return UNKNOWN;
    }

    public static GoVer fromProgramProperties(Program program) {
        Options props = program.getOptions("Program Information");
        String verStr = props.getString(GOLANG_VERSION_PROPERTY_NAME, null);
        return verStr != null ? GoVer.parse(verStr) : UNKNOWN;
    }

    public static void setProgramPropertiesWithOriginalVersionString(Options props, String s) {
        props.setString(GOLANG_VERSION_PROPERTY_NAME, s);
    }
}

