/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.golang.structmapping;

import ghidra.app.util.bin.format.golang.structmapping.EOLComment;
import ghidra.app.util.bin.format.golang.structmapping.FieldContext;
import ghidra.app.util.bin.format.golang.structmapping.FieldMarkupFunction;
import ghidra.app.util.bin.format.golang.structmapping.FieldReadFunction;
import ghidra.app.util.bin.format.golang.structmapping.Markup;
import ghidra.app.util.bin.format.golang.structmapping.MarkupReference;
import ghidra.app.util.bin.format.golang.structmapping.MarkupSession;
import ghidra.app.util.bin.format.golang.structmapping.PlateComment;
import ghidra.app.util.bin.format.golang.structmapping.ReflectionHelper;
import ghidra.app.util.bin.format.golang.structmapping.Signedness;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.Structure;
import ghidra.util.exception.CancelledException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class FieldMappingInfo<T> {
    private final Field field;
    private final String dtcFieldName;
    private final DataTypeComponent dtc;
    private final Signedness signedness;
    private final int length;
    private final List<FieldMarkupFunction<T>> markupFuncs = new ArrayList<FieldMarkupFunction<T>>();
    private FieldReadFunction<T> readerFunc;
    private Method setterMethod;

    public static <T> FieldMappingInfo<T> createEarlyBinding(Field field, DataTypeComponent dtc, Signedness signedness, int length) {
        signedness = signedness == Signedness.Unspecified ? ReflectionHelper.getDataTypeSignedness(dtc.getDataType()) : signedness;
        length = length != -1 ? length : dtc.getLength();
        return new FieldMappingInfo<T>(field, dtc.getFieldName(), dtc, signedness, length);
    }

    public static <T> FieldMappingInfo<T> createLateBinding(Field field, String fieldName, Signedness signedness, int length) {
        return new FieldMappingInfo<T>(field, fieldName, null, signedness, length);
    }

    private FieldMappingInfo(Field field, String dtcFieldName, DataTypeComponent dtc, Signedness signedness, int length) {
        this.field = field;
        this.dtcFieldName = dtcFieldName;
        this.dtc = dtc;
        this.signedness = signedness;
        this.length = length;
    }

    public Field getField() {
        return this.field;
    }

    public String getFieldName() {
        return this.dtcFieldName;
    }

    public DataTypeComponent getDtc() {
        return this.dtc;
    }

    public DataTypeComponent getDtc(Structure structure) {
        return this.dtc != null ? this.dtc : this.findDtc(structure);
    }

    public DataTypeComponent findDtc(Structure struct) {
        for (DataTypeComponent dtc : struct.getDefinedComponents()) {
            if (!this.dtcFieldName.equals(dtc.getFieldName())) continue;
            return dtc;
        }
        return null;
    }

    public FieldReadFunction<T> getReaderFunc() {
        return this.readerFunc;
    }

    public List<FieldMarkupFunction<T>> getMarkupFuncs() {
        return this.markupFuncs;
    }

    public void addMarkupFunc(FieldMarkupFunction<T> func) {
        this.markupFuncs.add(func);
    }

    public int getLength() {
        return this.length;
    }

    public Signedness getSignedness() {
        return this.signedness;
    }

    public boolean isUnsigned() {
        return this.signedness == Signedness.Unsigned;
    }

    public boolean isStructureMappedType() {
        return ReflectionHelper.hasStructureMapping(this.field.getType());
    }

    public <R> R getValue(T structInstance, Class<R> expectedType) throws IOException {
        return ReflectionHelper.getFieldValue(structInstance, this.field, expectedType);
    }

    public void addMarkupNestedFuncs() {
        Markup ma = this.field.getAnnotation(Markup.class);
        if (ma != null) {
            Class<?> fieldType = this.field.getType();
            if (!ReflectionHelper.hasStructureMapping(fieldType)) {
                throw new IllegalArgumentException("Invalid @Markup, %s is not structure mapped. %s".formatted(this.field.getType().getSimpleName(), this.field));
            }
            this.markupFuncs.add(this::markupNestedStructure);
        }
    }

    public void addMarkupReferenceFunc() {
        MarkupReference mufa = this.field.getAnnotation(MarkupReference.class);
        if (mufa != null) {
            this.markupFuncs.add(this.makeMarkupReferenceFunc(mufa.value()));
        }
    }

    public void addCommentMarkupFuncs() {
        EOLComment eca;
        Class<?> clazz = this.field.getDeclaringClass();
        PlateComment pca = this.field.getAnnotation(PlateComment.class);
        if (pca != null) {
            Method commentGetter = ReflectionHelper.getCommentMethod(clazz, pca.value(), this.field.getName());
            this.markupFuncs.add(this.createCommentMarkupFunc(commentGetter, 3, "\n"));
        }
        if ((eca = this.field.getAnnotation(EOLComment.class)) != null) {
            Method commentGetter = ReflectionHelper.getCommentMethod(clazz, eca.value(), this.field.getName());
            this.markupFuncs.add(this.createCommentMarkupFunc(commentGetter, 0, ";"));
        }
    }

    private FieldMarkupFunction<T> createCommentMarkupFunc(Method commentGetter, int commentType, String sep) {
        return (context, session) -> {
            Object obj = context.getStructureInstance();
            Object val = ReflectionHelper.callGetter(commentGetter, obj);
            if (val != null) {
                Collection c;
                if (val instanceof Collection && (c = (Collection)val).isEmpty()) {
                    return;
                }
                session.appendComment(context, commentType, null, val.toString(), sep);
            }
        };
    }

    public void setFieldValueDeserializationInfo(Class<? extends FieldReadFunction> fieldReadValueClass, Class<?> structTargetClass, String setterNameOverride) {
        Class<?> fieldType = this.field.getType();
        this.setterMethod = ReflectionHelper.findSetter(this.field.getName(), setterNameOverride, structTargetClass, fieldType);
        if (fieldReadValueClass != FieldReadFunction.class) {
            this.readerFunc = ReflectionHelper.createInstance(fieldReadValueClass, this);
            return;
        }
        if (ReflectionHelper.isPrimitiveType(fieldType)) {
            this.readerFunc = this.getReadPrimitiveValueFunc(fieldType);
            return;
        }
        if (ReflectionHelper.hasStructureMapping(fieldType)) {
            this.readerFunc = this::readStructureMappedTypeFunc;
            return;
        }
    }

    public void assignField(FieldContext<T> fieldContext, Object value) throws IOException {
        T structureInstance = fieldContext.getStructureInstance();
        if (this.setterMethod != null) {
            ReflectionHelper.callSetter(structureInstance, this.setterMethod, value);
        } else {
            ReflectionHelper.assignField(this.field, structureInstance, value);
        }
    }

    private FieldReadFunction<T> getReadPrimitiveValueFunc(Class<?> destClass) {
        if (destClass == Long.class || destClass == Long.TYPE) {
            return context -> context.fieldInfo().isUnsigned() ? context.reader().readNextUnsignedValue(context.fieldInfo().getLength()) : context.reader().readNextValue(context.fieldInfo().getLength());
        }
        if (destClass == Integer.class || destClass == Integer.TYPE) {
            return context -> context.fieldInfo().isUnsigned() ? (int)context.reader().readNextUnsignedValue(context.fieldInfo().getLength()) : (int)context.reader().readNextValue(context.fieldInfo().getLength());
        }
        if (destClass == Short.class || destClass == Short.TYPE) {
            return context -> context.fieldInfo().isUnsigned() ? (short)context.reader().readNextUnsignedValue(context.fieldInfo().getLength()) : (short)context.reader().readNextValue(context.fieldInfo().getLength());
        }
        if (destClass == Byte.class || destClass == Byte.TYPE) {
            return context -> context.fieldInfo().isUnsigned() ? (byte)context.reader().readNextUnsignedValue(context.fieldInfo().getLength()) : (byte)context.reader().readNextValue(context.fieldInfo().getLength());
        }
        if (destClass == Character.class || destClass == Character.TYPE) {
            return context -> Character.valueOf(context.fieldInfo().isUnsigned() ? (char)context.reader().readNextUnsignedValue(context.fieldInfo().getLength()) : (char)context.reader().readNextValue(context.fieldInfo().getLength()));
        }
        return null;
    }

    private Object readStructureMappedTypeFunc(FieldContext<T> context) throws IOException {
        DataType fieldDT = context.dtc() != null ? context.dtc().getDataType() : null;
        return context.structureContext().getDataTypeMapper().readStructure(this.field.getType(), fieldDT, context.reader());
    }

    private void markupNestedStructure(FieldContext<T> fieldContext, MarkupSession markupSession) throws IOException, CancelledException {
        markupSession.markup(fieldContext.getValue(Object.class), true);
    }

    private FieldMarkupFunction<T> makeMarkupReferenceFunc(String getterName) {
        getterName = getterName == null || getterName.isBlank() ? this.field.getName() : getterName;
        Method getter = ReflectionHelper.requireGetter(this.field.getDeclaringClass(), getterName);
        getter.setAccessible(true);
        return (context, session) -> this.addRefToFieldWithGetter(getter, context, session);
    }

    private void addRefToFieldWithGetter(Method getterMethod, FieldContext<T> fieldContext, MarkupSession markupSession) throws IOException {
        Object getterValue = ReflectionHelper.callGetter(getterMethod, fieldContext.getStructureInstance());
        if (getterValue != null) {
            Address getterAddr;
            Address addr;
            Address address = addr = getterValue instanceof Address ? (getterAddr = (Address)getterValue) : markupSession.getMappingContext().getAddressOfStructure(getterValue);
            if (addr != null) {
                markupSession.addReference(fieldContext, addr);
            }
        }
    }
}

