/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.commands.chained;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.macho.commands.chained.DyldChainedFixupHeader;
import ghidra.app.util.bin.format.macho.commands.dyld.BindingTable;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class DyldChainedImport
implements StructConverter {
    private static final int DYLD_CHAINED_IMPORT = 1;
    private static final int DYLD_CHAINED_IMPORT_ADDEND = 2;
    private static final int DYLD_CHAINED_IMPORT_ADDEND64 = 3;
    private int imports_format;
    private int lib_ordinal;
    private boolean weak_import;
    private long name_offset;
    private long addend;
    private String symbolName;

    DyldChainedImport(BinaryReader reader, DyldChainedFixupHeader cfh, int imports_format) throws IOException {
        this.imports_format = imports_format;
        switch (imports_format) {
            case 1: {
                int ival = reader.readNextInt();
                this.lib_ordinal = ival & 0xFF;
                this.weak_import = (ival >> 8 & 1) == 1;
                this.name_offset = ival >> 9 & 0x7FFFFF;
                break;
            }
            case 2: {
                int ival = reader.readNextInt();
                this.lib_ordinal = ival & 0xFF;
                this.weak_import = (ival >> 8 & 1) == 1;
                this.name_offset = ival >> 9 & 0x7FFFFF;
                this.addend = reader.readNextInt();
                break;
            }
            case 3: {
                long ival = reader.readNextLong();
                this.lib_ordinal = (int)(ival & 0xFFFFL);
                this.weak_import = (ival >> 8 & 1L) == 1L;
                this.name_offset = ival >> 32 & 0xFFFFFFFFFFFFFFFFL;
                this.addend = reader.readNextLong();
                break;
            }
            default: {
                throw new IOException("Bad Chained import format: " + imports_format);
            }
        }
    }

    public DyldChainedImport(BindingTable.Binding binding) {
        this.imports_format = 0;
        this.lib_ordinal = binding.getLibraryOrdinal();
        this.weak_import = binding.isWeak();
        this.name_offset = 0L;
        this.addend = 0L;
        this.symbolName = binding.getSymbolName();
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType dt = new StructureDataType("dyld_chained_import", 0);
        dt.setPackingEnabled(true);
        try {
            switch (this.imports_format) {
                case 1: {
                    dt.addBitField(DWORD, 8, "lib_ordinal", null);
                    dt.addBitField(DWORD, 1, "weak_import", null);
                    dt.addBitField(DWORD, 23, "name_offset", null);
                    break;
                }
                case 2: {
                    dt.addBitField(DWORD, 8, "lib_ordinal", null);
                    dt.addBitField(DWORD, 1, "weak_import", null);
                    dt.addBitField(DWORD, 23, "name_offset", null);
                    dt.add(DWORD, "addend", null);
                    break;
                }
                case 3: {
                    dt.addBitField(QWORD, 16, "lib_ordinal", null);
                    dt.addBitField(QWORD, 1, "weak_import", null);
                    dt.addBitField(QWORD, 15, "reserved", null);
                    dt.addBitField(QWORD, 32, "name_offset", null);
                    dt.add(QWORD, "addend", null);
                    break;
                }
                default: {
                    throw new IOException("Bad Chained import format: " + this.imports_format);
                }
            }
        }
        catch (InvalidDataTypeException invalidDataTypeException) {
            // empty catch block
        }
        dt.setCategoryPath(new CategoryPath("/MachO"));
        return dt;
    }

    public int getLibOrdinal() {
        return this.lib_ordinal;
    }

    public boolean isWeakImport() {
        return this.weak_import;
    }

    public long getNameOffset() {
        return this.name_offset;
    }

    public long getAddend() {
        return this.addend;
    }

    public String getName() {
        return this.symbolName;
    }

    public void initString(BinaryReader reader) throws IOException {
        this.symbolName = reader.readNextAsciiString();
    }
}

