/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.dyld;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheSlideFixup;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheSlideInfoCommon;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DyldCacheSlideInfo2
extends DyldCacheSlideInfoCommon {
    private static final int DYLD_CACHE_SLIDE_PAGE_ATTR_NO_REBASE = 16384;
    private static final int DYLD_CACHE_SLIDE_PAGE_ATTR_EXTRA = 32768;
    private int pageSize;
    private int pageStartsOffset;
    private int pageStartsCount;
    private int pageExtrasOffset;
    private int pageExtrasCount;
    private long deltaMask;
    private long valueAdd;
    private short[] pageStartsEntries;
    private short[] pageExtrasEntries;

    public DyldCacheSlideInfo2(BinaryReader reader, long mappingAddress, long mappingSize, long mappingFileOffset) throws IOException {
        super(reader, mappingAddress, mappingSize, mappingFileOffset);
        this.pageSize = reader.readNextInt();
        this.pageStartsOffset = reader.readNextInt();
        this.pageStartsCount = reader.readNextInt();
        this.pageExtrasOffset = reader.readNextInt();
        this.pageExtrasCount = reader.readNextInt();
        this.deltaMask = reader.readNextLong();
        this.valueAdd = reader.readNextLong();
        this.pageStartsEntries = reader.readNextShortArray(this.pageStartsCount);
        this.pageExtrasEntries = reader.readNextShortArray(this.pageExtrasCount);
    }

    public long getPageSize() {
        return Integer.toUnsignedLong(this.pageSize);
    }

    public long getPageStartsOffset() {
        return Integer.toUnsignedLong(this.pageStartsOffset);
    }

    public long getPageStartsCount() {
        return Integer.toUnsignedLong(this.pageStartsCount);
    }

    public long getPageExtrasOffset() {
        return Integer.toUnsignedLong(this.pageExtrasOffset);
    }

    public long getPageExtrasCount() {
        return Integer.toUnsignedLong(this.pageExtrasCount);
    }

    public long getDeltaMask() {
        return this.deltaMask;
    }

    public long getValueAdd() {
        return this.valueAdd;
    }

    public short[] getPageStarts() {
        return this.pageStartsEntries;
    }

    public short[] getPageExtras() {
        return this.pageExtrasEntries;
    }

    @Override
    public List<DyldCacheSlideFixup> getSlideFixups(BinaryReader reader, int pointerSize, MessageLog log, TaskMonitor monitor) throws IOException, CancelledException {
        ArrayList<DyldCacheSlideFixup> fixups = new ArrayList<DyldCacheSlideFixup>();
        monitor.initialize((long)this.pageStartsCount, "Getting DYLD Cache V2 slide fixups...");
        for (int index = 0; index < this.pageStartsCount; ++index) {
            monitor.increment();
            long segmentOffset = this.pageSize * index;
            int pageEntry = Short.toUnsignedInt(this.pageStartsEntries[index]);
            if (pageEntry == 16384) continue;
            if ((pageEntry & 0x8000) != 0) {
                int extraIndex = pageEntry & 0x3FFF;
                do {
                    pageEntry = Short.toUnsignedInt(this.pageExtrasEntries[extraIndex]);
                    long pageOffset = (pageEntry & 0x3FFF) * 4;
                    fixups.addAll(this.processPointerChain(segmentOffset, pageOffset, reader, pointerSize, monitor));
                    ++extraIndex;
                } while ((pageEntry & 0x8000) == 0);
                continue;
            }
            long pageOffset = pageEntry * 4;
            fixups.addAll(this.processPointerChain(segmentOffset, pageOffset, reader, pointerSize, monitor));
        }
        return fixups;
    }

    private List<DyldCacheSlideFixup> processPointerChain(long segmentOffset, long pageOffset, BinaryReader reader, int pointerSize, TaskMonitor monitor) throws IOException, CancelledException {
        ArrayList<DyldCacheSlideFixup> fixups = new ArrayList<DyldCacheSlideFixup>(1024);
        long valueMask = this.deltaMask ^ 0xFFFFFFFFFFFFFFFFL;
        long deltaShift = Long.numberOfTrailingZeros(this.deltaMask);
        long delta = -1L;
        while (delta != 0L) {
            monitor.checkCancelled();
            long dataOffset = segmentOffset + pageOffset;
            long chainValue = pointerSize == 8 ? reader.readLong(dataOffset) : reader.readUnsignedInt(dataOffset);
            delta = (chainValue & this.deltaMask) >> (int)deltaShift;
            if ((chainValue &= valueMask) != 0L) {
                fixups.add(new DyldCacheSlideFixup(dataOffset, chainValue += this.valueAdd, pointerSize));
            }
            pageOffset += delta * 4L;
        }
        return fixups;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("dyld_cache_slide_info2", 0);
        struct.add(DWORD, "version", "currently 2");
        struct.add(DWORD, "page_size", "currently 4096 (may also be 16384)");
        struct.add(DWORD, "page_starts_offset", "");
        struct.add(DWORD, "page_starts_count", "");
        struct.add(DWORD, "page_extras_offset", "");
        struct.add(DWORD, "page_extras_count", "");
        struct.add(QWORD, "delta_mask", "which (contiguous) set of bits contains the delta to the next rebase location");
        struct.add(QWORD, "value_add", "");
        if (this.pageStartsCount > 0) {
            if (this.pageStartsOffset > 40) {
                struct.add((DataType)new ArrayDataType(BYTE, this.pageStartsOffset - 40, -1), "align", "");
            }
            struct.add((DataType)new ArrayDataType(WORD, this.pageStartsCount, -1), "page_starts", "");
        }
        if (this.pageExtrasCount > 0) {
            if (this.pageExtrasOffset > this.pageStartsOffset + this.pageStartsCount * 2) {
                struct.add((DataType)new ArrayDataType(BYTE, this.pageExtrasOffset - (this.pageStartsOffset + this.pageStartsCount * 2), -1), "align", "");
            }
            struct.add((DataType)new ArrayDataType(WORD, this.pageExtrasCount, -1), "page_extras", "");
        }
        struct.setCategoryPath(new CategoryPath("/MachO"));
        return struct;
    }
}

