/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.omf;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.omf.OmfData;
import ghidra.app.util.bin.format.omf.OmfEnumeratedData;
import ghidra.app.util.bin.format.omf.OmfException;
import ghidra.app.util.bin.format.omf.OmfIteratedData;
import ghidra.app.util.bin.format.omf.OmfRecord;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;

public class OmfSegmentHeader
extends OmfRecord {
    private byte segAttr;
    private int frameNumber;
    private int offset;
    private long segmentLength;
    private int segmentNameIndex;
    private int classNameIndex;
    private int overlayNameIndex;
    private String segmentName;
    private String className;
    private String overlayName;
    private boolean isCode;
    private boolean isReadable;
    private boolean isWritable;
    private boolean isExecutable;
    private long vma = -1L;
    private ArrayList<OmfData> dataBlocks = new ArrayList();

    OmfSegmentHeader(int num, int datatype) {
        this.segAttr = (byte)-87;
        this.segmentLength = 0L;
        this.segmentNameIndex = 0;
        this.classNameIndex = 0;
        this.overlayNameIndex = 0;
        this.overlayName = "";
        this.segmentName = datatype == 1 ? "EXTRATEXT_" : (datatype == 2 ? "EXTRADATA_" : "EXTRA_");
        this.segmentName = this.segmentName + Integer.toString(num);
        if (datatype == 1) {
            this.className = "TEXT";
            this.isCode = true;
            this.isReadable = true;
            this.isWritable = false;
            this.isExecutable = true;
        } else {
            this.className = "DATA";
            this.isCode = false;
            this.isReadable = true;
            this.isWritable = true;
            this.isExecutable = false;
        }
    }

    public OmfSegmentHeader(BinaryReader reader) throws IOException {
        this.readRecordHeader(reader);
        boolean hasBigFields = this.hasBigFields();
        this.segAttr = reader.readNextByte();
        int A = this.segAttr >> 5 & 7;
        if (A == 0) {
            this.frameNumber = reader.readNextShort() & 0xFFFF;
            this.offset = reader.readNextByte() & 0xFF;
            this.vma = (long)this.frameNumber + (long)this.offset;
        }
        this.segmentLength = (long)OmfRecord.readInt2Or4(reader, hasBigFields) & 0xFFFFFFFFL;
        this.segmentNameIndex = OmfRecord.readIndex(reader);
        this.classNameIndex = OmfRecord.readIndex(reader);
        this.overlayNameIndex = OmfRecord.readIndex(reader);
        this.readCheckSumByte(reader);
        int B = this.segAttr >> 1 & 1;
        if (B == 1) {
            this.segmentLength = this.getRecordType() == -104 ? 65536L : 0x100000000L;
        }
    }

    public boolean isCode() {
        return this.isCode;
    }

    public boolean isReadable() {
        return this.isReadable;
    }

    public boolean isWritable() {
        return this.isWritable;
    }

    public boolean isExecutable() {
        return this.isExecutable;
    }

    public int getFrameDatum() {
        return 0;
    }

    public Address getAddress(Language language) {
        AddressSpace addrSpace = this.isCode ? language.getDefaultSpace() : language.getDefaultDataSpace();
        return addrSpace.getAddress(this.vma);
    }

    public String getName() {
        return this.segmentName;
    }

    public String getClassName() {
        return this.className;
    }

    public String getOverlayName() {
        return this.overlayName;
    }

    public long getStartAddress() {
        return this.vma;
    }

    public long getSegmentLength() {
        return this.segmentLength;
    }

    public int getAlignment() {
        return this.segAttr >> 5 & 7;
    }

    public int getCombine() {
        return this.segAttr >> 2 & 7;
    }

    public boolean is16Bit() {
        return (this.segAttr & 1) == 0;
    }

    public boolean hasNonZeroData() {
        for (OmfData block : this.dataBlocks) {
            if (block.isAllZeroes()) continue;
            return true;
        }
        return false;
    }

    protected void sortData() {
        Collections.sort(this.dataBlocks);
    }

    public InputStream getRawDataStream(BinaryReader reader, MessageLog log) throws IOException {
        return new SectionStream(reader, log);
    }

    protected long relocateSegment(long firstValidAddress, int alignOverride) throws OmfException {
        int align = this.getAlignment();
        if (alignOverride >= 0) {
            align = alignOverride;
        }
        switch (align) {
            case 0: {
                throw new OmfException("Trying to relocate an absolute segment");
            }
            case 1: {
                break;
            }
            case 2: {
                firstValidAddress = firstValidAddress + 1L & 0xFFFFFFFFFFFFFFFEL;
                break;
            }
            case 3: {
                firstValidAddress = firstValidAddress + 15L & 0xFFFFFFFFFFFFFFF0L;
                break;
            }
            case 4: {
                firstValidAddress = firstValidAddress + 4095L & 0xFFFFFFFFFFFFF000L;
                break;
            }
            case 5: {
                firstValidAddress = firstValidAddress + 3L & 0xFFFFFFFFFFFFFFFCL;
                break;
            }
            default: {
                throw new OmfException("Unsupported alignment type");
            }
        }
        this.vma = firstValidAddress;
        firstValidAddress = this.vma + this.segmentLength;
        return firstValidAddress;
    }

    protected void resolveNames(ArrayList<String> nameList) throws OmfException {
        if (this.segmentNameIndex == 0) {
            this.segmentName = "";
        } else {
            if (this.segmentNameIndex > nameList.size()) {
                throw new OmfException("Segment name index out of bounds");
            }
            this.segmentName = nameList.get(this.segmentNameIndex - 1);
        }
        if (this.classNameIndex == 0) {
            this.className = "";
        } else {
            if (this.classNameIndex > nameList.size()) {
                throw new OmfException("Class name index out of bounds");
            }
            this.className = nameList.get(this.classNameIndex - 1);
        }
        if (this.overlayNameIndex == 0) {
            this.overlayName = "";
        } else {
            if (this.overlayNameIndex > nameList.size()) {
                throw new OmfException("Overlay name index out of bounds");
            }
            this.overlayName = nameList.get(this.overlayNameIndex - 1);
        }
        this.isReadable = true;
        if (this.className.equals("CODE") || this.className.equals("code")) {
            this.isCode = true;
            this.isWritable = false;
            this.isExecutable = true;
        } else {
            this.isCode = false;
            this.isWritable = true;
            this.isExecutable = false;
        }
    }

    protected void addEnumeratedData(OmfEnumeratedData rec) {
        this.dataBlocks.add(rec);
    }

    protected void appendEnumeratedData(OmfEnumeratedData rec) {
        long blockend = rec.getDataOffset() + (long)rec.getLength();
        if (blockend > this.segmentLength) {
            this.segmentLength = blockend;
        }
        this.dataBlocks.add(rec);
    }

    protected void addIteratedData(OmfIteratedData rec) {
        this.dataBlocks.add(rec);
    }

    public class SectionStream
    extends InputStream {
        private BinaryReader reader;
        private MessageLog log;
        private long pointer;
        private byte[] buffer;
        private int bufferpointer;
        private int dataUpNext;

        public SectionStream(BinaryReader reader, MessageLog log) throws IOException {
            this.reader = reader;
            this.log = log;
            this.pointer = 0L;
            this.dataUpNext = 0;
            if (this.pointer < OmfSegmentHeader.this.segmentLength) {
                this.establishNextBuffer();
            }
        }

        private void establishNextBuffer() throws IOException {
            while (this.dataUpNext < OmfSegmentHeader.this.dataBlocks.size()) {
                OmfData data = OmfSegmentHeader.this.dataBlocks.get(this.dataUpNext);
                if (this.pointer < data.getDataOffset()) {
                    long size = data.getDataOffset() - this.pointer;
                    if (size > 8192L) {
                        throw new IOException("Unfilled hole in OMF data blocks for segment: " + OmfSegmentHeader.this.segmentName);
                    }
                    this.buffer = new byte[(int)size];
                    int i = 0;
                    while ((long)i < size) {
                        this.buffer[i] = 0;
                        ++i;
                    }
                    this.bufferpointer = 0;
                    return;
                }
                if (this.pointer == data.getDataOffset()) {
                    this.buffer = data.getByteArray(this.reader);
                    this.bufferpointer = 0;
                    ++this.dataUpNext;
                    if (this.buffer.length == 0) continue;
                    return;
                }
                ++this.dataUpNext;
                throw new IOException(String.format("Segment %s:%s has bad data offset (0x%x) in data block %d...skipping.", OmfSegmentHeader.this.segmentName, OmfSegmentHeader.this.className, data.getDataOffset(), this.dataUpNext - 1));
            }
            long size = OmfSegmentHeader.this.segmentLength - this.pointer;
            if (size > 8192L) {
                throw new IOException("Large hole at the end of OMF segment: " + OmfSegmentHeader.this.segmentName);
            }
            this.buffer = new byte[(int)size];
            int i = 0;
            while ((long)i < size) {
                this.buffer[i] = 0;
                ++i;
            }
            this.bufferpointer = 0;
        }

        @Override
        public int read() throws IOException {
            if (this.pointer < OmfSegmentHeader.this.segmentLength) {
                if (this.bufferpointer < this.buffer.length) {
                    ++this.pointer;
                    return this.buffer[this.bufferpointer++] & 0xFF;
                }
                try {
                    this.establishNextBuffer();
                    ++this.pointer;
                    return this.buffer[this.bufferpointer++] & 0xFF;
                }
                catch (IOException e) {
                    this.log.appendMsg(e.getMessage());
                }
            }
            return -1;
        }
    }
}

