/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe;

import ghidra.app.cmd.data.CreateArrayCmd;
import ghidra.app.util.bin.format.pe.LoadConfigDirectory;
import ghidra.app.util.bin.format.pe.NTHeader;
import ghidra.app.util.bin.format.pe.PeUtils;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.opinion.AbstractProgramLoader;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.ByteDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.IBO32DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.util.Msg;
import ghidra.util.exception.InvalidInputException;
import java.util.ArrayList;
import java.util.List;

public class ControlFlowGuard {
    public static String GuardCFFunctionTableName = "GuardCFFunctionTable";
    public static String GuardCFAddressTakenIatTableName = "GuardCFAddressTakenIatTable";
    public static String GuardCfgTableEntryName = "GuardCfgTableEntry";

    public static void markup(LoadConfigDirectory lcd, Program program, MessageLog log, NTHeader ntHeader) {
        boolean is64bit = ntHeader.getOptionalHeader().is64bit();
        AddressSpace space = program.getAddressFactory().getDefaultAddressSpace();
        Memory mem = program.getMemory();
        SymbolTable symbolTable = program.getSymbolTable();
        ControlFlowGuard.markupCfgCheckFunction(lcd, program, is64bit, space, mem, symbolTable);
        ControlFlowGuard.markupCfgDispatchFunction(lcd, program, is64bit, space, mem, symbolTable);
        ControlFlowGuard.markupCfgFunctionTable(lcd, program, log);
        ControlFlowGuard.markupCfgAddressTakenIatEntryTable(lcd, program, log);
        ControlFlowGuard.markupRfgFailureRoutine(lcd, program, space, symbolTable);
        ControlFlowGuard.markupRfgDefaultFailureRoutine(lcd, program, is64bit, space, mem, symbolTable);
        ControlFlowGuard.markupRfgDefaultStackPointerFunction(lcd, program, is64bit, space, mem, symbolTable);
    }

    private static void markupCfgCheckFunction(LoadConfigDirectory lcd, Program program, boolean is64bit, AddressSpace space, Memory mem, SymbolTable symbolTable) {
        if (lcd.getCfgCheckFunctionPointer() == 0L) {
            return;
        }
        try {
            Address functionPointerAddr = space.getAddress(lcd.getCfgCheckFunctionPointer());
            Address functionAddr = space.getAddress(is64bit ? mem.getLong(functionPointerAddr) : (long)mem.getInt(functionPointerAddr));
            symbolTable.createLabel(functionAddr, "_guard_check_icall", SourceType.IMPORTED);
            AbstractProgramLoader.markAsFunction(program, null, functionAddr);
        }
        catch (AddressOutOfBoundsException | MemoryAccessException | InvalidInputException e) {
            Msg.warn(ControlFlowGuard.class, (Object)"Unable to label ControlFlowGuard check function.", (Throwable)e);
        }
    }

    private static void markupCfgDispatchFunction(LoadConfigDirectory lcd, Program program, boolean is64bit, AddressSpace space, Memory mem, SymbolTable symbolTable) {
        if (lcd.getCfgDispatchFunctionPointer() == 0L) {
            return;
        }
        try {
            Address functionPointerAddr = space.getAddress(lcd.getCfgDispatchFunctionPointer());
            Address functionAddr = space.getAddress(is64bit ? mem.getLong(functionPointerAddr) : (long)mem.getInt(functionPointerAddr));
            symbolTable.createLabel(functionAddr, "_guard_dispatch_icall", SourceType.IMPORTED);
            AbstractProgramLoader.markAsFunction(program, null, functionAddr);
        }
        catch (AddressOutOfBoundsException | MemoryAccessException | InvalidInputException e) {
            Msg.warn(ControlFlowGuard.class, (Object)"Unable to label ControlFlowGuard dispatch function.", (Throwable)e);
        }
    }

    private static void markupCfgFunctionTable(LoadConfigDirectory lcd, Program program, MessageLog log) {
        int IMAGE_GUARD_CF_FUNCTION_TABLE_SIZE_MASK = -268435456;
        int IMAGE_GUARD_CF_FUNCTION_TABLE_SIZE_SHIFT = 28;
        long tablePointer = lcd.getCfgFunctionTablePointer();
        long functionCount = lcd.getCfgFunctionCount();
        if (tablePointer == 0L || functionCount <= 0L) {
            return;
        }
        Address tableAddr = program.getAddressFactory().getDefaultAddressSpace().getAddress(tablePointer);
        try {
            program.getSymbolTable().createLabel(tableAddr, GuardCFFunctionTableName, SourceType.IMPORTED);
        }
        catch (InvalidInputException e) {
            Msg.warn(ControlFlowGuard.class, (Object)"Unable to label ControlFlowGuard function table.", (Throwable)e);
        }
        LoadConfigDirectory.GuardFlags guardFlags = lcd.getCfgGuardFlags();
        int n = (guardFlags.getFlags() & 0xF0000000) >> 28;
        IBO32DataType ibo32 = new IBO32DataType();
        ByteDataType byteType = ByteDataType.dataType;
        CategoryPath categoryPath = new CategoryPath(CategoryPath.ROOT, new String[]{"CFG"});
        StructureDataType GuardCfgTableEntryType = (StructureDataType)program.getDataTypeManager().getDataType(categoryPath, GuardCfgTableEntryName);
        if (GuardCfgTableEntryType == null) {
            GuardCfgTableEntryType = new StructureDataType(categoryPath, GuardCfgTableEntryName, 0);
            GuardCfgTableEntryType.setPackingEnabled(false);
            GuardCfgTableEntryType.add((DataType)ibo32, "Offset", "");
            if (n > 0) {
                ArrayDataType padType = new ArrayDataType((DataType)byteType, n / byteType.getLength(), byteType.getLength());
                GuardCfgTableEntryType.add((DataType)padType, "Pad", "");
            }
        }
        CreateArrayCmd cmd = new CreateArrayCmd(tableAddr, (int)functionCount, (DataType)GuardCfgTableEntryType, GuardCfgTableEntryType.getLength());
        cmd.applyTo((DomainObject)program);
        Data tableData = program.getListing().getDataAt(tableAddr);
        ControlFlowGuard.createCfgFunctions(program, tableData, log);
    }

    private static void createCfgFunctions(Program program, Data tableData, MessageLog log) {
        if (tableData == null) {
            Msg.warn(ControlFlowGuard.class, (Object)"Couldn't find Control Flow Guard tables.");
            return;
        }
        if (!tableData.isArray() || tableData.getNumComponents() < 1) {
            Msg.warn(ControlFlowGuard.class, (Object)"Control Flow Guard table seems to be empty.");
            return;
        }
        for (Address target : ControlFlowGuard.getFunctionAddressesFromTable(program, tableData)) {
            AbstractProgramLoader.markAsFunction(program, null, target);
        }
    }

    private static List<Address> getFunctionAddressesFromTable(Program program, Data table) {
        ArrayList<Address> list = new ArrayList<Address>();
        for (int i = 0; i < table.getNumComponents(); ++i) {
            Data entry = table.getComponent(i);
            Data iboData = entry.getComponent(0);
            Object value = iboData.getValue();
            if (!(value instanceof Address)) continue;
            list.add((Address)value);
        }
        return list;
    }

    private static void markupCfgAddressTakenIatEntryTable(LoadConfigDirectory lcd, Program program, MessageLog log) {
        long tablePointer = lcd.getGuardAddressIatTableTablePointer();
        long functionCount = lcd.getGuardAddressIatTableCount();
        if (tablePointer == 0L || functionCount <= 0L) {
            return;
        }
        try {
            Data d;
            Address tableAddr = program.getAddressFactory().getDefaultAddressSpace().getAddress(tablePointer);
            program.getSymbolTable().createLabel(tableAddr, GuardCFAddressTakenIatTableName, SourceType.IMPORTED);
            IBO32DataType ibo32 = new IBO32DataType();
            for (long i = 0L; i < functionCount && (d = PeUtils.createData(program, tableAddr.add(i * (long)ibo32.getLength()), (DataType)ibo32, log)) != null; ++i) {
            }
        }
        catch (AddressOutOfBoundsException | InvalidInputException e) {
            Msg.warn(ControlFlowGuard.class, (Object)"Unable to label ControlFlowGuard IAT table.", (Throwable)e);
        }
    }

    private static void markupRfgFailureRoutine(LoadConfigDirectory lcd, Program program, AddressSpace space, SymbolTable symbolTable) {
        if (lcd.getRfgFailureRoutine() == 0L) {
            return;
        }
        try {
            Address routineAddr = space.getAddress(lcd.getRfgFailureRoutine());
            symbolTable.createLabel(routineAddr, "_guard_ss_verify_failure", SourceType.IMPORTED);
            AbstractProgramLoader.markAsFunction(program, null, routineAddr);
        }
        catch (AddressOutOfBoundsException | InvalidInputException e) {
            Msg.warn(ControlFlowGuard.class, (Object)"Unable to label ReturnFlowGuard failure routine.", (Throwable)e);
        }
    }

    private static void markupRfgDefaultFailureRoutine(LoadConfigDirectory lcd, Program program, boolean is64bit, AddressSpace space, Memory mem, SymbolTable symbolTable) {
        if (lcd.getRfgFailureRoutineFunctionPointer() == 0L) {
            return;
        }
        try {
            Address functionPointerAddr = space.getAddress(lcd.getRfgFailureRoutineFunctionPointer());
            Address functionAddr = space.getAddress(is64bit ? mem.getLong(functionPointerAddr) : (long)mem.getInt(functionPointerAddr));
            symbolTable.createLabel(functionAddr, "_guard_ss_verify_failure_default", SourceType.IMPORTED);
            AbstractProgramLoader.markAsFunction(program, null, functionAddr);
        }
        catch (AddressOutOfBoundsException | MemoryAccessException | InvalidInputException e) {
            Msg.warn(ControlFlowGuard.class, (Object)"Unable to label ReturnFlowGuard default failure routine.", (Throwable)e);
        }
    }

    private static void markupRfgDefaultStackPointerFunction(LoadConfigDirectory lcd, Program program, boolean is64bit, AddressSpace space, Memory mem, SymbolTable symbolTable) {
        if (lcd.getRfgVerifyStackPointerFunctionPointer() == 0L) {
            return;
        }
        try {
            Address functionPointerAddr = space.getAddress(lcd.getRfgVerifyStackPointerFunctionPointer());
            Address functionAddr = space.getAddress(is64bit ? mem.getLong(functionPointerAddr) : (long)mem.getInt(functionPointerAddr));
            symbolTable.createLabel(functionAddr, "_guard_ss_verify_sp_default", SourceType.IMPORTED);
            AbstractProgramLoader.markAsFunction(program, null, functionAddr);
        }
        catch (AddressOutOfBoundsException | MemoryAccessException | InvalidInputException e) {
            Msg.warn(ControlFlowGuard.class, (Object)"Unable to label ReturnFlowGuard verify stack pointer function.", (Throwable)e);
        }
    }
}

