/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.cli;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.pe.DataDirectory;
import ghidra.app.util.bin.format.pe.NTHeader;
import ghidra.app.util.bin.format.pe.PeUtils;
import ghidra.app.util.bin.format.pe.cli.CliMetadataRoot;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DWordDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class CliMetadataDirectory
extends DataDirectory {
    private static final String NAME = "CLI_METADATA_DIRECTORY";
    private CliMetadataRoot metadataRoot;

    public CliMetadataDirectory(NTHeader ntHeader, BinaryReader reader) throws IOException {
        this.ntHeader = ntHeader;
        this.reader = reader;
        this.virtualAddress = reader.readNextInt();
        this.size = reader.readNextInt();
    }

    public CliMetadataRoot getMetadataRoot() {
        return this.metadataRoot;
    }

    @Override
    public String getDirectoryName() {
        return NAME;
    }

    @Override
    public boolean parse() throws IOException {
        int ptr = this.getPointer();
        if (ptr < 0 || this.size == 0) {
            return false;
        }
        long origIndex = this.reader.getPointerIndex();
        this.reader.setPointerIndex(ptr);
        this.metadataRoot = new CliMetadataRoot(this.reader, this.virtualAddress);
        this.hasParsed = this.metadataRoot.parse();
        this.reader.setPointerIndex(origIndex);
        return this.hasParsed;
    }

    @Override
    public void markup(Program program, boolean isBinary, TaskMonitor monitor, MessageLog log, NTHeader ntHeader) throws DuplicateNameException, CodeUnitInsertionException, IOException, MemoryAccessException {
        if (this.metadataRoot == null) {
            return;
        }
        monitor.setMessage("[" + program.getName() + "]: CLI metadata...");
        Address addr = PeUtils.getMarkupAddress(program, isBinary, ntHeader, this.virtualAddress);
        if (!program.getMemory().contains(addr)) {
            return;
        }
        this.createDirectoryBookmark(program, addr);
        DataType dt = this.metadataRoot.toDataType();
        dt.setCategoryPath(new CategoryPath("/PE/CLI"));
        PeUtils.createData(program, addr, dt, log);
        this.metadataRoot.markup(program, isBinary, monitor, log, ntHeader);
    }

    @Override
    public DataType toDataType() throws DuplicateNameException {
        StructureDataType ddstruct = new StructureDataType(NAME, 0);
        ddstruct.add((DataType)DWordDataType.dataType, "VirtualAddress", null);
        ddstruct.add((DataType)DWordDataType.dataType, "Size", null);
        ddstruct.setCategoryPath(new CategoryPath("/PE/CLI"));
        return ddstruct;
    }
}

