/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.debug;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.pe.debug.DebugCOFFSymbol;
import ghidra.app.util.bin.format.pe.debug.DebugCOFFSymbolsHeader;
import java.io.IOException;

public class DebugCOFFSymbolTable {
    private int ptrToSymbolTable;
    private int symbolCount;
    private DebugCOFFSymbol[] symbols;

    public DebugCOFFSymbolTable(BinaryReader reader, DebugCOFFSymbolsHeader coffHeader, int offset) throws IOException {
        this.ptrToSymbolTable = coffHeader.getFirstSymbolLVA() + offset;
        this.symbolCount = coffHeader.getNumberOfSymbols();
        if (this.symbolCount > 0 && this.symbolCount < 65536) {
            this.symbols = new DebugCOFFSymbol[this.symbolCount];
            for (int i = 0; i < this.symbolCount; ++i) {
                this.symbols[i] = new DebugCOFFSymbol(reader, this.ptrToSymbolTable + i * 18, this);
            }
        }
    }

    int getStringTableIndex() {
        return this.ptrToSymbolTable + this.symbolCount * 18;
    }

    public DebugCOFFSymbol[] getSymbols() {
        return this.symbols;
    }
}

