/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.swift;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.MemoryByteProvider;
import ghidra.app.util.bin.format.swift.SwiftSection;
import ghidra.app.util.bin.format.swift.SwiftStructure;
import ghidra.app.util.bin.format.swift.SwiftUtils;
import ghidra.app.util.bin.format.swift.types.AssociatedTypeDescriptor;
import ghidra.app.util.bin.format.swift.types.AssociatedTypeRecord;
import ghidra.app.util.bin.format.swift.types.BuiltinTypeDescriptor;
import ghidra.app.util.bin.format.swift.types.CaptureDescriptor;
import ghidra.app.util.bin.format.swift.types.CaptureTypeRecord;
import ghidra.app.util.bin.format.swift.types.ContextDescriptorKind;
import ghidra.app.util.bin.format.swift.types.EntryPoint;
import ghidra.app.util.bin.format.swift.types.FieldDescriptor;
import ghidra.app.util.bin.format.swift.types.FieldRecord;
import ghidra.app.util.bin.format.swift.types.MetadataSourceRecord;
import ghidra.app.util.bin.format.swift.types.MultiPayloadEnumDescriptor;
import ghidra.app.util.bin.format.swift.types.TargetClassDescriptor;
import ghidra.app.util.bin.format.swift.types.TargetEnumDescriptor;
import ghidra.app.util.bin.format.swift.types.TargetProtocolConformanceDescriptor;
import ghidra.app.util.bin.format.swift.types.TargetProtocolDescriptor;
import ghidra.app.util.bin.format.swift.types.TargetStructDescriptor;
import ghidra.app.util.bin.format.swift.types.TargetTypeContextDescriptor;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.PointerType;
import ghidra.program.model.data.PointerTypedef;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class SwiftTypeMetadata {
    private Program program;
    private TaskMonitor monitor;
    private MessageLog log;
    private List<EntryPoint> entryPoints = new ArrayList<EntryPoint>();
    private List<BuiltinTypeDescriptor> builtinTypeDescriptors = new ArrayList<BuiltinTypeDescriptor>();
    private List<FieldDescriptor> fieldDescriptors = new ArrayList<FieldDescriptor>();
    private List<AssociatedTypeDescriptor> associatedTypeDescriptors = new ArrayList<AssociatedTypeDescriptor>();
    private List<CaptureDescriptor> captureDescriptors = new ArrayList<CaptureDescriptor>();
    private List<MultiPayloadEnumDescriptor> mpEnumDescriptors = new ArrayList<MultiPayloadEnumDescriptor>();
    private List<TargetTypeContextDescriptor> typeDescriptors = new ArrayList<TargetTypeContextDescriptor>();
    private List<TargetProtocolDescriptor> protocolDescriptors = new ArrayList<TargetProtocolDescriptor>();
    private List<TargetProtocolConformanceDescriptor> protocolConformanceDescriptors = new ArrayList<TargetProtocolConformanceDescriptor>();
    private List<SwiftStructureInfo> markupList = new ArrayList<SwiftStructureInfo>();

    public SwiftTypeMetadata(Program program, TaskMonitor monitor, MessageLog log) throws IOException, CancelledException {
        this.program = program;
        this.monitor = monitor;
        this.log = log;
        this.parse();
    }

    private void parse() throws IOException, CancelledException {
        try (MemoryByteProvider provider = MemoryByteProvider.createDefaultAddressSpaceByteProvider(this.program, false);){
            BinaryReader reader = new BinaryReader(provider, !this.program.getLanguage().isBigEndian());
            this.parseEntryPoints(SwiftSection.BLOCK_ENTRY, reader);
            this.parseBuiltinTypeDescriptors(SwiftSection.BLOCK_BUILTIN, reader);
            this.parseFieldDescriptors(SwiftSection.BLOCK_FIELDMD, reader);
            this.parseAssociatedTypeDescriptors(SwiftSection.BLOCK_ASSOCTY, reader);
            this.parseCaptureTypeDescriptors(SwiftSection.BLOCK_CAPTURE, reader);
            this.parseMultiPayloadEnumDescriptors(SwiftSection.BLOCK_MPENUM, reader);
            this.parseProtocolDescriptors(SwiftSection.BLOCK_PROTOCS, reader);
            this.parseProtocolConformanceDescriptors(SwiftSection.BLOCK_CONFORM, reader);
            this.parseTypeDescriptors(SwiftSection.BLOCK_TYPES, reader);
        }
    }

    private void parseEntryPoints(SwiftSection section, BinaryReader reader) throws CancelledException {
        this.monitor.setMessage("Parsing Swift entry point(s)...");
        this.monitor.setIndeterminate(true);
        try {
            for (MemoryBlock block : SwiftUtils.getSwiftBlocks(section, this.program)) {
                this.monitor.checkCancelled();
                Address blockStart = block.getStart();
                reader.setPointerIndex(blockStart.getOffset());
                EntryPoint entryPoint = new EntryPoint(reader);
                this.entryPoints.add(entryPoint);
                this.markupList.add(new SwiftStructureInfo(entryPoint, new SwiftStructureAddress(blockStart, null)));
            }
        }
        catch (IOException e) {
            this.log("Failed to parse entry point(s) from section '" + section + "'");
        }
    }

    private void parseBuiltinTypeDescriptors(SwiftSection section, BinaryReader reader) throws CancelledException {
        this.monitor.setMessage("Parsing Swift builtin type descriptors...");
        this.monitor.setIndeterminate(true);
        try {
            for (MemoryBlock block : SwiftUtils.getSwiftBlocks(section, this.program)) {
                Address blockStart = block.getStart();
                reader.setPointerIndex(blockStart.getOffset());
                int i = 0;
                while ((long)(i + 20) <= block.getSize()) {
                    this.monitor.checkCancelled();
                    BuiltinTypeDescriptor descriptor = new BuiltinTypeDescriptor(reader);
                    this.builtinTypeDescriptors.add(descriptor);
                    this.markupList.add(new SwiftStructureInfo(descriptor, new SwiftStructureAddress(blockStart.add((long)i), null)));
                    i += 20;
                }
            }
        }
        catch (IOException e) {
            this.log("Failed to parse builtin type descriptors from section '" + section + "'");
        }
    }

    private void parseFieldDescriptors(SwiftSection section, BinaryReader reader) throws CancelledException {
        this.monitor.setMessage("Parsing Swift field descriptors...");
        this.monitor.setIndeterminate(true);
        try {
            for (MemoryBlock block : SwiftUtils.getSwiftBlocks(section, this.program)) {
                Address blockStart = block.getStart();
                reader.setPointerIndex(blockStart.getOffset());
                int i = 0;
                while ((long)(i + 16) <= block.getSize()) {
                    this.monitor.checkCancelled();
                    FieldDescriptor descriptor = new FieldDescriptor(reader);
                    this.fieldDescriptors.add(descriptor);
                    this.markupList.add(new SwiftStructureInfo(descriptor, new SwiftStructureAddress(blockStart.add((long)i), null)));
                    List<FieldRecord> records = descriptor.getFieldRecords();
                    i += 16;
                    for (int j = 0; j < records.size(); ++j) {
                        FieldRecord record = records.get(j);
                        this.markupList.add(new SwiftStructureInfo(record, new SwiftStructureAddress(blockStart.add((long)(i + j * 12)), null)));
                    }
                    i += descriptor.getNumFields() * 12;
                }
            }
        }
        catch (IOException e) {
            this.log("Failed to parse field descriptors from section '" + section + "'");
        }
    }

    private void parseAssociatedTypeDescriptors(SwiftSection section, BinaryReader reader) throws CancelledException {
        this.monitor.setMessage("Parsing Swift associated type descriptors...");
        this.monitor.setIndeterminate(true);
        try {
            for (MemoryBlock block : SwiftUtils.getSwiftBlocks(section, this.program)) {
                Address blockStart = block.getStart();
                reader.setPointerIndex(blockStart.getOffset());
                int i = 0;
                while ((long)(i + 16) <= block.getSize()) {
                    this.monitor.checkCancelled();
                    AssociatedTypeDescriptor descriptor = new AssociatedTypeDescriptor(reader);
                    this.associatedTypeDescriptors.add(descriptor);
                    this.markupList.add(new SwiftStructureInfo(descriptor, new SwiftStructureAddress(blockStart.add((long)i), null)));
                    List<AssociatedTypeRecord> records = descriptor.getAssociatedTypeRecords();
                    i += 16;
                    for (int j = 0; j < records.size(); ++j) {
                        AssociatedTypeRecord record = records.get(j);
                        this.markupList.add(new SwiftStructureInfo(record, new SwiftStructureAddress(blockStart.add((long)(i + j * 8)), null)));
                    }
                    i += descriptor.getNumAssociatedTypes() * 8;
                }
            }
        }
        catch (IOException e) {
            this.log("Failed to parse associated type descriptors from section '" + section + "'");
        }
    }

    private void parseCaptureTypeDescriptors(SwiftSection section, BinaryReader reader) throws CancelledException {
        this.monitor.setMessage("Parsing Swift capture descriptors...");
        this.monitor.setIndeterminate(true);
        try {
            for (MemoryBlock block : SwiftUtils.getSwiftBlocks(section, this.program)) {
                Address blockStart = block.getStart();
                reader.setPointerIndex(blockStart.getOffset());
                int i = 0;
                while ((long)(i + 12) <= block.getSize()) {
                    this.monitor.checkCancelled();
                    CaptureDescriptor descriptor = new CaptureDescriptor(reader);
                    this.captureDescriptors.add(descriptor);
                    this.markupList.add(new SwiftStructureInfo(descriptor, new SwiftStructureAddress(blockStart.add((long)i), null)));
                    List<CaptureTypeRecord> records = descriptor.getCaptureTypeRecords();
                    i += 12;
                    for (int j = 0; j < records.size(); ++j) {
                        CaptureTypeRecord record = records.get(j);
                        this.markupList.add(new SwiftStructureInfo(record, new SwiftStructureAddress(blockStart.add((long)(i + j * 4)), null)));
                    }
                    i += descriptor.getNumCaptureTypes() * 4;
                    List<MetadataSourceRecord> sourceRecords = descriptor.getMetadataSourceRecords();
                    for (int j = 0; j < sourceRecords.size(); ++j) {
                        MetadataSourceRecord record = sourceRecords.get(j);
                        this.markupList.add(new SwiftStructureInfo(record, new SwiftStructureAddress(blockStart.add((long)(i + j * 8)), null)));
                    }
                    i += descriptor.getNumMetadataSources() * 8;
                }
            }
        }
        catch (IOException e) {
            this.log("Failed to parse capture descriptors from section '" + section + "'");
        }
    }

    private void parseMultiPayloadEnumDescriptors(SwiftSection section, BinaryReader reader) throws CancelledException {
        this.monitor.setMessage("Parsing Swift multipayload enum descriptors...");
        this.monitor.setIndeterminate(true);
        try {
            for (MemoryBlock block : SwiftUtils.getSwiftBlocks(section, this.program)) {
                Address blockStart = block.getStart();
                reader.setPointerIndex(blockStart.getOffset());
                int i = 0;
                while ((long)i < block.getSize()) {
                    this.monitor.checkCancelled();
                    MultiPayloadEnumDescriptor descriptor = new MultiPayloadEnumDescriptor(reader);
                    this.mpEnumDescriptors.add(descriptor);
                    this.markupList.add(new SwiftStructureInfo(descriptor, new SwiftStructureAddress(blockStart.add((long)i), null)));
                    i = (int)((long)i + (4L + descriptor.getContentsSize()));
                }
            }
        }
        catch (IOException e) {
            this.log("Failed to parse multipayload enum descriptors from section '" + section + "'");
        }
    }

    private void parseProtocolDescriptors(SwiftSection section, BinaryReader reader) throws CancelledException {
        this.monitor.setMessage("Parsing Swift protocol descriptors...");
        this.monitor.setIndeterminate(true);
        try {
            List<SwiftStructureAddress> addrPairs = this.parsePointerTable(section, reader);
            for (SwiftStructureAddress addrPair : addrPairs) {
                reader.setPointerIndex(addrPair.structAddr().getOffset());
                TargetProtocolDescriptor descriptor = new TargetProtocolDescriptor(reader);
                this.protocolDescriptors.add(descriptor);
                this.markupList.add(new SwiftStructureInfo(descriptor, new SwiftStructureAddress(addrPair.structAddr(), addrPair.pointerAddr())));
            }
        }
        catch (IOException e) {
            this.log("Failed to parse protocol descriptors from section '" + section + "'");
        }
    }

    private void parseProtocolConformanceDescriptors(SwiftSection section, BinaryReader reader) throws CancelledException {
        this.monitor.setMessage("Parsing Swift protocol conformance descriptors...");
        this.monitor.setIndeterminate(true);
        try {
            List<SwiftStructureAddress> addrPairs = this.parsePointerTable(section, reader);
            for (SwiftStructureAddress addrPair : addrPairs) {
                reader.setPointerIndex(addrPair.structAddr().getOffset());
                TargetProtocolConformanceDescriptor descriptor = new TargetProtocolConformanceDescriptor(reader);
                this.protocolConformanceDescriptors.add(descriptor);
                this.markupList.add(new SwiftStructureInfo(descriptor, new SwiftStructureAddress(addrPair.structAddr(), addrPair.pointerAddr())));
            }
        }
        catch (IOException e) {
            this.log("Failed to parse protocol conformance descriptors from section '" + section + "'");
        }
    }

    private void parseTypeDescriptors(SwiftSection section, BinaryReader reader) throws CancelledException {
        this.monitor.setMessage("Parsing Swift type descriptors...");
        this.monitor.setIndeterminate(true);
        try {
            List<SwiftStructureAddress> addrPairs = this.parsePointerTable(section, reader);
            for (SwiftStructureAddress addrPair : addrPairs) {
                reader.setPointerIndex(addrPair.structAddr().getOffset());
                long origIndex = reader.getPointerIndex();
                TargetTypeContextDescriptor descriptor = new TargetTypeContextDescriptor(reader);
                reader.setPointerIndex(origIndex);
                int contextDescriptorKind = ContextDescriptorKind.getKind(descriptor.getFlags());
                if ((descriptor = (switch (contextDescriptorKind) {
                    case 16 -> new TargetClassDescriptor(reader);
                    case 17 -> new TargetStructDescriptor(reader);
                    case 18 -> new TargetEnumDescriptor(reader);
                    default -> {
                        this.log("Unrecognized type descriptor %d at index: 0x%x".formatted(contextDescriptorKind, origIndex));
                        yield null;
                    }
                })) == null) continue;
                this.typeDescriptors.add(descriptor);
                this.markupList.add(new SwiftStructureInfo(descriptor, new SwiftStructureAddress(addrPair.structAddr(), addrPair.pointerAddr())));
            }
        }
        catch (IOException e) {
            this.log("Failed to parse type descriptors from section '" + section + "'");
        }
    }

    private List<SwiftStructureAddress> parsePointerTable(SwiftSection section, BinaryReader reader) throws CancelledException {
        int POINTER_SIZE = 4;
        ArrayList<SwiftStructureAddress> result = new ArrayList<SwiftStructureAddress>();
        try {
            block2: for (MemoryBlock block : SwiftUtils.getSwiftBlocks(section, this.program)) {
                Address blockAddr = block.getStart();
                int i = 0;
                while ((long)i < block.getSize()) {
                    this.monitor.checkCancelled();
                    reader.setPointerIndex(blockAddr.getOffset() + (long)i);
                    Address pointerAddr = blockAddr.add((long)i);
                    int offset = reader.readInt(pointerAddr.getOffset());
                    if (offset == 0) continue block2;
                    Address structAddr = pointerAddr.add((long)offset);
                    result.add(new SwiftStructureAddress(structAddr, pointerAddr));
                    i += 4;
                }
            }
        }
        catch (IOException e) {
            this.log("Failed to parse Swift struction pointers from section '" + section + "'");
        }
        return result;
    }

    public void markup() throws CancelledException {
        this.monitor.setMessage("Marking up Swift structures...");
        this.monitor.initialize((long)this.markupList.size());
        for (SwiftStructureInfo structInfo : this.markupList) {
            this.monitor.checkCancelled();
            this.monitor.incrementProgress(1L);
            try {
                SwiftStructure struct = structInfo.struct();
                DataType dt = struct.toDataType();
                DataUtilities.createData((Program)this.program, (Address)structInfo.addr().structAddr(), (DataType)dt, (int)-1, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CLEAR_ALL_DEFAULT_CONFLICT_DATA);
                if (structInfo.addr().pointerAddr() == null) continue;
                PointerTypedef relativePtrDataType = new PointerTypedef(null, dt, 4, null, PointerType.RELATIVE);
                DataUtilities.createData((Program)this.program, (Address)structInfo.addr().pointerAddr(), (DataType)relativePtrDataType, (int)-1, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CLEAR_ALL_DEFAULT_CONFLICT_DATA);
            }
            catch (CodeUnitInsertionException | DuplicateNameException | IOException e) {
                this.log("Failed to markup: " + structInfo);
            }
        }
    }

    private void log(String message) {
        this.log.appendMsg(SwiftTypeMetadata.class.getSimpleName(), message);
    }

    private record SwiftStructureInfo(SwiftStructure struct, SwiftStructureAddress addr) {
        @Override
        public String toString() {
            return "%s %s".formatted(this.struct.getDescription(), this.addr);
        }
    }

    private record SwiftStructureAddress(Address structAddr, Address pointerAddr) {
    }
}

