/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.swift.types;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.swift.SwiftStructure;
import ghidra.app.util.bin.format.swift.SwiftUtils;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public final class BuiltinTypeDescriptor
implements SwiftStructure {
    public static final int SIZE = 20;
    private String typeName;
    private int size;
    private int alignmentAndFlags;
    private int stride;
    private int numExtraInhabitants;

    public BuiltinTypeDescriptor(BinaryReader reader) throws IOException {
        this.typeName = reader.readNext(SwiftUtils::relativeString);
        this.size = reader.readNextInt();
        this.alignmentAndFlags = reader.readNextInt();
        this.stride = reader.readNextInt();
        this.numExtraInhabitants = reader.readNextInt();
    }

    public String getTypeName() {
        return this.typeName;
    }

    public int getSize() {
        return this.size;
    }

    public int getAlignmentAndFlags() {
        return this.alignmentAndFlags;
    }

    public int getStride() {
        return this.stride;
    }

    public int getNumExtraInhabitants() {
        return this.numExtraInhabitants;
    }

    @Override
    public String getStructureName() {
        return BuiltinTypeDescriptor.class.getSimpleName();
    }

    @Override
    public String getDescription() {
        return "builtin type descriptor";
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(this.getStructureName(), 0);
        struct.add((DataType)SwiftUtils.PTR_STRING, "TypeName", "");
        struct.add(DWORD, "Size", "");
        struct.add(DWORD, "AlignmentAndFlags", "");
        struct.add(DWORD, "Stride", "");
        struct.add(DWORD, "NumExtraInhabitants", "");
        struct.setCategoryPath(new CategoryPath("/Swift"));
        return struct;
    }
}

