/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import docking.widgets.checkbox.GCheckBox;
import docking.widgets.label.GDLabel;
import ghidra.app.util.viewer.field.FileOffsetFieldOptionsWrappedOption;
import ghidra.framework.options.CustomOptionsEditor;
import ghidra.util.HTMLUtilities;
import ghidra.util.layout.PairLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.beans.PropertyEditorSupport;
import javax.swing.JPanel;

public class FileOffsetFieldOptionsPropertyEditor
extends PropertyEditorSupport
implements CustomOptionsEditor {
    private static final String SHOW_FILENAME_LABEL = "Show Filename";
    private static final String USE_HEX_LABEL = "Show Numbers In Hex";
    private static final String[] NAMES = new String[]{"Show Filename", "Show Numbers In Hex"};
    private static final String SHOW_FILENAME_TOOLTIP = HTMLUtilities.toWrappedHTML((String)"Prepends the filename to the file offset in the File Offset field.", (int)75);
    private static final String USE_HEX_TOOLTIP = HTMLUtilities.toWrappedHTML((String)"Toggles displaying file offsets in hexadecimal/decimal in the File Offset field.", (int)75);
    private static final String[] DESCRIPTIONS = new String[]{SHOW_FILENAME_TOOLTIP, USE_HEX_TOOLTIP};
    private FileOffsetFieldOptionsWrappedOption option;
    private Component editorComponent = this.buildEditor();
    private GCheckBox showFilenameCheckbox;
    private GCheckBox useHexCheckbox;

    private Component buildEditor() {
        JPanel panel = new JPanel((LayoutManager)new PairLayout(6, 10));
        GDLabel showFilenameLabel = new GDLabel(SHOW_FILENAME_LABEL, 4);
        showFilenameLabel.setToolTipText(SHOW_FILENAME_TOOLTIP);
        panel.add((Component)showFilenameLabel);
        this.showFilenameCheckbox = new GCheckBox();
        this.showFilenameCheckbox.setToolTipText(SHOW_FILENAME_TOOLTIP);
        panel.add((Component)this.showFilenameCheckbox);
        GDLabel useHexLabel = new GDLabel(USE_HEX_LABEL, 4);
        useHexLabel.setToolTipText(USE_HEX_TOOLTIP);
        panel.add((Component)useHexLabel);
        this.useHexCheckbox = new GCheckBox();
        this.useHexCheckbox.setToolTipText(USE_HEX_TOOLTIP);
        panel.add((Component)this.useHexCheckbox);
        this.showFilenameCheckbox.addItemListener(evt -> this.firePropertyChange());
        this.useHexCheckbox.addItemListener(evt -> this.firePropertyChange());
        return panel;
    }

    @Override
    public void setValue(Object value) {
        if (!(value instanceof FileOffsetFieldOptionsWrappedOption)) {
            return;
        }
        this.option = (FileOffsetFieldOptionsWrappedOption)value;
        this.setLocalValues(this.option);
        this.firePropertyChange();
    }

    private void setLocalValues(FileOffsetFieldOptionsWrappedOption option) {
        if (option.showFilename() != this.showFilenameCheckbox.isSelected()) {
            this.showFilenameCheckbox.setSelected(option.showFilename());
        }
        if (option.useHex() != this.useHexCheckbox.isSelected()) {
            this.useHexCheckbox.setSelected(option.useHex());
        }
    }

    private FileOffsetFieldOptionsWrappedOption cloneFileOffsetValues() {
        FileOffsetFieldOptionsWrappedOption newOption = new FileOffsetFieldOptionsWrappedOption();
        newOption.setShowFilename(this.showFilenameCheckbox.isSelected());
        newOption.setUseHex(this.useHexCheckbox.isSelected());
        return newOption;
    }

    public String[] getOptionDescriptions() {
        return DESCRIPTIONS;
    }

    public String[] getOptionNames() {
        return NAMES;
    }

    @Override
    public Object getValue() {
        return this.cloneFileOffsetValues();
    }

    @Override
    public Component getCustomEditor() {
        return this.editorComponent;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }
}

