/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.util;

import ghidra.app.util.viewer.util.AddressPixelMap;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import java.awt.Rectangle;

public class MemoryBlockMap
implements AddressPixelMap {
    private Program program;
    private MemoryBlock[] blocks;
    private float addressesPerPixel;
    private int[] pixels;

    public MemoryBlockMap(Program program) {
        this.program = program;
    }

    @Override
    public void createMapping(int width) {
        if (width <= 0) {
            return;
        }
        this.blocks = this.includeBlocks();
        this.pixels = new int[this.blocks.length];
        long totalSize = 0L;
        for (MemoryBlock block : this.blocks) {
            totalSize += block.getSize();
        }
        this.addressesPerPixel = (float)totalSize / (float)width;
        for (int i = 0; i < this.blocks.length; ++i) {
            this.pixels[i] = Math.round((float)this.blocks[i].getSize() / this.addressesPerPixel);
        }
    }

    protected MemoryBlock[] includeBlocks() {
        return this.program.getMemory().getBlocks();
    }

    @Override
    public Address getAddress(int pixel) {
        if (this.pixels == null) {
            return null;
        }
        try {
            int curPos = 0;
            for (int i = 0; i < this.pixels.length; ++i) {
                int curSize = this.pixels[i];
                if (curPos + curSize > pixel) {
                    return this.blocks[i].getStart().add((long)Math.round((float)(pixel - curPos) * this.addressesPerPixel));
                }
                curPos += curSize;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    public int getPixel(Address address) {
        if (address == null || this.pixels == null || this.blocks == null) {
            return -1;
        }
        int curPixel = 0;
        for (int i = 0; i < this.blocks.length; ++i) {
            MemoryBlock block = this.blocks[i];
            if (block.contains(address)) {
                long offset = address.subtract(block.getStart());
                return curPixel + Math.round((float)offset / this.addressesPerPixel);
            }
            curPixel += this.pixels[i];
        }
        return -1;
    }

    @Override
    public MemoryBlock[] getBlocks() {
        return this.blocks;
    }

    @Override
    public Rectangle getBlockPosition(MemoryBlock block) {
        int x = 0;
        for (int i = 0; i < this.blocks.length; ++i) {
            if (block == this.blocks[i]) {
                return new Rectangle(x, 0, this.pixels[i], 0);
            }
            x += this.pixels[i];
        }
        return null;
    }

    @Override
    public void clear() {
        this.blocks = null;
        this.pixels = null;
    }
}

