/*
 * Decompiled with CFR 0.152.
 */
package ghidra.formats.gfilesystem.crypto;

import docking.DialogComponentProvider;
import docking.DockingWindowManager;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.crypto.CryptoProvider;
import ghidra.formats.gfilesystem.crypto.PasswordDialog;
import ghidra.formats.gfilesystem.crypto.PasswordProvider;
import ghidra.framework.generic.auth.Password;
import java.awt.Component;
import java.util.Iterator;
import javax.swing.JFrame;

public class PopupGUIPasswordProvider
implements PasswordProvider {
    @Override
    public Iterator<Password> getPasswordsFor(FSRL fsrl, String prompt, CryptoProvider.Session session) {
        return new PasswordIterator(session, fsrl, prompt);
    }

    class PasswordIterator
    implements Iterator<Password> {
        private SessionState sessionState;
        private FSRL fsrl;
        private boolean cancelled;
        private Password password;
        private String prompt;
        private int tryCount;

        PasswordIterator(CryptoProvider.Session session, FSRL fsrl, String prompt) {
            this.sessionState = session.getStateValue(PopupGUIPasswordProvider.this, SessionState::new);
            this.fsrl = fsrl;
            this.prompt = prompt;
        }

        private void showDlg() {
            Object dlgPrompt;
            Object object = dlgPrompt = this.prompt != null && !this.prompt.isBlank() ? this.prompt : this.fsrl.getName();
            if (!((String)dlgPrompt).endsWith(":")) {
                dlgPrompt = (String)dlgPrompt + ":";
            }
            ++this.tryCount;
            String dlgTitle = "Enter Password" + (String)(this.tryCount > 1 ? " (Try " + this.tryCount + ")" : "");
            PasswordDialog pwdDialog = new PasswordDialog(dlgTitle, (String)dlgPrompt);
            DockingWindowManager winMgr = DockingWindowManager.getActiveInstance();
            JFrame rootFrame = winMgr != null ? winMgr.getRootFrame() : null;
            DockingWindowManager.showDialog((Component)rootFrame, (DialogComponentProvider)pwdDialog);
            this.cancelled = pwdDialog.resultState == PasswordDialog.RESULT_STATE.CANCELED;
            this.password = this.cancelled ? null : Password.wrap((char[])pwdDialog.passwordField.getPassword());
            this.sessionState.cancelAll = this.sessionState.cancelAll | (this.cancelled && pwdDialog.cancelledAll);
            pwdDialog.dispose();
        }

        @Override
        public boolean hasNext() {
            if (this.cancelled || this.sessionState.cancelAll) {
                return false;
            }
            if (this.password == null) {
                this.showDlg();
            }
            return !this.cancelled;
        }

        @Override
        public Password next() {
            Password result = this.password;
            this.password = null;
            return result;
        }
    }

    static class SessionState {
        boolean cancelAll;

        SessionState() {
        }
    }
}

