/*
 * Decompiled with CFR 0.152.
 */
package ghidra.formats.gfilesystem.fileinfo;

import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.fileinfo.FileAttributeTypeGroup;
import ghidra.formats.gfilesystem.fileinfo.FileType;
import java.util.Date;

public enum FileAttributeType {
    FSRL_ATTR("FSRL", FileAttributeTypeGroup.GENERAL_INFO, FSRL.class),
    NAME_ATTR("Name", FileAttributeTypeGroup.GENERAL_INFO, String.class),
    PATH_ATTR("Path", FileAttributeTypeGroup.GENERAL_INFO, String.class),
    FILE_TYPE_ATTR("File type", FileAttributeTypeGroup.GENERAL_INFO, FileType.class),
    PROJECT_FILE_ATTR("Project file", FileAttributeTypeGroup.GENERAL_INFO, String.class),
    SIZE_ATTR("Size", FileAttributeTypeGroup.SIZE_INFO, Long.class),
    COMPRESSED_SIZE_ATTR("Compressed size", FileAttributeTypeGroup.SIZE_INFO, Long.class),
    CREATE_DATE_ATTR("Create date", FileAttributeTypeGroup.DATE_INFO, Date.class),
    MODIFIED_DATE_ATTR("Last modified date", FileAttributeTypeGroup.DATE_INFO, Date.class),
    ACCESSED_DATE_ATTR("Last accessed date", FileAttributeTypeGroup.DATE_INFO, Date.class),
    USER_NAME_ATTR("User", FileAttributeTypeGroup.OWNERSHIP_INFO, String.class),
    USER_ID_ATTR("UserId", FileAttributeTypeGroup.OWNERSHIP_INFO, Long.class),
    GROUP_NAME_ATTR("Group", FileAttributeTypeGroup.OWNERSHIP_INFO, String.class),
    GROUP_ID_ATTR("GroupId", FileAttributeTypeGroup.OWNERSHIP_INFO, Long.class),
    UNIX_ACL_ATTR("Unix acl", FileAttributeTypeGroup.PERMISSION_INFO, Long.class),
    IS_ENCRYPTED_ATTR("Is encrypted?", FileAttributeTypeGroup.ENCRYPTION_INFO, Boolean.class),
    HAS_GOOD_PASSWORD_ATTR("Password available?", FileAttributeTypeGroup.ENCRYPTION_INFO, Boolean.class),
    SYMLINK_DEST_ATTR("Symbolic link destination", FileAttributeTypeGroup.MISC_INFO, String.class),
    COMMENT_ATTR("Comment", FileAttributeTypeGroup.MISC_INFO, String.class),
    UNKNOWN_ATTRIBUTE("Other attribute", FileAttributeTypeGroup.ADDITIONAL_INFO, Object.class);

    private final String displayName;
    private final FileAttributeTypeGroup group;
    private final Class<?> valueType;

    private FileAttributeType(String displayName, FileAttributeTypeGroup group, Class<?> valueType) {
        this.displayName = displayName;
        this.group = group;
        this.valueType = valueType;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public FileAttributeTypeGroup getGroup() {
        return this.group;
    }

    public Class<?> getValueType() {
        return this.valueType;
    }
}

