/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.search.memory;

import ghidra.app.plugin.core.searchmem.RegExSearchData;
import ghidra.app.plugin.core.searchmem.SearchData;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.util.ProgramSelection;
import ghidra.util.search.memory.CodeUnitSearchInfo;
import ghidra.util.search.memory.MemSearcherAlgorithm;
import ghidra.util.search.memory.MemorySearchAlgorithm;
import ghidra.util.search.memory.RegExMemSearcherAlgorithm;
import ghidra.util.task.TaskListener;

public class SearchInfo {
    private final SearchData searchData;
    private int searchLimit;
    private final boolean forwardSearch;
    protected final boolean searchSelection;
    private final int alignment;
    private final CodeUnitSearchInfo codeUnitSearchInfo;
    private final TaskListener listener;
    protected final boolean includeNonLoadedBlocks;

    public SearchInfo(SearchData searchData, int matchLimit, boolean searchSelection, boolean forwardSearch, int alignment, boolean includeNonLoadedBlocks, TaskListener listener) {
        this(searchData, matchLimit, searchSelection, forwardSearch, alignment, includeNonLoadedBlocks, new CodeUnitSearchInfo(true, true, true), listener);
    }

    public SearchInfo(SearchData searchData, int searchLimit, boolean searchSelection, boolean forwardSearch, int alignment, boolean includeNonLoadedBlocks, CodeUnitSearchInfo codeUnitSearchInfo, TaskListener listener) {
        this.searchData = searchData;
        this.searchLimit = searchLimit;
        this.searchSelection = searchSelection;
        this.forwardSearch = forwardSearch;
        this.alignment = alignment;
        this.listener = listener;
        this.codeUnitSearchInfo = codeUnitSearchInfo;
        this.includeNonLoadedBlocks = includeNonLoadedBlocks;
    }

    protected AddressSetView getSearchableAddressSet(Program program, Address startAddress, ProgramSelection selection) {
        Address end;
        AddressSetView set;
        if (startAddress == null) {
            return new AddressSet();
        }
        Memory memory = program.getMemory();
        AddressSetView addressSetView = set = this.includeNonLoadedBlocks ? memory.getAllInitializedAddressSet() : memory.getLoadedAndInitializedAddressSet();
        if (this.searchSelection && selection != null && !selection.isEmpty()) {
            set = set.intersect((AddressSetView)selection);
        }
        Address start = this.forwardSearch ? startAddress : memory.getMinAddress();
        Address address = end = this.forwardSearch ? memory.getMaxAddress() : startAddress;
        if (start.compareTo((Object)end) > 0) {
            return new AddressSet();
        }
        AddressSet addressSet = program.getAddressFactory().getAddressSet(start, end);
        return set.intersect((AddressSetView)addressSet);
    }

    public MemorySearchAlgorithm createSearchAlgorithm(Program p, Address start, ProgramSelection selection) {
        AddressSetView asView = this.getSearchableAddressSet(p, start, selection);
        boolean searchAcrossGaps = false;
        if (this.searchData instanceof RegExSearchData) {
            return new RegExMemSearcherAlgorithm(this, asView, p, searchAcrossGaps);
        }
        return new MemSearcherAlgorithm(this, asView, p);
    }

    public boolean isSearchForward() {
        return this.forwardSearch;
    }

    public boolean isSearchAll() {
        return false;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public TaskListener getListener() {
        return this.listener;
    }

    public SearchData getSearchData() {
        return this.searchData;
    }

    public CodeUnitSearchInfo getCodeUnitSearchInfo() {
        return this.codeUnitSearchInfo;
    }

    public int getSearchLimit() {
        return this.searchLimit;
    }

    public void setSearchLimit(int searchLimit) {
        this.searchLimit = searchLimit;
    }
}

