/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.table.field;

import docking.widgets.table.GTableCellRenderingData;
import ghidra.docking.settings.FormatSettingsDefinition;
import ghidra.docking.settings.Settings;
import ghidra.program.model.data.EndianSettingsDefinition;
import ghidra.util.StringFormat;
import ghidra.util.table.column.AbstractGColumnRenderer;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableModel;

public class MonospacedByteRenderer
extends AbstractGColumnRenderer<Byte[]> {
    protected void configureFont(JTable table, TableModel model, int column) {
        this.setFont(this.getFixedWidthFont());
    }

    private String formatBytes(Byte[] bytes, Settings settings) {
        int format;
        boolean bigEndian = EndianSettingsDefinition.DEF.getChoice(settings) != 1;
        int startIx = 0;
        int endIx = bytes.length;
        int inc = 1;
        if (!bigEndian) {
            startIx = bytes.length - 1;
            endIx = -1;
            inc = -1;
        }
        if ((format = FormatSettingsDefinition.DEF.getChoice(settings)) == 4) {
            return this.bytesToString(bytes);
        }
        StringBuilder buffer = new StringBuilder();
        for (int i = startIx; i != endIx; i += inc) {
            if (buffer.length() != 0) {
                buffer.append(' ');
            }
            buffer.append(this.getByteString(bytes[i], format));
        }
        return buffer.toString();
    }

    private String bytesToString(Byte[] bytes) {
        StringBuilder buf = new StringBuilder();
        Byte[] byteArray = bytes;
        int n = byteArray.length;
        for (int i = 0; i < n; ++i) {
            byte b = byteArray[i];
            char c = (char)(b & 0xFF);
            if (c > ' ' && c < '\u0080') {
                buf.append((char)(b & 0xFF));
                continue;
            }
            buf.append('.');
        }
        return buf.toString();
    }

    private String getByteString(Byte b, int format) {
        String val;
        switch (format) {
            case 1: {
                val = Integer.toString(b.byteValue());
                break;
            }
            case 2: {
                val = Integer.toBinaryString(b & 0xFF);
                val = StringFormat.padIt((String)val, (int)8, (char)'\u0000', (boolean)true);
                break;
            }
            case 3: {
                val = Integer.toOctalString(b & 0xFF);
                val = StringFormat.padIt((String)val, (int)3, (char)'\u0000', (boolean)true);
                break;
            }
            default: {
                val = Integer.toHexString(b & 0xFF).toUpperCase();
                val = StringFormat.padIt((String)val, (int)2, (char)'\u0000', (boolean)true);
            }
        }
        return val;
    }

    public Component getTableCellRendererComponent(GTableCellRenderingData data) {
        JLabel label = (JLabel)super.getTableCellRendererComponent(data);
        Object value = data.getValue();
        Settings settings = data.getColumnSettings();
        Byte[] bytes = (Byte[])value;
        this.setText(this.formatBytes(bytes, settings));
        return label;
    }

    public String getFilterString(Byte[] t, Settings settings) {
        String formatted = this.formatBytes(t, settings);
        return formatted;
    }
}

