/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb.manager.impl.cmd;

import agent.gdb.manager.evt.GdbCommandDoneEvent;
import agent.gdb.manager.impl.GdbManagerImpl;
import agent.gdb.manager.impl.GdbPendingCommand;
import agent.gdb.manager.impl.cmd.AbstractGdbCommandWithThreadId;
import java.nio.ByteBuffer;

public class GdbWriteMemoryCommand
extends AbstractGdbCommandWithThreadId<Void> {
    private final long addr;
    private final ByteBuffer buf;
    private final int len;

    public GdbWriteMemoryCommand(GdbManagerImpl manager, Integer threadId, long addr, ByteBuffer buf, int len) {
        super(manager, threadId);
        this.addr = addr;
        this.buf = buf.duplicate();
        this.len = len;
    }

    @Override
    protected String encode(String threadPart) {
        ByteBuffer dup = this.buf.duplicate();
        StringBuilder b = new StringBuilder();
        b.append("-data-write-memory-bytes");
        b.append(threadPart);
        b.append(" 0x");
        b.append(Long.toHexString(this.addr));
        b.append(" ");
        for (int i = 0; i < this.len; ++i) {
            int n = dup.get();
            if (n < 0) {
                n += 256;
            }
            b.append(String.format("%02x", n));
        }
        return b.toString();
    }

    @Override
    public Void complete(GdbPendingCommand<?> pending) {
        pending.checkCompletion(GdbCommandDoneEvent.class);
        return null;
    }
}

