/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb.model.impl;

import agent.gdb.manager.impl.GdbMemoryMapping;
import agent.gdb.manager.impl.cmd.GdbStateChangeRecord;
import agent.gdb.model.impl.GdbModelTargetProcessMemory;
import ghidra.async.AsyncUtils;
import ghidra.dbg.agent.AbstractDebuggerObjectModel;
import ghidra.dbg.agent.DefaultTargetObject;
import ghidra.dbg.target.TargetMemoryRegion;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.dbg.util.PathUtils;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFormatException;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

@TargetObjectSchemaInfo(name="MemoryRegion", elements={@TargetElementType(type=Void.class)}, attributes={@TargetAttributeType(type=Void.class)})
public class GdbModelTargetMemoryRegion
extends DefaultTargetObject<TargetObject, GdbModelTargetProcessMemory>
implements TargetMemoryRegion {
    protected static final String OBJFILE_ATTRIBUTE_NAME = "_objfile";
    protected static final String OFFSET_ATTRIBUTE_NAME = "_offset";
    protected AddressRangeImpl range;
    protected final String flags;
    protected final String objfile;
    protected final long offset;
    protected final String display;

    protected static String indexRegion(GdbMemoryMapping mapping) {
        return mapping.getStart().toString(16);
    }

    protected static String keyRegion(GdbMemoryMapping mapping) {
        return PathUtils.makeKey((String)GdbModelTargetMemoryRegion.indexRegion(mapping));
    }

    protected static String computeDisplay(GdbMemoryMapping mapping) {
        if (mapping.getObjfile() == null || mapping.getObjfile().length() == 0) {
            return String.format("?? (0x%x-0x%x)", mapping.getStart(), mapping.getEnd());
        }
        return String.format("%s (0x%x-0x%x,0x%x)", mapping.getObjfile(), mapping.getStart(), mapping.getEnd(), mapping.getOffset());
    }

    public GdbModelTargetMemoryRegion(GdbModelTargetProcessMemory memory, GdbMemoryMapping mapping) {
        super((AbstractDebuggerObjectModel)memory.impl, (TargetObject)memory, GdbModelTargetMemoryRegion.keyRegion(mapping), "MemoryRegion");
        memory.impl.addModelObject(mapping, (TargetObject)this);
        try {
            Address min = memory.impl.getAddressFactory().getDefaultAddressSpace().getAddress(mapping.getStart().toString(16));
            this.range = new AddressRangeImpl(min, mapping.getSize().longValue());
        }
        catch (AddressFormatException | AddressOverflowException e) {
            throw new AssertionError((Object)e);
        }
        this.flags = mapping.getFlags();
        this.objfile = mapping.getObjfile();
        this.offset = mapping.getOffset().longValue();
        this.display = GdbModelTargetMemoryRegion.computeDisplay(mapping);
        this.changeAttributes(List.of(), Map.of("_memory", memory, "_range", this.range, "_readable", this.isReadable(), "_writable", this.isWritable(), "_executable", this.isExecutable(), OBJFILE_ATTRIBUTE_NAME, this.objfile, OFFSET_ATTRIBUTE_NAME, this.offset, "_display", this.display), "Initialized");
    }

    protected boolean isSame(GdbMemoryMapping mapping) {
        return this.display.equals(GdbModelTargetMemoryRegion.computeDisplay(mapping));
    }

    public AddressRange getRange() {
        return this.range;
    }

    public String getDisplay() {
        return this.display;
    }

    public GdbModelTargetProcessMemory getMemory() {
        return (GdbModelTargetProcessMemory)this.parent;
    }

    public boolean isReadable() {
        return this.flags.contains("r");
    }

    public boolean isWritable() {
        return this.flags.contains("w");
    }

    public boolean isExecutable() {
        return this.flags.contains("x");
    }

    @TargetAttributeType(name="_objfile", required=true, fixed=true, hidden=true)
    public String getObjfile() {
        return this.objfile;
    }

    @TargetAttributeType(name="_offset", required=true, fixed=true, hidden=true)
    public long getOffset() {
        return this.offset;
    }

    public CompletableFuture<Void> stateChanged(GdbStateChangeRecord sco) {
        return AsyncUtils.nil();
    }
}

