/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb.model.impl;

import agent.gdb.manager.GdbStackFrame;
import agent.gdb.manager.GdbThread;
import agent.gdb.manager.impl.cmd.GdbStateChangeRecord;
import agent.gdb.model.impl.GdbModelImpl;
import agent.gdb.model.impl.GdbModelTargetInferior;
import agent.gdb.model.impl.GdbModelTargetStackFrame;
import agent.gdb.model.impl.GdbModelTargetThread;
import ghidra.async.AsyncUtils;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.agent.AbstractDebuggerObjectModel;
import ghidra.dbg.agent.DefaultTargetObject;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetStack;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.util.datastruct.WeakValueHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

@TargetObjectSchemaInfo(name="Stack", attributes={@TargetAttributeType(type=Void.class)}, canonicalContainer=true)
public class GdbModelTargetStack
extends DefaultTargetObject<GdbModelTargetStackFrame, GdbModelTargetThread>
implements TargetStack {
    public static final String NAME = "Stack";
    protected final GdbModelImpl impl;
    protected final GdbModelTargetInferior inferior;
    protected final GdbThread thread;
    protected final Map<Integer, GdbModelTargetStackFrame> framesByLevel = new WeakValueHashMap();

    public GdbModelTargetStack(GdbModelTargetThread thread, GdbModelTargetInferior inferior) {
        super((AbstractDebuggerObjectModel)thread.impl, (TargetObject)thread, NAME, NAME);
        this.impl = thread.impl;
        this.inferior = inferior;
        this.thread = thread.thread;
    }

    public CompletableFuture<Void> requestElements(DebuggerObjectModel.RefreshBehavior refresh) {
        return this.thread.listStackFrames().thenAccept(f -> {
            List frames;
            GdbModelTargetStack gdbModelTargetStack = this;
            synchronized (gdbModelTargetStack) {
                frames = f.stream().map(this::getTargetFrame).collect(Collectors.toList());
            }
            this.setElements(frames, "Refreshed");
        });
    }

    protected synchronized GdbModelTargetStackFrame getTargetFrame(GdbStackFrame frame) {
        return this.framesByLevel.compute(frame.getLevel(), (l, f) -> {
            if (f == null) {
                return new GdbModelTargetStackFrame(this, (GdbModelTargetThread)this.parent, this.inferior, frame);
            }
            f.setFrame(frame);
            return f;
        });
    }

    protected synchronized GdbModelTargetStackFrame getTargetFrameByLevel(int i) {
        return this.framesByLevel.get(i);
    }

    protected void invalidateRegisterCaches() {
        for (GdbModelTargetStackFrame frame : this.framesByLevel.values()) {
            frame.invalidateRegisterCaches();
        }
    }

    public CompletableFuture<Void> stateChanged(GdbStateChangeRecord sco) {
        return ((CompletableFuture)this.requestElements(DebuggerObjectModel.RefreshBehavior.REFRESH_ALWAYS).thenCompose(__ -> {
            GdbModelTargetStackFrame innermost = this.framesByLevel.get(0);
            if (innermost != null) {
                return innermost.stateChanged(sco);
            }
            return AsyncUtils.nil();
        })).exceptionally(e -> {
            this.impl.reportError((Object)this, "Could not update stack " + this + " on STOPPED", (Throwable)e);
            return null;
        });
    }
}

