/*
 * Decompiled with CFR 0.152.
 */
package sarif;

import com.contrastsecurity.sarif.Artifact;
import com.contrastsecurity.sarif.ArtifactContent;
import com.contrastsecurity.sarif.ReportingDescriptor;
import com.contrastsecurity.sarif.ReportingDescriptorReference;
import com.contrastsecurity.sarif.Run;
import com.contrastsecurity.sarif.ToolComponent;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.bouncycastle.util.encoders.Base64;

public class SarifUtils {
    public static ByteArrayInputStream getArtifactContent(Artifact artifact) {
        ArtifactContent content = artifact.getContents();
        String b64 = content.getBinary();
        byte[] decoded = Base64.decode((String)b64);
        return new ByteArrayInputStream(decoded);
    }

    public static ReportingDescriptor getTaxaValue(ReportingDescriptorReference taxa, ToolComponent taxonomy) {
        ArrayList view = new ArrayList(taxonomy.getTaxa());
        return (ReportingDescriptor)view.get(taxa.getIndex().intValue());
    }

    public static ToolComponent getTaxonomy(ReportingDescriptorReference taxa, Set<ToolComponent> taxonomies) {
        Long idx = taxa.getToolComponent().getIndex();
        if (idx == null) {
            ArrayList<ToolComponent> view = new ArrayList<ToolComponent>(taxonomies);
            idx = taxa.getIndex();
            return (ToolComponent)view.get(idx instanceof Long ? idx.intValue() : ((Integer)((Object)idx)).intValue());
        }
        for (ToolComponent taxonomy : taxonomies) {
            if (!taxonomy.getName().equals(taxa.getToolComponent().getName())) continue;
            return taxonomy;
        }
        return null;
    }

    public static List<String> getTaxonomyNames(Run sarifRun) {
        ArrayList<String> names = new ArrayList<String>();
        Set taxonomies = sarifRun.getTaxonomies();
        if (taxonomies != null) {
            for (ToolComponent taxonomy : sarifRun.getTaxonomies()) {
                names.add(taxonomy.getName());
            }
        }
        return names;
    }
}

