/*
 * Decompiled with CFR 0.152.
 */
package sarif.handlers;

import com.contrastsecurity.sarif.PropertyBag;
import com.contrastsecurity.sarif.Result;
import com.contrastsecurity.sarif.Run;
import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.MenuData;
import ghidra.program.util.ProgramTask;
import ghidra.util.classfinder.ExtensionPoint;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import sarif.SarifController;
import sarif.model.SarifDataFrame;
import sarif.view.SarifResultsTableProvider;

public abstract class SarifResultHandler
implements ExtensionPoint {
    protected List<String> headers = new ArrayList<String>();
    protected SarifDataFrame df;
    protected SarifController controller;
    protected Run run;
    protected Result result;
    protected SarifResultsTableProvider provider;

    public abstract String getKey();

    public boolean isEnabled() {
        return true;
    }

    public void handle(SarifDataFrame df, Run run, Result result, Map<String, Object> map) {
        this.df = df;
        this.controller = df.getController();
        this.run = run;
        this.result = result;
        Object res = this.parse();
        if (res != null) {
            map.put(this.getKey(), res);
        }
    }

    protected abstract Object parse();

    public String getActionName() {
        return null;
    }

    protected Object getProperty(String key) {
        PropertyBag properties = this.result.getProperties();
        if (properties == null) {
            return null;
        }
        Map additionalProperties = properties.getAdditionalProperties();
        if (additionalProperties == null) {
            return null;
        }
        return additionalProperties.get(key);
    }

    public ProgramTask getTask(SarifResultsTableProvider provider) {
        return null;
    }

    public DockingAction createAction(final SarifResultsTableProvider provider) {
        this.provider = provider;
        DockingAction rightClick = new DockingAction(this.getActionName(), this.getKey()){

            public void actionPerformed(ActionContext context) {
                ProgramTask task = SarifResultHandler.this.getTask(provider);
                TaskLauncher.launch((Task)task);
            }

            public boolean isEnabledForContext(ActionContext context) {
                return true;
            }

            public boolean isAddToPopup(ActionContext context) {
                return true;
            }
        };
        rightClick.setPopupMenuData(new MenuData(new String[]{this.getActionName()}));
        return rightClick;
    }
}

