/*
 * Decompiled with CFR 0.152.
 */
package sarif.handlers.result.sample;

import com.contrastsecurity.sarif.ReportingDescriptor;
import com.contrastsecurity.sarif.ReportingDescriptorReference;
import com.contrastsecurity.sarif.ToolComponent;
import ghidra.program.model.data.BooleanDataType;
import ghidra.program.model.data.CharDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DoubleDataType;
import ghidra.program.model.data.IntegerDataType;
import ghidra.program.model.data.LongDataType;
import ghidra.program.model.data.LongDoubleDataType;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.UnsignedIntegerDataType;
import ghidra.program.model.data.UnsignedLongDataType;
import ghidra.program.model.data.VoidDataType;
import ghidra.program.model.listing.Function;
import ghidra.program.util.ProgramTask;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import sarif.handlers.SarifResultHandler;
import sarif.view.SarifResultsTableProvider;

public class SarifReturnTypeResultHandler
extends SarifResultHandler {
    @Override
    public String getKey() {
        return "return type";
    }

    @Override
    public String parse() {
        ToolComponent tc = this.df.getComponentMap().get(this.getKey());
        ReportingDescriptorReference ref = this.df.getTaxa().get(this.getKey());
        if (tc != null) {
            int index;
            ArrayList view = new ArrayList(tc.getTaxa());
            if (ref != null && (index = ref.getIndex().intValue()) < view.size()) {
                return ((ReportingDescriptor)view.get(index)).getId();
            }
        }
        return null;
    }

    @Override
    public String getActionName() {
        return "Commit";
    }

    @Override
    public ProgramTask getTask(SarifResultsTableProvider provider) {
        return new ReturnTypeTaxonomyTask(provider);
    }

    private class ReturnTypeTaxonomyTask
    extends ProgramTask {
        private SarifResultsTableProvider provider;

        protected ReturnTypeTaxonomyTask(SarifResultsTableProvider provider) {
            super(provider.getController().getProgram(), "ReturnTypeTaxonomyTask", true, true, true);
            this.provider = provider;
        }

        protected void doRun(TaskMonitor monitor) {
            int[] selected;
            int col = this.provider.getIndex("return type");
            for (int row : selected = this.provider.filterTable.getTable().getSelectedRows()) {
                Function func = this.provider.getController().getProgram().getFunctionManager().getFunctionContaining(this.provider.model.getAddress(row));
                String value = (String)this.provider.getValue(row, col);
                this.setReturnType(func, value);
            }
        }

        private boolean setReturnType(Function func, String type) {
            if (type != null) {
                try {
                    func.setReturnType(this.parseDataType(type), func.getSignatureSource());
                    return true;
                }
                catch (InvalidInputException e) {
                    throw new RuntimeException("Error setting return type for " + func);
                }
            }
            return false;
        }

        private DataType parseDataType(String datatype) {
            switch (datatype) {
                case "int": {
                    return new IntegerDataType();
                }
                case "uint": 
                case "__ssize_t": {
                    return new UnsignedIntegerDataType();
                }
                case "bool": {
                    return new BooleanDataType();
                }
                case "char": {
                    return new CharDataType();
                }
                case "char *": 
                case "FILE *": 
                case "void *": 
                case "whcar_t *": 
                case "tm *": {
                    return new PointerDataType();
                }
                case "void": {
                    return new VoidDataType();
                }
                case "double": {
                    return new DoubleDataType();
                }
                case "long": {
                    return new LongDataType();
                }
                case "longdouble": {
                    return new LongDoubleDataType();
                }
                case "ulong": {
                    return new UnsignedLongDataType();
                }
            }
            return null;
        }
    }
}

