/*
 * Decompiled with CFR 0.152.
 */
package sarif.managers;

import com.google.gson.JsonArray;
import generic.stl.Pair;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.disassemble.Disassembler;
import ghidra.program.disassemble.DisassemblerMessageListener;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.FlowOverride;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.InstructionIterator;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import sarif.SarifProgramOptions;
import sarif.export.SarifWriterTask;
import sarif.export.code.SarifCodeWriter;
import sarif.managers.SarifMgr;

public class CodeSarifMgr
extends SarifMgr
implements DisassemblerMessageListener {
    public static String KEY = "CODE";
    public static String SUBKEY = "Code";
    public static String SUBKEY2 = "Override";

    public CodeSarifMgr(Program program, MessageLog log) {
        super(KEY, program, log);
    }

    @Override
    public boolean read(Map<String, Object> result, SarifProgramOptions options, TaskMonitor monitor) throws CancelledException {
        AddressSet set = new AddressSet();
        try {
            this.getLocations(result, set);
        }
        catch (AddressOverflowException e) {
            this.log.appendException((Throwable)e);
        }
        String msg = (String)result.get("Message");
        AddressSet disset = set.intersect((AddressSetView)this.program.getMemory());
        if (!disset.equals((Object)set)) {
            this.log.appendMsg("Disassembly address set changed to " + disset.toString());
        }
        this.disassemble(disset, monitor);
        if (msg.equals(SUBKEY2)) {
            Instruction inst = this.program.getListing().getInstructionAt(set.getMinAddress());
            String override = (String)result.get("kind");
            inst.setFlowOverride(FlowOverride.valueOf((String)override));
        }
        return true;
    }

    public void disassemble(AddressSet set, TaskMonitor monitor) {
        Disassembler disassembler = Disassembler.getDisassembler((Program)this.program, (TaskMonitor)monitor, (DisassemblerMessageListener)this);
        try {
            Listing listing = this.program.getListing();
            while (!set.isEmpty() && !monitor.isCancelled()) {
                Address start = set.getMinAddress();
                AddressSet disset = disassembler.disassemble(start, (AddressSetView)set);
                if (disset.isEmpty()) {
                    Instruction instr = listing.getInstructionAt(start);
                    if (instr == null) {
                        AddressRange skipRange = (AddressRange)set.iterator().next();
                        this.log.appendMsg("Expected valid Instruction at " + start);
                        this.log.appendMsg("...skipping code range " + skipRange.getMinAddress() + " to " + skipRange.getMaxAddress());
                        set.delete(skipRange);
                        continue;
                    }
                    set.deleteRange(instr.getMinAddress(), instr.getMaxAddress());
                    continue;
                }
                set.delete((AddressSetView)disset);
            }
        }
        catch (Exception e) {
            this.log.appendMsg("Error during disassembly: " + e.getMessage());
        }
    }

    public void disassembleMessageReported(String msg) {
        this.log.appendMsg("Error from disassembler: " + msg);
    }

    void write(JsonArray results, AddressSetView set, TaskMonitor monitor) throws IOException, CancelledException {
        monitor.setMessage("Writing CODE ...");
        ArrayList<AddressRange> request = new ArrayList<AddressRange>();
        ArrayList<Pair<Instruction, FlowOverride>> requestOverride = new ArrayList<Pair<Instruction, FlowOverride>>();
        InstructionIterator it = null;
        it = set == null ? this.program.getListing().getInstructions(true) : this.program.getListing().getInstructions(set, true);
        while (it.hasNext()) {
            Instruction inst = it.next();
            Address start = inst.getMinAddress();
            Address end = inst.getMaxAddress();
            while (it.hasNext()) {
                inst = it.next();
                FlowOverride override = inst.getFlowOverride();
                if (!override.equals((Object)FlowOverride.NONE)) {
                    requestOverride.add((Pair<Instruction, FlowOverride>)new Pair((Object)inst, (Object)override));
                }
                if (!end.isSuccessor(inst.getMinAddress())) {
                    request.add((AddressRange)new AddressRangeImpl(start, end));
                    start = inst.getMinAddress();
                }
                end = inst.getMaxAddress();
                monitor.checkCancelled();
            }
            request.add((AddressRange)new AddressRangeImpl(start, end));
        }
        CodeSarifMgr.writeAsSARIF(request, requestOverride, results);
    }

    public static void writeAsSARIF(List<AddressRange> request, List<Pair<Instruction, FlowOverride>> request2, JsonArray results) throws IOException {
        SarifCodeWriter writer = new SarifCodeWriter(request, request2, null);
        new TaskLauncher((Task)new SarifWriterTask(SUBKEY, writer, results), null);
    }
}

