/*
 * Decompiled with CFR 0.152.
 */
package sarif.model;

import com.contrastsecurity.sarif.Artifact;
import com.contrastsecurity.sarif.ReportingDescriptorReference;
import com.contrastsecurity.sarif.Result;
import com.contrastsecurity.sarif.Run;
import com.contrastsecurity.sarif.SarifSchema210;
import com.contrastsecurity.sarif.ToolComponent;
import com.contrastsecurity.sarif.ToolComponentReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sarif.SarifController;
import sarif.handlers.SarifResultHandler;
import sarif.handlers.SarifRunHandler;
import sarif.managers.ProgramSarifMgr;
import sarif.model.SarifColumnKey;

public class SarifDataFrame {
    private List<SarifColumnKey> columns;
    private List<Map<String, Object>> tableResults;
    private Map<String, List<Map<String, Object>>> tableResultsAsMap;
    private SarifController controller;
    private Map<String, ToolComponent> componentMap;
    private Map<String, ReportingDescriptorReference> taxaMap;
    private String sourceLanguage;
    private String compiler;

    public SarifDataFrame(SarifSchema210 sarifLog, SarifController controller, boolean parseHeaderOnly) {
        this.controller = controller;
        this.columns = new ArrayList<SarifColumnKey>();
        this.tableResults = new ArrayList<Map<String, Object>>();
        this.tableResultsAsMap = new HashMap<String, List<Map<String, Object>>>();
        this.columns.add(new SarifColumnKey("Tool", true));
        this.columns.add(new SarifColumnKey("RuleId", true));
        this.columns.add(new SarifColumnKey("Address", false));
        this.columns.add(new SarifColumnKey("Message", false));
        this.columns.add(new SarifColumnKey("Kind", true));
        this.columns.add(new SarifColumnKey("Level", true));
        Set<SarifResultHandler> resultHandlers = controller.getSarifResultHandlers();
        for (Run run : sarifLog.getRuns()) {
            this.parseHeader(run);
            if (parseHeaderOnly) continue;
            this.compileComponentMap(run);
            for (String name : this.getComponentMap().keySet()) {
                this.columns.add(new SarifColumnKey(name, false));
            }
            ProgramSarifMgr programMgr = controller.getProgramSarifMgr();
            for (Map.Entry<String, Boolean> entry : programMgr.getKeys().entrySet()) {
                this.columns.add(new SarifColumnKey(entry.getKey(), entry.getValue()));
            }
            for (Result result : run.getResults()) {
                this.compileTaxaMap(run, result);
                HashMap<String, Object> curTableResult = new HashMap<String, Object>();
                for (SarifResultHandler handler : resultHandlers) {
                    if (!handler.isEnabled()) continue;
                    handler.handle(this, run, result, curTableResult);
                }
                this.tableResults.add(curTableResult);
                String ruleid = (String)curTableResult.get("RuleId");
                List<Map<String, Object>> list = this.tableResultsAsMap.get(ruleid);
                if (list == null) {
                    list = new ArrayList<Map<String, Object>>();
                    this.tableResultsAsMap.put(ruleid, list);
                }
                list.add(curTableResult);
            }
            for (SarifRunHandler handler : controller.getSarifRunHandlers()) {
                if (!handler.isEnabled()) continue;
                handler.handle(this, run);
            }
        }
    }

    private void parseHeader(Run run) {
        Set artifacts = run.getArtifacts();
        if (artifacts == null) {
            return;
        }
        for (Artifact next : artifacts) {
            this.sourceLanguage = next.getSourceLanguage();
            this.compiler = next.getDescription().getText();
        }
    }

    private void compileComponentMap(Run run) {
        this.componentMap = new HashMap<String, ToolComponent>();
        Set taxonomies = run.getTaxonomies();
        if (taxonomies != null) {
            for (ToolComponent tc : taxonomies) {
                this.componentMap.put(tc.getName(), tc);
            }
        }
    }

    private void compileTaxaMap(Run run, Result result) {
        this.taxaMap = new HashMap<String, ReportingDescriptorReference>();
        Set taxonomies = run.getTaxonomies();
        if (taxonomies == null) {
            return;
        }
        ArrayList view = new ArrayList(taxonomies);
        Set taxa = result.getTaxa();
        if (taxa != null) {
            for (ReportingDescriptorReference ref : taxa) {
                ToolComponentReference tc;
                long idx = ref.getToolComponent().getIndex();
                if (idx >= 0L && idx < (long)view.size()) {
                    tc = (ToolComponent)view.get((int)idx);
                    this.taxaMap.put(tc.getName(), ref);
                    continue;
                }
                tc = ref.getToolComponent();
                this.taxaMap.put(tc.getName(), ref);
            }
        }
    }

    public List<SarifColumnKey> getColumns() {
        return this.columns;
    }

    public List<Map<String, Object>> getTableResults() {
        return this.tableResults;
    }

    public Map<String, List<Map<String, Object>>> getTableResultsAsMap() {
        return this.tableResultsAsMap;
    }

    public SarifController getController() {
        return this.controller;
    }

    public Map<String, ToolComponent> getComponentMap() {
        return this.componentMap;
    }

    public Map<String, ReportingDescriptorReference> getTaxa() {
        return this.taxaMap;
    }

    public String getSourceLanguage() {
        return this.sourceLanguage;
    }

    public String getCompiler() {
        return this.compiler;
    }
}

