/*
 * Decompiled with CFR 0.152.
 */
package agent.lldb;

import agent.lldb.model.impl.LldbModelImpl;
import ghidra.dbg.DebuggerModelFactory;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.util.ConfigurableFactory;
import ghidra.program.model.listing.Program;
import java.util.concurrent.CompletableFuture;

@ConfigurableFactory.FactoryDescription(brief="lldb", htmlDetails="Connect to lldb.\nThis is best for most macOS and iOS targets, but supports many others.\nThis will access the native API, which may put Ghidra's JVM at risk.")
public class LldbInJvmDebuggerModelFactory
implements DebuggerModelFactory {
    public CompletableFuture<? extends DebuggerObjectModel> build() {
        LldbModelImpl model = new LldbModelImpl();
        return model.startLLDB(new String[0]).thenApply(__ -> model);
    }

    public int getPriority(Program program) {
        String exe;
        String osname = System.getProperty("os.name").toLowerCase();
        if (!(osname.contains("mac os x") || osname.contains("linux") || osname.contains("windows"))) {
            return -1;
        }
        if (program != null && ((exe = program.getExecutablePath()) == null || exe.isBlank())) {
            return -1;
        }
        return 40;
    }
}

