/*
 * Decompiled with CFR 0.152.
 */
package agent.lldb.manager.breakpoint;

import SWIG.SBBreakpoint;
import SWIG.SBBreakpointLocation;
import SWIG.SBProcess;
import SWIG.SBWatchpoint;
import agent.lldb.lldb.DebugBreakpoint;
import agent.lldb.lldb.DebugClient;
import agent.lldb.manager.breakpoint.LldbBreakpointDisp;
import ghidra.comm.util.BitmaskSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class LldbBreakpointInfo {
    private Object info;
    private SBProcess proc;
    private Long offset;
    private String expression;
    private final List<SBBreakpointLocation> locations;

    public LldbBreakpointInfo(SBBreakpoint bpt, boolean enabled) {
        this(bpt, bpt.GetTarget().GetProcess());
        bpt.SetEnabled(enabled);
    }

    public LldbBreakpointInfo(SBBreakpoint bpt, SBProcess process) {
        this.info = bpt;
        this.proc = process;
        this.locations = new ArrayList<SBBreakpointLocation>();
        int i = 0;
        while ((long)i < bpt.GetNumLocations()) {
            this.locations.add(bpt.GetLocationAtIndex((long)i));
            ++i;
        }
    }

    public LldbBreakpointInfo(SBWatchpoint wpt, SBProcess process) {
        this.info = wpt;
        this.proc = process;
        this.locations = new ArrayList<SBBreakpointLocation>();
    }

    public String getId() {
        return DebugClient.getId(this.info);
    }

    public int hashCode() {
        return Objects.hash(this.getId());
    }

    public String toString() {
        return DebugClient.getId(this.info);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LldbBreakpointInfo)) {
            return false;
        }
        LldbBreakpointInfo that = (LldbBreakpointInfo)obj;
        return this.getId() == that.getId();
    }

    public LldbBreakpointDisp getDisp() {
        return LldbBreakpointDisp.KEEP;
    }

    public String getExpression() {
        return this.expression;
    }

    public int getSize() {
        return 1;
    }

    public BitmaskSet<DebugBreakpoint.BreakAccess> getAccess() {
        return null;
    }

    public Long getOffset() {
        return this.offset;
    }

    public boolean isEnabled() {
        if (this.info instanceof SBBreakpoint) {
            return ((SBBreakpoint)this.info).IsEnabled();
        }
        return ((SBWatchpoint)this.info).IsEnabled();
    }

    public long getTimes() {
        if (this.info instanceof SBBreakpoint) {
            return ((SBBreakpoint)this.info).GetHitCount();
        }
        return ((SBWatchpoint)this.info).GetHitCount();
    }

    public List<SBBreakpointLocation> getLocations() {
        return this.locations;
    }

    public Object getBreakpoint() {
        return this.info;
    }

    public void setBreakpoint(Object info) {
        this.info = info;
    }

    public SBProcess getProc() {
        return this.proc;
    }

    public int getEventThread() {
        if (this.info instanceof SBBreakpoint) {
            return ((SBBreakpoint)this.info).GetThreadID().intValue();
        }
        return -1;
    }

    public long getAddressAsLong() {
        if (this.info instanceof SBBreakpoint) {
            return this.locations.get(0).GetLoadAddress().longValue();
        }
        return ((SBWatchpoint)this.info).GetWatchAddress().longValue();
    }
}

