/*
 * Decompiled with CFR 0.152.
 */
package agent.lldb.manager.cmd;

import SWIG.SBProcess;
import SWIG.SBThread;
import agent.lldb.lldb.DebugClient;
import agent.lldb.manager.cmd.AbstractLldbCommand;
import agent.lldb.manager.cmd.LldbPendingCommand;
import agent.lldb.manager.impl.LldbManagerImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class LldbListThreadsCommand
extends AbstractLldbCommand<Map<String, SBThread>> {
    protected final SBProcess process;
    private Map<String, SBThread> updatedThreadIds = new HashMap<String, SBThread>();

    public LldbListThreadsCommand(LldbManagerImpl manager, SBProcess process) {
        super(manager);
        this.process = process;
    }

    @Override
    public Map<String, SBThread> complete(LldbPendingCommand<?> pending) {
        Map<String, SBThread> threads = this.manager.getKnownThreads(this.process);
        Set<String> cur = threads.keySet();
        for (String id : this.updatedThreadIds.keySet()) {
            if (cur.contains(id)) continue;
            this.manager.addThreadIfAbsent(this.process, this.updatedThreadIds.get(id));
        }
        for (String id : new ArrayList<String>(cur)) {
            if (this.updatedThreadIds.containsKey(id)) continue;
            this.manager.removeThread(DebugClient.getId(this.process), id);
        }
        return this.manager.getKnownThreads(this.process);
    }

    @Override
    public void invoke() {
        this.updatedThreadIds.clear();
        long n = this.process.GetNumThreads();
        int i = 0;
        while ((long)i < n) {
            SBThread thread = this.process.GetThreadAtIndex((long)i);
            this.updatedThreadIds.put(DebugClient.getId(thread), thread);
            ++i;
        }
    }
}

