/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import generic.jar.ResourceFile;
import ghidra.app.cmd.disassemble.DisassembleCommand;
import ghidra.app.cmd.function.CreateFunctionCmd;
import ghidra.app.cmd.function.CreateThunkFunctionCmd;
import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.app.services.AbstractAnalyzer;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.Application;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataType;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.BookmarkManager;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.ContextChangeException;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.FlowOverride;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramContext;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.util.ContextEvaluator;
import ghidra.program.util.ContextEvaluatorAdapter;
import ghidra.program.util.SymbolicPropogator;
import ghidra.program.util.VarnodeContext;
import ghidra.util.Msg;
import ghidra.util.bytesearch.DittedBitSequence;
import ghidra.util.bytesearch.Match;
import ghidra.util.bytesearch.Pattern;
import ghidra.util.bytesearch.SequenceSearchState;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import org.xml.sax.SAXException;

public class PPC64CallStubAnalyzer
extends AbstractAnalyzer {
    private static final String NAME = "PPC64 ELF Call Stubs";
    private static final String DESCRIPTION = "Detect ELF Call Stubs and create thunk function";
    private static final String PROCESSOR_NAME = "PowerPC";
    private static final String CALL_STUB_PATTERN_FILE = "ppc64-r2CallStubs.xml";
    private static final String UNKNOWN_FUNCTION_NAME = "___UNKNOWN_CALL_STUB___";
    private static boolean patternLoadFailed;
    private static ArrayList<Pattern> beCallStubPatterns;
    private static ArrayList<Pattern> leCallStubPatterns;
    private static int maxPatternLength;
    private Register r2Reg;
    private Register ctrReg;

    public PPC64CallStubAnalyzer() {
        super(NAME, DESCRIPTION, AnalyzerType.FUNCTION_ANALYZER);
        this.setDefaultEnablement(true);
        this.setPriority(AnalysisPriority.FUNCTION_ANALYSIS.before());
    }

    public boolean canAnalyze(Program program) {
        Language language = program.getLanguage();
        if (PROCESSOR_NAME.equals(language.getProcessor().toString()) && language.getLanguageDescription().getSize() == 64 && PPC64CallStubAnalyzer.patternsLoaded(language.isBigEndian())) {
            this.r2Reg = program.getRegister("r2");
            this.ctrReg = program.getRegister("CTR");
            return this.r2Reg != null && this.ctrReg != null;
        }
        return false;
    }

    private static synchronized boolean patternsLoaded(boolean bigEndian) {
        if (patternLoadFailed) {
            return false;
        }
        if (!bigEndian) {
            if (leCallStubPatterns != null) {
                return true;
            }
            if (!PPC64CallStubAnalyzer.patternsLoaded(true)) {
                return false;
            }
            leCallStubPatterns = PPC64CallStubAnalyzer.flipPatterns(beCallStubPatterns);
            return true;
        }
        try {
            ResourceFile patternFile = Application.getModuleDataFile((String)CALL_STUB_PATTERN_FILE);
            beCallStubPatterns = new ArrayList();
            Pattern.readPatterns((ResourceFile)patternFile, beCallStubPatterns, null);
            maxPatternLength = 0;
            for (Pattern pattern : beCallStubPatterns) {
                int len = pattern.getSize();
                if (len % 4 != 0) {
                    throw new SAXException("pattern must contain multiple of 4-bytes");
                }
                if (len <= maxPatternLength) continue;
                maxPatternLength = len;
            }
        }
        catch (FileNotFoundException e) {
            Msg.error(PPC64CallStubAnalyzer.class, (Object)"PowerPC resource file not found: ppc64-r2CallStubs.xml");
            patternLoadFailed = true;
            return false;
        }
        catch (IOException | SAXException e) {
            Msg.error(PPC64CallStubAnalyzer.class, (Object)"Failed to parse byte pattern file: ppc64-r2CallStubs.xml", (Throwable)e);
            patternLoadFailed = true;
            return false;
        }
        return true;
    }

    private static ArrayList<Pattern> flipPatterns(ArrayList<Pattern> patternlist) {
        ArrayList<Pattern> list = new ArrayList<Pattern>();
        for (Pattern pat : patternlist) {
            byte[] bytes = PPC64CallStubAnalyzer.flipPatternBytes(pat.getValueBytes());
            byte[] mask = PPC64CallStubAnalyzer.flipPatternBytes(pat.getMaskBytes());
            Pattern newPattern = new Pattern(new DittedBitSequence(bytes, mask), pat.getMarkOffset(), pat.getPostRules(), pat.getMatchActions());
            list.add(newPattern);
        }
        return list;
    }

    private static byte[] flipPatternBytes(byte[] bytes) {
        for (int i = 0; i < bytes.length; i += 4) {
            byte b = bytes[i];
            bytes[i] = bytes[i + 3];
            bytes[i + 3] = b;
            b = bytes[i + 1];
            bytes[i + 1] = bytes[i + 2];
            bytes[i + 2] = b;
        }
        return bytes;
    }

    public boolean added(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws CancelledException {
        Memory memory = program.getMemory();
        Listing listing = program.getListing();
        ProgramContext programContext = program.getProgramContext();
        SequenceSearchState sequenceSearchState = SequenceSearchState.buildStateMachine(program.getMemory().isBigEndian() ? beCallStubPatterns : leCallStubPatterns);
        monitor.setIndeterminate(false);
        monitor.setMaximum(set.getNumAddresses());
        monitor.setProgress(0L);
        int functionCount = 0;
        for (Function function : listing.getFunctions(set, true)) {
            monitor.checkCancelled();
            monitor.setProgress((long)functionCount++);
            Address entryAddr = function.getEntryPoint();
            boolean isThunk = function.isThunk();
            Match stubMatch = null;
            if (isThunk ? !this.thunksUnknownFunction(function) : (stubMatch = this.matchKnownCallStubs(entryAddr, memory, sequenceSearchState)) == null) continue;
            RegisterValue r2Value = programContext.getRegisterValue(this.r2Reg, entryAddr);
            if (r2Value == null || !r2Value.hasValue()) {
                if (isThunk) continue;
                this.createThunk(program, entryAddr, stubMatch.getSequenceSize(), this.getUnknownFunction(program).getEntryPoint());
                continue;
            }
            int stubLength = stubMatch != null ? stubMatch.getSequenceSize() : (int)function.getBody().getNumAddresses();
            this.analyzeCallStub(program, function, stubLength, monitor);
        }
        return true;
    }

    private Match matchKnownCallStubs(Address addr, Memory memory, SequenceSearchState sequenceSearchState) {
        byte[] bytes = new byte[maxPatternLength];
        ArrayList matches = new ArrayList();
        int cnt = 0;
        try {
            cnt = memory.getBytes(addr, bytes);
        }
        catch (MemoryAccessException memoryAccessException) {
            // empty catch block
        }
        if (cnt == 0) {
            return null;
        }
        byte[] searchBytes = bytes;
        if (cnt != bytes.length) {
            searchBytes = new byte[cnt];
            System.arraycopy(bytes, 0, searchBytes, 0, cnt);
        }
        matches.clear();
        sequenceSearchState.apply(searchBytes, matches);
        if (matches.size() == 0) {
            return null;
        }
        return (Match)matches.get(0);
    }

    private void createThunk(Program program, Address stubAddr, int stubLength, Address thunkedFunctionAddr) {
        AddressSet stubBody = new AddressSet(stubAddr, stubAddr.add((long)(stubLength - 1)));
        CreateThunkFunctionCmd cmd = new CreateThunkFunctionCmd(stubAddr, (AddressSetView)stubBody, thunkedFunctionAddr);
        cmd.applyTo((DomainObject)program);
    }

    private void analyzeCallStub(final Program program, final Function stubFunction, final int stubLength, final TaskMonitor monitor) throws CancelledException {
        SymbolicPropogator symEval = new SymbolicPropogator(program);
        symEval.setParamRefCheck(false);
        symEval.setReturnRefCheck(false);
        symEval.setStoredRefCheck(false);
        final Address entryAddr = stubFunction.getEntryPoint();
        AddressSet stubBody = new AddressSet(entryAddr, entryAddr.add((long)(stubLength - 1)));
        ContextEvaluatorAdapter eval = new ContextEvaluatorAdapter(){

            public boolean followFalseConditionalBranches() {
                return false;
            }

            public boolean evaluateReference(VarnodeContext context, Instruction instr, int pcodeop, Address address, int size, DataType dataType, RefType refType) {
                return true;
            }

            public boolean evaluateDestination(VarnodeContext context, Instruction instruction) {
                Address destAddr;
                Function destFunction;
                if (!"bctr".equals(instruction.getMnemonicString())) {
                    return true;
                }
                instruction.setFlowOverride(FlowOverride.CALL_RETURN);
                RegisterValue ctrValue = context.getRegisterValue(PPC64CallStubAnalyzer.this.ctrReg);
                if (ctrValue != null && ctrValue.hasValue() && (destFunction = PPC64CallStubAnalyzer.this.createDestinationFunction(program, destAddr = entryAddr.getNewAddress(ctrValue.getUnsignedValue().longValue()), instruction.getAddress(), context.getRegisterValue(PPC64CallStubAnalyzer.this.r2Reg), monitor)) != null) {
                    if (!stubFunction.isThunk()) {
                        PPC64CallStubAnalyzer.this.createThunk(program, entryAddr, stubLength, destFunction.getEntryPoint());
                    } else {
                        stubFunction.setThunkedFunction(destFunction);
                    }
                }
                return true;
            }

            public boolean allowAccess(VarnodeContext context, Address address) {
                return true;
            }
        };
        symEval.flowConstants(entryAddr, (AddressSetView)stubBody, (ContextEvaluator)eval, false, monitor);
    }

    private Function getUnknownFunction(Program program) {
        try {
            return program.getExternalManager().addExtFunction("<EXTERNAL>", UNKNOWN_FUNCTION_NAME, null, SourceType.IMPORTED).getFunction();
        }
        catch (DuplicateNameException | InvalidInputException e) {
            throw new AssertException("unexpected", e);
        }
    }

    private boolean thunksUnknownFunction(Function function) {
        Function thunkedFunction = function.getThunkedFunction(false);
        if (thunkedFunction == null || !thunkedFunction.isExternal()) {
            return false;
        }
        return UNKNOWN_FUNCTION_NAME.equals(thunkedFunction.getName());
    }

    private Function createDestinationFunction(Program program, Address addr, Address flowFromAddr, RegisterValue regValue, TaskMonitor monitor) {
        CreateFunctionCmd cmd;
        ProgramContext programContext;
        RegisterValue oldValue;
        Listing listing = program.getListing();
        BookmarkManager bookmarkMgr = program.getBookmarkManager();
        if (!program.getMemory().contains(addr)) {
            bookmarkMgr.setBookmark(flowFromAddr, "Error", "Bad Reference", "No memory for call stub destination at " + addr);
            return null;
        }
        Function function = listing.getFunctionAt(addr);
        if (regValue != null && regValue.hasValue() && ((oldValue = (programContext = program.getProgramContext()).getRegisterValue(regValue.getRegister(), addr)) == null || !oldValue.hasValue())) {
            try {
                programContext.setRegisterValue(addr, addr, regValue);
            }
            catch (ContextChangeException e) {
                throw new AssertException((Throwable)e);
            }
            if (function != null) {
                AutoAnalysisManager.getAnalysisManager((Program)program).functionDefined(addr);
            }
        }
        if (function != null) {
            return function;
        }
        CodeUnit cu = listing.getCodeUnitContaining(addr);
        if (cu == null) {
            throw new AssertException("expected code unit in memory");
        }
        if (!addr.equals((Object)cu.getMinAddress())) {
            bookmarkMgr.setBookmark(cu.getMinAddress(), "Error", "Code Unit Conflict", "Expected function entry at " + addr + " referenced by call stub from " + flowFromAddr);
            return null;
        }
        if (cu instanceof Data) {
            Data d = (Data)cu;
            if (d.isDefined()) {
                bookmarkMgr.setBookmark(addr, "Error", "Code Unit Conflict", "Expected function entry referenced by call stub from " + flowFromAddr);
                return null;
            }
            DisassembleCommand cmd2 = new DisassembleCommand(addr, null, true);
            if (!cmd2.applyTo((DomainObject)program, monitor)) {
                return null;
            }
        }
        if ((cmd = new CreateFunctionCmd(addr)).applyTo((DomainObject)program, monitor)) {
            return cmd.getFunction();
        }
        return null;
    }
}

