/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf.relocation;

import com.google.common.base.Predicate;
import ghidra.app.util.bin.format.elf.ElfDynamicTable;
import ghidra.app.util.bin.format.elf.ElfHeader;
import ghidra.app.util.bin.format.elf.ElfLoadHelper;
import ghidra.app.util.bin.format.elf.ElfRelocation;
import ghidra.app.util.bin.format.elf.ElfSymbol;
import ghidra.app.util.bin.format.elf.extend.PowerPC_ElfExtension;
import ghidra.app.util.bin.format.elf.relocation.ElfRelocationContext;
import ghidra.app.util.bin.format.elf.relocation.ElfRelocationHandler;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.ContextChangeException;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.reloc.Relocation;
import ghidra.program.model.reloc.RelocationResult;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.exception.NotFoundException;
import java.math.BigInteger;
import java.util.Map;

public class PowerPC_ElfRelocationHandler
extends ElfRelocationHandler {
    public boolean canRelocate(ElfHeader elf) {
        return elf.e_machine() == 20 && elf.is32Bit();
    }

    public PowerPC_ElfRelocationContext createRelocationContext(ElfLoadHelper loadHelper, Map<ElfSymbol, Address> symbolMap) {
        return new PowerPC_ElfRelocationContext(this, loadHelper, symbolMap);
    }

    public RelocationResult relocate(ElfRelocationContext elfRelocationContext, ElfRelocation relocation, Address relocationAddress) throws MemoryAccessException, NotFoundException {
        PowerPC_ElfRelocationContext ppcRelocationContext = (PowerPC_ElfRelocationContext)elfRelocationContext;
        ElfHeader elf = ppcRelocationContext.getElfHeader();
        if (elf.e_machine() != 20 || !elf.is32Bit()) {
            return RelocationResult.FAILURE;
        }
        Program program = ppcRelocationContext.getProgram();
        Memory memory = program.getMemory();
        int type = relocation.getType();
        if (type == 0) {
            return RelocationResult.SKIPPED;
        }
        int symbolIndex = relocation.getSymbolIndex();
        Language language = ppcRelocationContext.getProgram().getLanguage();
        if (!"PowerPC".equals(language.getProcessor().toString()) || language.getLanguageDescription().getSize() != 32) {
            PowerPC_ElfRelocationHandler.markAsError((Program)program, (Address)relocationAddress, (String)Long.toString(type), null, (String)"Unsupported language for 32-bit PowerPC relocation", (MessageLog)ppcRelocationContext.getLog());
        }
        int addend = (int)relocation.getAddend();
        int offset = (int)relocationAddress.getOffset();
        ElfSymbol sym = elfRelocationContext.getSymbol(symbolIndex);
        Address symbolAddr = elfRelocationContext.getSymbolAddress(sym);
        int symbolValue = (int)elfRelocationContext.getSymbolValue(sym);
        String symbolName = elfRelocationContext.getSymbolName(symbolIndex);
        long relocbase = elfRelocationContext.getImageBaseWordAdjustmentOffset();
        int oldValue = memory.getInt(relocationAddress);
        int newValue = 0;
        int byteLength = 4;
        switch (type) {
            case 19: {
                PowerPC_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_PPC_COPY", (String)symbolName, (long)symbolIndex, (String)"Runtime copy not supported", (MessageLog)elfRelocationContext.getLog());
                return RelocationResult.SKIPPED;
            }
            case 1: 
            case 20: 
            case 24: {
                newValue = symbolValue + addend;
                memory.setInt(relocationAddress, newValue);
                if (symbolIndex == 0 || addend == 0 || sym.isSection()) break;
                PowerPC_ElfRelocationHandler.warnExternalOffsetRelocation((Program)program, (Address)relocationAddress, (Address)symbolAddr, (String)symbolName, (long)addend, (MessageLog)elfRelocationContext.getLog());
                PowerPC_ElfRelocationHandler.applyComponentOffsetPointer((Program)program, (Address)relocationAddress, (long)addend);
                break;
            }
            case 2: {
                newValue = symbolValue + addend >> 2;
                newValue = oldValue & 0xFC000003 | newValue << 2;
                memory.setInt(relocationAddress, newValue);
                break;
            }
            case 3: 
            case 25: {
                newValue = symbolValue + addend;
                memory.setShort(relocationAddress, (short)newValue);
                byteLength = 2;
                break;
            }
            case 4: {
                if (Long.compareUnsigned(symbolValue, relocbase) > 0 && Long.compareUnsigned(symbolValue, relocbase + (long)addend) <= 0) {
                    symbolValue = (int)relocbase;
                }
                newValue = symbolValue + addend;
                memory.setShort(relocationAddress, (short)newValue);
                byteLength = 2;
                break;
            }
            case 5: {
                newValue = symbolValue + addend >> 16;
                memory.setShort(relocationAddress, (short)newValue);
                byteLength = 2;
                break;
            }
            case 6: {
                if (Long.compareUnsigned(symbolValue, relocbase) > 0 && Long.compareUnsigned(symbolValue, relocbase + (long)addend) <= 0) {
                    symbolValue = (int)relocbase;
                }
                newValue = (newValue >> 16) + (((newValue = symbolValue + addend) & 0x8000) != 0 ? 1 : 0);
                memory.setShort(relocationAddress, (short)newValue);
                byteLength = 2;
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                newValue = symbolValue + addend >> 2;
                newValue = oldValue & 0xFFDF0003 | newValue << 2 & 0x3FFFFFC;
                memory.setInt(relocationAddress, newValue);
                break;
            }
            case 10: {
                newValue = symbolValue + addend - offset >> 2;
                newValue = newValue << 2 & 0x3FFFFFC;
                newValue = oldValue & 0xFC000003 | newValue;
                memory.setInt(relocationAddress, newValue);
                break;
            }
            case 22: {
                newValue = (int)ppcRelocationContext.getImageBaseWordAdjustmentOffset() + addend;
                memory.setInt(relocationAddress, newValue);
                break;
            }
            case 26: {
                newValue = symbolValue + addend - offset;
                memory.setInt(relocationAddress, newValue);
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                newValue = symbolValue + addend - offset >> 2;
                newValue = oldValue & 0xFFDF0003 | newValue << 2 & 0x20FFFC;
                memory.setInt(relocationAddress, newValue);
                break;
            }
            case 21: {
                int value = symbolValue + addend;
                ElfDynamicTable dynamicTable = elf.getDynamicTable();
                if (dynamicTable != null && dynamicTable.containsDynamicValue(PowerPC_ElfExtension.DT_PPC_GOT)) {
                    memory.setInt(relocationAddress, value);
                    break;
                }
                int displacement = value - offset;
                if (displacement << 6 >> 6 == displacement) {
                    newValue = 0x48000000 | displacement & 0x3FFFFFC;
                    memory.setInt(relocationAddress, newValue);
                    break;
                }
                if (value > 0 && value <= 0x1FFFFFC || value < 0 && value >= -33554432) {
                    newValue = 0x48000002 | value & 0x3FFFFFC;
                    memory.setInt(relocationAddress, newValue);
                    break;
                }
                PowerPC_ElfRelocationHandler.markAsUnhandled((Program)program, (Address)relocationAddress, (long)type, (long)symbolIndex, (String)symbolName, (MessageLog)ppcRelocationContext.getLog());
                return RelocationResult.FAILURE;
            }
            case 109: {
                long alignedRelocOffset = relocationAddress.getOffset() & 0xFFFFFFFFFFFFFFFCL;
                relocationAddress = relocationAddress.getNewAddress(alignedRelocOffset);
                oldValue = memory.getInt(relocationAddress);
                Address symAddr = ppcRelocationContext.getSymbolAddress(sym);
                MemoryBlock block = memory.getBlock(symAddr);
                Integer sdaBase = null;
                Integer gprID = null;
                if (block != null) {
                    String blockName = block.getName();
                    if (".sdata".equals(blockName) || ".sbss".equals(blockName)) {
                        sdaBase = ppcRelocationContext.getSDABase();
                        gprID = 13;
                    } else if (".sdata2".equals(blockName) || ".sbss2".equals(blockName)) {
                        sdaBase = ppcRelocationContext.getSDA2Base();
                        gprID = 2;
                    } else if (".PPC.EMB.sdata0".equals(blockName) || ".PPC.EMB.sbss0".equals(blockName)) {
                        sdaBase = 0;
                        gprID = 0;
                    } else if ("EXTERNAL".equals(blockName)) {
                        PowerPC_ElfRelocationHandler.markAsError((Program)program, (Address)relocationAddress, (long)type, (String)symbolName, (String)"Unsupported relocation for external symbol", (MessageLog)ppcRelocationContext.getLog());
                        return RelocationResult.FAILURE;
                    }
                }
                if (gprID == null || sdaBase == null) {
                    PowerPC_ElfRelocationHandler.markAsError((Program)program, (Address)relocationAddress, (long)type, (String)symbolName, (String)"Failed to identfy appropriate data block", (MessageLog)ppcRelocationContext.getLog());
                    return RelocationResult.FAILURE;
                }
                newValue = symbolValue - sdaBase + addend & 0xFFFF;
                newValue |= gprID << 16;
                memory.setInt(relocationAddress, newValue |= oldValue & 0xFFE00000);
                break;
            }
            default: {
                PowerPC_ElfRelocationHandler.markAsUnhandled((Program)program, (Address)relocationAddress, (long)type, (long)symbolIndex, (String)symbolName, (MessageLog)ppcRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
        }
        return new RelocationResult(Relocation.Status.APPLIED, byteLength);
    }

    private static class PowerPC_ElfRelocationContext
    extends ElfRelocationContext {
        private Integer sdaBase;
        private Integer sda2Base;

        protected PowerPC_ElfRelocationContext(ElfRelocationHandler handler, ElfLoadHelper loadHelper, Map<ElfSymbol, Address> symbolMap) {
            super(handler, loadHelper, symbolMap);
        }

        Integer getSDABase() {
            if (this.sdaBase != null) {
                if (this.sdaBase == -1) {
                    return null;
                }
                return this.sdaBase;
            }
            this.sdaBase = this.getBaseOffset("_SDA_BASE_", ".sdata", ".sbss");
            if (this.sdaBase == -1) {
                this.getLog().appendMsg("ERROR: failed to establish _SDA_BASE_");
                return null;
            }
            this.setRegisterContext("r13", BigInteger.valueOf(this.sdaBase.intValue()), (Predicate<MemoryBlock>)((Predicate)b -> b.isExecute()));
            return this.sdaBase;
        }

        Integer getSDA2Base() {
            if (this.sda2Base != null) {
                if (this.sda2Base == -1) {
                    return null;
                }
                return this.sda2Base;
            }
            this.sda2Base = this.getBaseOffset("_SDA2_BASE_", ".sdata2", ".sbss2");
            if (this.sda2Base == -1) {
                this.getLog().appendMsg("ERROR: failed to establish _SDA2_BASE_");
                return null;
            }
            this.setRegisterContext("r2", BigInteger.valueOf(this.sda2Base.intValue()), (Predicate<MemoryBlock>)((Predicate)b -> b.isExecute()));
            return this.sda2Base;
        }

        private void setRegisterContext(String regName, BigInteger value, Predicate<MemoryBlock> blockPredicate) {
            Register reg = this.program.getRegister(regName);
            for (MemoryBlock block : this.program.getMemory().getBlocks()) {
                if (!block.isExecute()) continue;
                try {
                    this.program.getProgramContext().setValue(reg, block.getStart(), block.getEnd(), value);
                }
                catch (ContextChangeException e) {
                    throw new AssertException((Throwable)e);
                }
            }
        }

        private Integer getBaseOffset(String symbolName, String ... blockNames) {
            MessageLog log = this.getLog();
            Symbol baseSymbol = SymbolUtilities.getLabelOrFunctionSymbol((Program)this.program, (String)symbolName, msg -> log.appendMsg(msg));
            if (baseSymbol != null) {
                int baseOffset = (int)baseSymbol.getAddress().getOffset();
                String absString = "";
                if (baseSymbol.isPinned()) {
                    absString = "absolute ";
                }
                log.appendMsg("Using " + absString + symbolName + " of 0x" + Integer.toHexString(baseOffset));
                return baseOffset;
            }
            Memory mem = this.program.getMemory();
            AddressSpace defaultSpace = this.program.getAddressFactory().getDefaultAddressSpace();
            AddressSet blockSet = new AddressSet();
            for (String blockName : blockNames) {
                MemoryBlock block = mem.getBlock(blockName);
                if (block == null) continue;
                if (!block.getStart().getAddressSpace().equals(defaultSpace)) {
                    log.appendMsg("ERROR: " + blockName + " not in default space");
                    return -1;
                }
                blockSet.add(block.getStart(), block.getEnd());
            }
            if (blockSet.isEmpty()) {
                return -1;
            }
            Address baseAddr = blockSet.getMinAddress();
            long range = blockSet.getMaxAddress().subtract(baseAddr) + 1L;
            if (range > 32767L) {
                baseAddr = baseAddr.add(range / 2L & 0xFFFFFFFFFFFFFFF0L);
            }
            try {
                this.program.getSymbolTable().createLabel(baseAddr, symbolName, SourceType.ANALYSIS);
            }
            catch (InvalidInputException e) {
                throw new AssertException((Throwable)e);
            }
            int baseOffset = (int)baseAddr.getOffset();
            log.appendMsg("Defined " + symbolName + " of 0x" + Integer.toHexString(baseOffset));
            return baseOffset;
        }
    }
}

