/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.gadp.impl;

import agent.dbgeng.dbgeng.DebugClient;
import agent.dbgeng.manager.DbgManager;
import com.sun.jna.platform.win32.COM.COMException;
import ghidra.util.Msg;
import java.util.ArrayList;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;

public abstract class AbstractClientThreadExecutor
extends AbstractExecutorService {
    private static final int DEFAULT_PRIORITY = 10;
    protected DebugClient client;
    protected boolean shuttingDown = false;
    protected final Queue<Entry> queue = new PriorityQueue<Entry>();
    protected Thread thread = new Thread(this::run, "DebugClient");
    protected final AtomicBoolean waitRegistered = new AtomicBoolean();

    protected abstract void init();

    public DebugClient getClient() {
        if (this.thread != Thread.currentThread()) {
            // empty if block
        }
        return this.client;
    }

    public void cancelWait() {
        this.waitRegistered.set(false);
    }

    public void registerWait() {
        this.waitRegistered.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Entry pollQueue() {
        Queue<Entry> queue = this.queue;
        synchronized (queue) {
            return this.queue.poll();
        }
    }

    private void run() {
        try {
            this.init();
            while (!this.shuttingDown) {
                Entry next;
                while (null != (next = this.pollQueue())) {
                    if (this.shuttingDown) {
                        return;
                    }
                    try {
                        next.command.run();
                    }
                    catch (Throwable t) {
                        Msg.error((Object)this, (Object)("Task in executor threw: " + t));
                    }
                }
                DebugClient.DebugStatus status = this.client.getControl().getExecutionStatus();
                if (status.shouldWait && status != DebugClient.DebugStatus.NO_DEBUGGEE || this.waitRegistered.get()) {
                    this.waitRegistered.set(false);
                    try {
                        this.getManager().waitForEventEx();
                    }
                    catch (COMException e) {
                        Msg.error((Object)this, (Object)("Error during WaitForEvents: " + e));
                    }
                    continue;
                }
                try {
                    this.client.dispatchCallbacks(100);
                }
                catch (COMException e) {
                    Msg.error((Object)this, (Object)("Error during DispatchCallbacks: " + e));
                }
            }
        }
        catch (Throwable t) {
            Msg.error((Object)this, (Object)"Non-respawnable executor terminated unexpectedly", (Throwable)t);
            this.shuttingDown = true;
        }
    }

    @Override
    public void shutdown() {
        this.shuttingDown = true;
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.shuttingDown = true;
        this.client.exitDispatch();
        this.thread.interrupt();
        ArrayList<Runnable> left = new ArrayList<Runnable>(this.queue.size());
        for (Entry ent : this.queue) {
            left.add(ent.command);
        }
        return left;
    }

    @Override
    public boolean isShutdown() {
        return this.shuttingDown;
    }

    @Override
    public boolean isTerminated() {
        return !this.thread.isAlive();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        long millis = TimeUnit.MILLISECONDS.convert(timeout, unit);
        this.thread.join(millis);
        return !this.thread.isAlive();
    }

    @Override
    public void execute(Runnable command) {
        this.execute(10, command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(int priority, Runnable command) {
        if (this.shuttingDown) {
            throw new RejectedExecutionException("Executor is shutting down");
        }
        if (!this.thread.isAlive()) {
            throw new RejectedExecutionException("Executor has terminated");
        }
        Queue<Entry> queue = this.queue;
        synchronized (queue) {
            this.queue.add(new Entry(priority, command));
        }
    }

    public boolean isCurrentThread() {
        return this.thread.equals(Thread.currentThread());
    }

    public void execute(int priority, Consumer<DebugClient> command) {
        this.execute(priority, () -> command.accept(this.client));
    }

    public abstract DbgManager getManager();

    public abstract void setManager(DbgManager var1);

    public static class Entry
    implements Comparable<Entry> {
        final int priority;
        public final Runnable command;

        public Entry(int priority, Runnable command) {
            this.priority = priority;
            this.command = command;
        }

        @Override
        public int compareTo(Entry that) {
            return Integer.compare(this.priority, that.priority);
        }
    }
}

