/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.impl.dbgeng.sysobj;

import agent.dbgeng.dbgeng.COMUtilsExtra;
import agent.dbgeng.dbgeng.DebugSessionId;
import agent.dbgeng.dbgeng.DebugSessionRecord;
import agent.dbgeng.impl.dbgeng.sysobj.DebugSystemObjectsImpl2;
import agent.dbgeng.jna.dbgeng.sysobj.IDebugSystemObjects3;
import com.sun.jna.platform.win32.COM.COMUtils;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DebugSystemObjectsImpl3
extends DebugSystemObjectsImpl2 {
    private final IDebugSystemObjects3 jnaSysobj;

    public DebugSystemObjectsImpl3(IDebugSystemObjects3 jnaSysobj) {
        super(jnaSysobj);
        this.jnaSysobj = jnaSysobj;
    }

    @Override
    public DebugSessionId getEventSystem() {
        WinDef.ULONGByReference pulId = new WinDef.ULONGByReference();
        WinNT.HRESULT hr = this.jnaSysobj.GetEventSystem(pulId);
        if (hr.equals((Object)COMUtilsExtra.E_UNEXPECTED)) {
            return new DebugSessionRecord(-1L);
        }
        COMUtils.checkRC((WinNT.HRESULT)hr);
        return new DebugSessionRecord(pulId.getValue().intValue());
    }

    @Override
    public DebugSessionId getCurrentSystemId() {
        WinDef.ULONGByReference pulId = new WinDef.ULONGByReference();
        WinNT.HRESULT hr = this.jnaSysobj.GetCurrentSystemId(pulId);
        if (hr.equals((Object)COMUtilsExtra.E_UNEXPECTED)) {
            return new DebugSessionRecord(-1L);
        }
        COMUtils.checkRC((WinNT.HRESULT)hr);
        return new DebugSessionRecord(pulId.getValue().intValue());
    }

    @Override
    public void setCurrentSystemId(DebugSessionId id) {
        WinNT.HRESULT hr = this.jnaSysobj.SetCurrentSystemId(new WinDef.ULONG(id.value()));
        if (!hr.equals((Object)COMUtilsExtra.E_UNEXPECTED)) {
            COMUtils.checkRC((WinNT.HRESULT)hr);
        }
    }

    @Override
    public int getNumberSystems() {
        WinDef.ULONGByReference pulNumber = new WinDef.ULONGByReference();
        WinNT.HRESULT hr = this.jnaSysobj.GetNumberSystems(pulNumber);
        if (hr.equals((Object)COMUtilsExtra.E_UNEXPECTED)) {
            return -1;
        }
        COMUtils.checkRC((WinNT.HRESULT)hr);
        return pulNumber.getValue().intValue();
    }

    @Override
    public List<DebugSessionId> getSystems(int start, int count) {
        if (count == 0) {
            return Collections.emptyList();
        }
        WinDef.ULONG ulStart = new WinDef.ULONG((long)start);
        WinDef.ULONG ulCount = new WinDef.ULONG((long)count);
        WinDef.ULONG[] aulIds = new WinDef.ULONG[count];
        COMUtils.checkRC((WinNT.HRESULT)this.jnaSysobj.GetSystemIdsByIndex(ulStart, ulCount, aulIds, null));
        ArrayList<DebugSessionId> result = new ArrayList<DebugSessionId>(count);
        for (int i = 0; i < count; ++i) {
            result.add(new DebugSessionRecord(aulIds[i].intValue()));
        }
        return result;
    }
}

