/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.jna.dbgeng;

import agent.dbgeng.dbgeng.DebugValue;
import com.sun.jna.Native;
import com.sun.jna.Structure;
import com.sun.jna.Union;
import com.sun.jna.WString;
import com.sun.jna.platform.win32.Guid;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.PointerByReference;
import com.sun.jna.win32.StdCallLibrary;
import java.util.List;

public interface DbgEngNative
extends StdCallLibrary {
    public static final DbgEngNative INSTANCE = (DbgEngNative)Native.load((String)"dbgeng.dll", DbgEngNative.class);

    public WinNT.HRESULT DebugConnect(String var1, Guid.REFIID var2, PointerByReference var3);

    public WinNT.HRESULT DebugConnectWide(WString var1, Guid.REFIID var2, PointerByReference var3);

    public WinNT.HRESULT DebugCreate(Guid.REFIID var1, PointerByReference var2);

    public WinNT.HRESULT DebugCreateEx(Guid.REFIID var1, WinDef.DWORD var2, PointerByReference var3);

    public static class DEBUG_CREATE_PROCESS_OPTIONS
    extends Structure {
        public static final List<String> FIELDS = DEBUG_CREATE_PROCESS_OPTIONS.createFieldsOrder((String[])new String[]{"CreateFlags", "EngCreateFlags", "VerifierFlags", "Reserved"});
        public WinDef.ULONG CreateFlags;
        public WinDef.ULONG EngCreateFlags;
        public WinDef.ULONG VerifierFlags;
        public WinDef.ULONG Reserved;

        protected List<String> getFieldOrder() {
            return FIELDS;
        }

        public static class ByReference
        extends DEBUG_CREATE_PROCESS_OPTIONS
        implements Structure.ByReference {
        }
    }

    public static class DEBUG_EXCEPTION_FILTER_PARAMETERS
    extends Structure {
        public static final List<String> FIELDS = DEBUG_EXCEPTION_FILTER_PARAMETERS.createFieldsOrder((String[])new String[]{"ExecutionOption", "ContinueOption", "TextSize", "CommandSize", "SecondCommandSize", "ExceptionCode"});
        public WinDef.ULONG ExecutionOption;
        public WinDef.ULONG ContinueOption;
        public WinDef.ULONG TextSize;
        public WinDef.ULONG CommandSize;
        public WinDef.ULONG SecondCommandSize;
        public WinDef.ULONG ExceptionCode;

        protected List<String> getFieldOrder() {
            return FIELDS;
        }

        public static class ByReference
        extends DEBUG_EXCEPTION_FILTER_PARAMETERS
        implements Structure.ByReference {
        }
    }

    public static class DEBUG_SPECIFIC_FILTER_PARAMETERS
    extends Structure {
        public static final List<String> FIELDS = DEBUG_SPECIFIC_FILTER_PARAMETERS.createFieldsOrder((String[])new String[]{"ExecutionOption", "ContinueOption", "TextSize", "CommandSize", "ArgumentSize"});
        public WinDef.ULONG ExecutionOption;
        public WinDef.ULONG ContinueOption;
        public WinDef.ULONG TextSize;
        public WinDef.ULONG CommandSize;
        public WinDef.ULONG ArgumentSize;

        protected List<String> getFieldOrder() {
            return FIELDS;
        }

        public static class ByReference
        extends DEBUG_SPECIFIC_FILTER_PARAMETERS
        implements Structure.ByReference {
        }
    }

    public static class DEBUG_STACK_FRAME
    extends Structure {
        public static final List<String> FIELDS = DEBUG_STACK_FRAME.createFieldsOrder((String[])new String[]{"InstructionOffset", "ReturnOffset", "FrameOffset", "StackOffset", "FuncTableEntry", "Params", "Reserved", "Virtual", "FrameNumber"});
        public WinDef.ULONGLONG InstructionOffset;
        public WinDef.ULONGLONG ReturnOffset;
        public WinDef.ULONGLONG FrameOffset;
        public WinDef.ULONGLONG StackOffset;
        public WinDef.ULONGLONG FuncTableEntry;
        public WinDef.ULONGLONG[] Params = new WinDef.ULONGLONG[4];
        public WinDef.ULONGLONG[] Reserved = new WinDef.ULONGLONG[6];
        public WinDef.BOOL Virtual;
        public WinDef.ULONG FrameNumber;

        protected List<String> getFieldOrder() {
            return FIELDS;
        }

        public static class ByReference
        extends DEBUG_STACK_FRAME
        implements Structure.ByReference {
        }
    }

    public static class DEBUG_THREAD_BASIC_INFORMATION
    extends Structure {
        public static final List<String> FIELDS = DEBUG_THREAD_BASIC_INFORMATION.createFieldsOrder((String[])new String[]{"Valid", "ExitStatus", "PriorityClass", "Priority", "CreateTime", "ExitTime", "KernelTime", "UserTime", "StartOffset", "Affinity"});
        public WinDef.ULONG Valid;
        public WinDef.ULONG ExitStatus;
        public WinDef.ULONG PriorityClass;
        public WinDef.ULONG Priority;
        public WinDef.ULONGLONG CreateTime;
        public WinDef.ULONGLONG ExitTime;
        public WinDef.ULONGLONG KernelTime;
        public WinDef.ULONGLONG UserTime;
        public WinDef.ULONGLONG StartOffset;
        public WinDef.ULONGLONG Affinity;

        protected List<String> getFieldOrder() {
            return FIELDS;
        }

        public static class ByReference
        extends DEBUG_THREAD_BASIC_INFORMATION
        implements Structure.ByReference {
        }
    }

    public static class DEBUG_SYMBOL_ENTRY
    extends Structure {
        public static final List<String> FIELDS = DEBUG_SYMBOL_ENTRY.createFieldsOrder((String[])new String[]{"ModuleBase", "Offset", "Id", "Arg64", "Size", "Flags", "TypeId", "NameSize", "Token", "Tag", "Arg32", "Reserved"});
        public WinDef.ULONGLONG ModuleBase;
        public WinDef.ULONGLONG Offset;
        public WinDef.ULONGLONG Id;
        public WinDef.ULONGLONG Arg64;
        public WinDef.ULONG Size;
        public WinDef.ULONG Flags;
        public WinDef.ULONG TypeId;
        public WinDef.ULONG NameSize;
        public WinDef.ULONG Token;
        public WinDef.ULONG Tag;
        public WinDef.ULONG Arg32;
        public WinDef.ULONG Reserved;

        protected List<String> getFieldOrder() {
            return FIELDS;
        }

        public static class ByReference
        extends DEBUG_SYMBOL_ENTRY
        implements Structure.ByReference {
        }
    }

    public static class DEBUG_MODULE_PARAMETERS
    extends Structure {
        public static final List<String> FIELDS = DEBUG_MODULE_PARAMETERS.createFieldsOrder((String[])new String[]{"Base", "Size", "TimeDateStamp", "Checksum", "Flags", "SymbolType", "ImageNameSize", "ModuleNameSize", "LoadedImageNameSize", "SymbolFileNameSize", "MappedImageNameSize", "Reserved0", "Reserved1"});
        public WinDef.ULONGLONG Base;
        public WinDef.ULONG Size;
        public WinDef.ULONG TimeDateStamp;
        public WinDef.ULONG Checksum;
        public WinDef.ULONG Flags;
        public WinDef.ULONG SymbolType;
        public WinDef.ULONG ImageNameSize;
        public WinDef.ULONG ModuleNameSize;
        public WinDef.ULONG LoadedImageNameSize;
        public WinDef.ULONG SymbolFileNameSize;
        public WinDef.ULONG MappedImageNameSize;
        public WinDef.ULONGLONG Reserved0;
        public WinDef.ULONGLONG Reserved1;

        protected List<String> getFieldOrder() {
            return FIELDS;
        }

        public static class ByReference
        extends DEBUG_MODULE_PARAMETERS
        implements Structure.ByReference {
        }
    }

    public static class DEBUG_MODULE_AND_ID
    extends Structure {
        public static final List<String> FIELDS = DEBUG_MODULE_AND_ID.createFieldsOrder((String[])new String[]{"ModuleBase", "Id"});
        public WinDef.ULONGLONG ModuleBase;
        public WinDef.ULONGLONG Id;

        protected List<String> getFieldOrder() {
            return FIELDS;
        }

        public static class ByReference
        extends DEBUG_MODULE_AND_ID
        implements Structure.ByReference {
        }
    }

    public static class DEBUG_VALUE
    extends Structure {
        public static final List<String> FIELDS = DEBUG_VALUE.createFieldsOrder((String[])new String[]{"u", "TailOfRawBytes", "Type"});
        public UNION u;
        public WinDef.ULONG TailOfRawBytes;
        public WinDef.ULONG Type;

        protected List<String> getFieldOrder() {
            return FIELDS;
        }

        protected void doUSetType() {
            switch (DebugValue.DebugValueType.values()[this.Type.intValue()]) {
                case INVALID: {
                    this.u.setType("RawBytes");
                    break;
                }
                case INT8: {
                    this.u.setType("I8");
                    break;
                }
                case INT16: {
                    this.u.setType("I16");
                    break;
                }
                case INT32: {
                    this.u.setType("I32");
                    break;
                }
                case INT64: {
                    this.u.setType("I64");
                    break;
                }
                case FLOAT32: {
                    this.u.setType("F32");
                    break;
                }
                case FLOAT64: {
                    this.u.setType("F64");
                    break;
                }
                case FLOAT80: {
                    this.u.setType("F80Bytes");
                    break;
                }
                case FLOAT82: {
                    this.u.setType("F82Bytes");
                    break;
                }
                case FLOAT128: {
                    this.u.setType("F128Bytes");
                    break;
                }
                case VECTOR64: {
                    this.u.setType("VI8");
                    break;
                }
                case VECTOR128: {
                    this.u.setType("VI8");
                }
            }
        }

        public void read() {
            super.read();
            this.doUSetType();
            this.u.read();
        }

        public void write() {
            super.write();
            this.doUSetType();
            this.u.write();
        }

        public <T extends DebugValue> T convertTo(Class<T> desiredType) {
            if (desiredType != null && desiredType != DebugValue.class && DebugValue.DebugValueType.getDebugValueTypeForClass(desiredType).ordinal() != this.Type.intValue()) {
                throw new ClassCastException("debug value is not of the desired type");
            }
            switch (DebugValue.DebugValueType.values()[this.Type.intValue()]) {
                case INVALID: {
                    return null;
                }
                case INT8: {
                    return (T)new DebugValue.DebugInt8Value(this.u.I8.byteValue());
                }
                case INT16: {
                    return (T)new DebugValue.DebugInt16Value(this.u.I16.shortValue());
                }
                case INT32: {
                    return (T)new DebugValue.DebugInt32Value(this.u.I32.intValue());
                }
                case INT64: {
                    return (T)new DebugValue.DebugInt64Value(this.u.I64.I64.longValue());
                }
                case FLOAT32: {
                    return (T)new DebugValue.DebugFloat32Value(this.u.F32);
                }
                case FLOAT64: {
                    return (T)new DebugValue.DebugFloat64Value(this.u.F64);
                }
                case FLOAT80: {
                    return (T)new DebugValue.DebugFloat80Value(this.u.F80Bytes);
                }
                case FLOAT82: {
                    return (T)new DebugValue.DebugFloat82Value(this.u.F82Bytes);
                }
                case FLOAT128: {
                    return (T)new DebugValue.DebugFloat128Value(this.u.F128Bytes);
                }
                case VECTOR64: {
                    return (T)new DebugValue.DebugVector128Value(this.u.VI8);
                }
                case VECTOR128: {
                    return (T)new DebugValue.DebugVector128Value(this.u.VI8);
                }
            }
            throw new AssertionError((Object)"INTERNAL: Shouldn't be here");
        }

        public static DEBUG_VALUE fromDebugValue(DebugValue value) {
            DEBUG_VALUE result = new DEBUG_VALUE();
            DEBUG_VALUE.fromDebugValue(result, value);
            return result;
        }

        public static void fromDebugValue(DEBUG_VALUE into, DebugValue value) {
            DebugValue.DebugValueType type = DebugValue.DebugValueType.getDebugValueTypeForClass(value.getClass());
            into.Type = new WinDef.ULONG((long)type.ordinal());
            switch (type) {
                case INVALID: {
                    break;
                }
                case INT8: {
                    DebugValue.DebugInt8Value int8 = (DebugValue.DebugInt8Value)value;
                    into.u.I8 = new WinDef.UCHAR((long)int8.byteValue());
                    break;
                }
                case INT16: {
                    DebugValue.DebugInt16Value int16 = (DebugValue.DebugInt16Value)value;
                    into.u.I16 = new WinDef.USHORT((long)int16.shortValue());
                    break;
                }
                case INT32: {
                    DebugValue.DebugInt32Value int32 = (DebugValue.DebugInt32Value)value;
                    into.u.I32 = new WinDef.ULONG((long)int32.intValue());
                    break;
                }
                case INT64: {
                    DebugValue.DebugInt64Value int64 = (DebugValue.DebugInt64Value)value;
                    into.u.I64.I64 = new WinDef.ULONGLONG(int64.longValue());
                    break;
                }
                case FLOAT32: {
                    DebugValue.DebugFloat32Value float32 = (DebugValue.DebugFloat32Value)value;
                    into.u.F32 = float32.floatValue();
                    break;
                }
                case FLOAT64: {
                    DebugValue.DebugFloat64Value float64 = (DebugValue.DebugFloat64Value)value;
                    into.u.F64 = float64.doubleValue();
                    break;
                }
                case FLOAT80: {
                    DebugValue.DebugFloat80Value float80 = (DebugValue.DebugFloat80Value)value;
                    into.u.F80Bytes = float80.bytes();
                    break;
                }
                case FLOAT82: {
                    DebugValue.DebugFloat82Value float82 = (DebugValue.DebugFloat82Value)value;
                    into.u.F82Bytes = float82.bytes();
                    break;
                }
                case FLOAT128: {
                    DebugValue.DebugFloat128Value float128 = (DebugValue.DebugFloat128Value)value;
                    into.u.F128Bytes = float128.bytes();
                    break;
                }
                case VECTOR64: {
                    DebugValue.DebugVector64Value vector64 = (DebugValue.DebugVector64Value)value;
                    into.u.VI8 = vector64.vi4();
                    break;
                }
                case VECTOR128: {
                    DebugValue.DebugVector128Value vector128 = (DebugValue.DebugVector128Value)value;
                    into.u.VI8 = vector128.vi8();
                    break;
                }
                default: {
                    throw new AssertionError((Object)"INTERNAL: Shouldn't be here");
                }
            }
        }

        public static class UNION
        extends Union {
            public WinDef.UCHAR I8;
            public WinDef.USHORT I16;
            public WinDef.ULONG I32;
            public INTEGER64 I64;
            public float F32;
            public double F64;
            public byte[] F80Bytes = new byte[10];
            public byte[] F82Bytes = new byte[11];
            public byte[] F128Bytes = new byte[16];
            public byte[] VI8 = new byte[16];
            public short[] VI16 = new short[8];
            public int[] VI32 = new int[4];
            public long[] VI64 = new long[2];
            public float[] VF32 = new float[4];
            public double[] VF64 = new double[2];
            public I64Parts32 I64Parts32;
            public F128Parts64 F128Parts64;
            public byte[] RawBytes = new byte[24];

            public static class F128Parts64
            extends Structure {
                public static final List<String> FIELDS = agent.dbgeng.jna.dbgeng.DbgEngNative$DEBUG_VALUE$UNION$F128Parts64.createFieldsOrder((String[])new String[]{"LowPart", "HighPart"});
                public WinDef.ULONGLONG LowPart;
                public WinDef.LONGLONG HighPart;

                protected List<String> getFieldOrder() {
                    return FIELDS;
                }

                public static class ByReference
                extends UNION
                implements Structure.ByReference {
                }
            }

            public static class I64Parts32
            extends Structure {
                public static final List<String> FIELDS = agent.dbgeng.jna.dbgeng.DbgEngNative$DEBUG_VALUE$UNION$I64Parts32.createFieldsOrder((String[])new String[]{"LowPart", "HighPart"});
                public WinDef.ULONG LowPart;
                public WinDef.ULONG HighPart;

                protected List<String> getFieldOrder() {
                    return FIELDS;
                }

                public static class ByReference
                extends UNION
                implements Structure.ByReference {
                }
            }

            public static class INTEGER64
            extends Structure {
                public static final List<String> FIELDS = INTEGER64.createFieldsOrder((String[])new String[]{"I64", "Nat"});
                public WinDef.ULONGLONG I64;
                public WinDef.BOOL Nat;

                protected List<String> getFieldOrder() {
                    return FIELDS;
                }

                public static class ByReference
                extends UNION
                implements Structure.ByReference {
                }
            }

            public static class ByReference
            extends UNION
            implements Structure.ByReference {
            }
        }

        public static class ByReference
        extends DEBUG_VALUE
        implements Structure.ByReference {
        }
    }

    public static class DEBUG_REGISTER_DESCRIPTION
    extends Structure {
        public static final List<String> FIELDS = DEBUG_REGISTER_DESCRIPTION.createFieldsOrder((String[])new String[]{"Type", "Flags", "SubregMaster", "SubregLength", "SubregMask", "SubregShift", "Reserved0"});
        public WinDef.ULONG Type;
        public WinDef.ULONG Flags;
        public WinDef.ULONG SubregMaster;
        public WinDef.ULONG SubregLength;
        public WinDef.ULONGLONG SubregMask;
        public WinDef.ULONG SubregShift;
        public WinDef.ULONG Reserved0;

        protected List<String> getFieldOrder() {
            return FIELDS;
        }

        public static class ByReference
        extends DEBUG_REGISTER_DESCRIPTION
        implements Structure.ByReference {
        }
    }

    public static class DEBUG_BREAKPOINT_PARAMETERS
    extends Structure {
        public static final List<String> FIELDS = DEBUG_BREAKPOINT_PARAMETERS.createFieldsOrder((String[])new String[]{"Offset", "Id", "BreakType", "ProcType", "Flags", "DataSize", "DataAccessType", "PassCount", "CurrentPassCount", "MatchThread", "CommandSize", "OffsetExpressionSize"});
        public WinDef.ULONGLONG Offset;
        public WinDef.ULONG Id;
        public WinDef.ULONG BreakType;
        public WinDef.ULONG ProcType;
        public WinDef.ULONG Flags;
        public WinDef.ULONG DataSize;
        public WinDef.ULONG DataAccessType;
        public WinDef.ULONG PassCount;
        public WinDef.ULONG CurrentPassCount;
        public WinDef.ULONG MatchThread;
        public WinDef.ULONG CommandSize;
        public WinDef.ULONG OffsetExpressionSize;

        protected List<String> getFieldOrder() {
            return FIELDS;
        }

        public static class ByReference
        extends DEBUG_BREAKPOINT_PARAMETERS
        implements Structure.ByReference {
        }
    }
}

