/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.manager.cmd;

import agent.dbgeng.dbgeng.DebugBreakpoint;
import agent.dbgeng.dbgeng.DebugControl;
import agent.dbgeng.manager.breakpoint.DbgBreakpointInfo;
import agent.dbgeng.manager.breakpoint.DbgBreakpointType;
import agent.dbgeng.manager.cmd.AbstractDbgCommand;
import agent.dbgeng.manager.cmd.DbgPendingCommand;
import agent.dbgeng.manager.impl.DbgManagerImpl;
import ghidra.comm.util.BitmaskSet;

public class DbgInsertBreakpointCommand
extends AbstractDbgCommand<DbgBreakpointInfo> {
    private final DbgBreakpointType type;
    private DbgBreakpointInfo bkpt;
    private int len;
    private final String expression;
    private final Long loc;

    public DbgInsertBreakpointCommand(DbgManagerImpl manager, String expression, DbgBreakpointType type) {
        super(manager);
        this.type = type;
        this.expression = expression;
        this.loc = null;
    }

    public DbgInsertBreakpointCommand(DbgManagerImpl manager, long loc, int len, DbgBreakpointType type) {
        super(manager);
        this.len = len;
        this.type = type;
        this.expression = null;
        this.loc = loc;
    }

    @Override
    public DbgBreakpointInfo complete(DbgPendingCommand<?> pending) {
        return this.bkpt;
    }

    @Override
    public void invoke() {
        DebugControl control = this.manager.getControl();
        DebugBreakpoint.BreakType bt = DebugBreakpoint.BreakType.DATA;
        if (this.type.equals((Object)DbgBreakpointType.BREAKPOINT)) {
            bt = DebugBreakpoint.BreakType.CODE;
        }
        DebugBreakpoint bp = control.addBreakpoint(bt);
        if (bt.equals((Object)DebugBreakpoint.BreakType.DATA)) {
            BitmaskSet access = BitmaskSet.of((Enum[])new DebugBreakpoint.BreakAccess[]{DebugBreakpoint.BreakAccess.EXECUTE});
            if (this.type.equals((Object)DbgBreakpointType.ACCESS_WATCHPOINT)) {
                access = BitmaskSet.of((Enum[])new DebugBreakpoint.BreakAccess[]{DebugBreakpoint.BreakAccess.READ, DebugBreakpoint.BreakAccess.WRITE});
            }
            if (this.type.equals((Object)DbgBreakpointType.READ_WATCHPOINT)) {
                access = BitmaskSet.of((Enum[])new DebugBreakpoint.BreakAccess[]{DebugBreakpoint.BreakAccess.READ});
            }
            if (this.type.equals((Object)DbgBreakpointType.HW_WATCHPOINT)) {
                access = BitmaskSet.of((Enum[])new DebugBreakpoint.BreakAccess[]{DebugBreakpoint.BreakAccess.WRITE});
            }
            if (this.type.equals((Object)DbgBreakpointType.HW_BREAKPOINT)) {
                access = BitmaskSet.of((Enum[])new DebugBreakpoint.BreakAccess[]{DebugBreakpoint.BreakAccess.EXECUTE});
                this.len = 1;
            }
            bp.setDataParameters(this.len, (BitmaskSet<DebugBreakpoint.BreakAccess>)access);
        }
        if (this.loc != null) {
            bp.setOffset(this.loc);
        } else {
            bp.setOffsetExpression(this.expression);
        }
        bp.addFlags(DebugBreakpoint.BreakFlags.ENABLED);
        this.bkpt = new DbgBreakpointInfo(bp, this.manager.getCurrentProcess());
    }
}

