/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.manager.cmd;

import agent.dbgeng.jna.dbgeng.Kernel32Extra;
import agent.dbgeng.jna.dbgeng.ToolhelpUtil;
import agent.dbgeng.manager.cmd.AbstractDbgCommand;
import agent.dbgeng.manager.cmd.DbgPendingCommand;
import agent.dbgeng.manager.impl.DbgManagerImpl;
import ghidra.comm.util.BitmaskSet;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class DbgListAvailableProcessesCommand
extends AbstractDbgCommand<List<Pair<Integer, String>>> {
    private ToolhelpUtil.Snapshot snap;

    public DbgListAvailableProcessesCommand(DbgManagerImpl manager) {
        super(manager);
    }

    @Override
    public List<Pair<Integer, String>> complete(DbgPendingCommand<?> pending) {
        ArrayList<Pair<Integer, String>> result = new ArrayList<Pair<Integer, String>>();
        for (Kernel32Extra.PROCESSENTRY32W proc : this.snap.getProcesses()) {
            int pid = proc.th32ProcessID.intValue();
            char[] name = proc.szExeFile;
            String exe = new String(name);
            result.add((Pair<Integer, String>)new ImmutablePair((Object)pid, (Object)exe));
        }
        return result;
    }

    @Override
    public void invoke() {
        this.snap = ToolhelpUtil.createSnapshot((BitmaskSet<ToolhelpUtil.SnapshotFlags>)BitmaskSet.of((Enum[])new ToolhelpUtil.SnapshotFlags[]{ToolhelpUtil.SnapshotFlags.PROCESS, ToolhelpUtil.SnapshotFlags.THREAD}), 0);
    }
}

