/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.manager.cmd;

import agent.dbgeng.dbgeng.DebugControl;
import agent.dbgeng.manager.DbgEvent;
import agent.dbgeng.manager.DbgThread;
import agent.dbgeng.manager.cmd.AbstractDbgCommand;
import agent.dbgeng.manager.cmd.DbgPendingCommand;
import agent.dbgeng.manager.evt.AbstractDbgCompletedCommandEvent;
import agent.dbgeng.manager.evt.DbgConsoleOutputEvent;
import agent.dbgeng.manager.impl.DbgManagerImpl;
import agent.dbgeng.manager.impl.DbgThreadImpl;
import ghidra.util.Msg;
import java.math.BigInteger;

public class DbgResolveThreadCommand
extends AbstractDbgCommand<DbgThread> {
    private DbgThreadImpl thread;
    private Long offset;

    public DbgResolveThreadCommand(DbgManagerImpl manager, DbgThread thread) {
        super(manager);
        this.thread = (DbgThreadImpl)thread;
    }

    @Override
    public boolean handle(DbgEvent<?> evt, DbgPendingCommand<?> pending) {
        if (evt instanceof AbstractDbgCompletedCommandEvent && pending.getCommand().equals(this)) {
            return true;
        }
        if (evt instanceof DbgConsoleOutputEvent) {
            pending.steal(evt);
        }
        return false;
    }

    @Override
    public DbgThread complete(DbgPendingCommand<?> pending) {
        StringBuilder builder = new StringBuilder();
        for (DbgConsoleOutputEvent out : pending.findAllOf(DbgConsoleOutputEvent.class)) {
            builder.append(out.getOutput());
        }
        this.parse(builder.toString());
        return this.thread;
    }

    private void parse(String result) {
        String[] lines = result.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            if (!line.contains("THREAD")) continue;
            String[] fields = line.trim().split("\\s+");
            if (fields.length <= 4 || !fields[0].equals("THREAD")) break;
            BigInteger val = new BigInteger(fields[1], 16);
            this.offset = val.longValue();
            this.thread.setOffset(this.offset);
            String[] split = fields[3].split("\\.");
            if (split.length != 2) break;
            Long tid = Long.parseLong(split[1], 16);
            this.thread.setTid(tid);
            break;
        }
        if (this.offset == null) {
            Msg.error((Object)this, (Object)result);
        }
    }

    @Override
    public void invoke() {
        DebugControl control = this.manager.getControl();
        Long key = this.thread.getOffset() != null ? this.thread.getOffset() : this.thread.getTid();
        control.execute("!thread " + Long.toHexString(key) + " 0");
    }
}

